/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.AutoDeployOperationData;
import com.vmware.vide.deploy.DeployExportSettingsWizard;
import com.vmware.vide.deploy.FileDeployUtilities;
import com.vmware.vide.deploy.IAutoDeployOperationsDatabase;
import com.vmware.vide.deploy.WizardExportResourcesPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.actions.SystemSelectRemoteFolderAction;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.importexport.files.Utilities;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;

public class WizardDeployFileExportPage2
extends WizardExportResourcesPage
implements Listener {
    private static final String STORE_DESTINATION_NAMES_ID = "WizardDeployFileExportPage2.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "WizardDeployFileExportPage2.STORE_CREATE_STRUCTURE_ID";
    private static final String FILE_DEPLOY_EXPORT_WIZARD_PAGE2_TITLE = "File Deploy Settings";
    private static final String FILE_DEPLOY_EXPORT_WIZARD_PAGE2_DESCRIPTION = "Configure the file deploy settings. Specify resources (i.e. files or file trees) to be deployed, a target location where the resources are deployed and name the operation.";
    private static final String THIS_PAGE_NAME = "fileDeployExportPage2";
    private static final String TARGET_LOCATION_LABEL = "Target Location: ";
    private static final String TARGET_TYPE_LABEL = "Target Type: ";
    private static final String[] TARGET_TYPE_NAMES = new String[]{"Unknown", "ESX", "Linux", "Localhost"};
    public static final String NAME_TARGET_LOCCATION = "combo_targetLocation";
    public static final String NAME_OPERATIONS = "combo_operations";
    public static final String NAME_TARGET_TYPE = "target_type";
    private IStructuredSelection initialResourceSelection;
    private Combo destinationNameField;
    private Button destinationBrowseButton;
    private Combo targetTypeCombo;
    protected Button createDirectoryStructureButton;
    protected Button createSelectionOnlyButton;
    private Text operationName;
    private final AutoDeployOperationData data;
    private final IAutoDeployOperationsDatabase database;

    public WizardDeployFileExportPage2(IStructuredSelection selection, IAutoDeployOperationsDatabase database, AutoDeployOperationData data) {
        super(THIS_PAGE_NAME, selection);
        this.initialResourceSelection = selection;
        this.setTitle(FILE_DEPLOY_EXPORT_WIZARD_PAGE2_TITLE);
        this.setDescription(FILE_DEPLOY_EXPORT_WIZARD_PAGE2_DESCRIPTION);
        this.database = database;
        this.data = data;
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createResourcesGroup(composite);
        this.createButtonsGroup(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.createOperationsGroup(composite);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.initialResourceSelection != null) {
            this.setupBasedOnInitialSelections();
        }
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
        this.giveFocusToDestination();
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        Font font = optionsGroup.getFont();
        this.createDirectoryStructureButton = new Button((Composite)optionsGroup, 16400);
        this.createDirectoryStructureButton.setText(DataTransferMessages.FileExport_createDirectoryStructure);
        this.createDirectoryStructureButton.setSelection(false);
        this.createDirectoryStructureButton.setFont(font);
        this.createSelectionOnlyButton = new Button((Composite)optionsGroup, 16400);
        this.createSelectionOnlyButton.setText(DataTransferMessages.FileExport_createSelectedDirectories);
        this.createSelectionOnlyButton.setSelection(true);
        this.createSelectionOnlyButton.setFont(font);
    }

    private void createOperationsGroup(Composite parent) {
        Group operationsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        operationsGroup.setLayout((Layout)layout);
        operationsGroup.setLayoutData((Object)new GridData(768));
        operationsGroup.setText("File deploy operation name");
        operationsGroup.setFont(parent.getFont());
        Composite operationsComposite = new Composite((Composite)operationsGroup, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        operationsComposite.setLayout((Layout)groupLayout);
        operationsComposite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(operationsComposite, 0);
        label.setText("New operation");
        this.operationName = new Text(operationsComposite, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        this.operationName.setLayoutData((Object)gd);
        this.operationName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardDeployFileExportPage2.this.updatePageCompletion();
                WizardDeployFileExportPage2.this.data.setName(WizardDeployFileExportPage2.this.operationName.getText().trim());
            }
        });
        this.operationName.setData("name", (Object)NAME_OPERATIONS);
    }

    @Override
    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            settings.put(STORE_CREATE_STRUCTURE_ID, this.createDirectoryStructureButton.getSelection());
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        this.operationName.setText(this.data.getName());
        this.setDestinationItems(this.data, settings);
        DeployExportSettingsWizard w = (DeployExportSettingsWizard)this.getWizard();
        if (w.isNewWizard()) {
            if (settings != null) {
                boolean createDirectories = settings.getBoolean(STORE_CREATE_STRUCTURE_ID);
                this.createDirectoryStructureButton.setSelection(createDirectories);
                this.createSelectionOnlyButton.setSelection(!createDirectories);
            }
        } else {
            boolean b = this.data.getCreateEntireDirs();
            this.createDirectoryStructureButton.setSelection(b);
            this.createSelectionOnlyButton.setSelection(!b);
            this.setDestinationValue(this.data.getTargetDestination());
            this.setAllSelections(false);
            this.setInitialResources(this.data.getResources());
        }
    }

    private void setDestinationItems(AutoDeployOperationData d, IDialogSettings settings) {
        String[] dests;
        if (settings != null && (dests = settings.getArray(STORE_DESTINATION_NAMES_ID)) != null) {
            boolean found = false;
            int i = 0;
            while (i < dests.length) {
                this.addDestinationItem(dests[i]);
                if (dests[i].equals(d.getTargetDestination())) {
                    found = true;
                    this.destinationNameField.select(i);
                }
                ++i;
            }
            if (!found) {
                if (d.getTargetDestination().isEmpty()) {
                    if (this.destinationNameField.getItemCount() != 0) {
                        this.destinationNameField.select(0);
                    }
                } else {
                    this.addDestinationItem(d.getTargetDestination());
                    this.destinationNameField.select(this.destinationNameField.getItemCount() - 1);
                }
            }
        }
    }

    @Override
    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(TARGET_LOCATION_LABEL);
        destinationLabel.setFont(font);
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        this.destinationNameField.setLayoutData((Object)gd);
        this.destinationNameField.setFont(font);
        this.destinationNameField.setData("name", (Object)NAME_TARGET_LOCCATION);
        this.destinationNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String dst = WizardDeployFileExportPage2.this.getDestinationValue();
                WizardDeployFileExportPage2.this.data.setTargetDestination(dst);
                String type = FileDeployUtilities.getDestinationTargetType(dst, WizardDeployFileExportPage2.this.database.getAllFileDeployExportDataReaders());
                WizardDeployFileExportPage2.this.targetTypeCombo.select(WizardDeployFileExportPage2.this.getTargetTypeIndex(type));
                WizardDeployFileExportPage2.this.data.setTargetType(type);
            }
        });
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText(DataTransferMessages.DataTransfer_browse);
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.destinationBrowseButton.setFont(font);
        this.setButtonLayoutData(this.destinationBrowseButton);
        Label targetTypeLabel = new Label(destinationSelectionGroup, 0);
        targetTypeLabel.setText(TARGET_TYPE_LABEL);
        targetTypeLabel.setFont(font);
        this.targetTypeCombo = new Combo(destinationSelectionGroup, 12);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.targetTypeCombo.setLayoutData((Object)gd);
        this.targetTypeCombo.setData("name", (Object)NAME_TARGET_TYPE);
        this.targetTypeCombo.setItems(TARGET_TYPE_NAMES);
        this.targetTypeCombo.select(0);
        this.targetTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardDeployFileExportPage2.this.data.setTargetType(WizardDeployFileExportPage2.this.getTargetTypeByIndex(WizardDeployFileExportPage2.this.targetTypeCombo.getSelectionIndex()));
            }
        });
    }

    private void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    public String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    private void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    private void setDestinationValue(String value) {
        this.destinationNameField.setText(value);
    }

    private int getTargetTypeIndex(String type) {
        if ("esx".equals(type)) {
            return 1;
        }
        if ("ssh".equals(type) || "linux".equals(type)) {
            return 2;
        }
        if ("localhost".equals(type)) {
            return 3;
        }
        return 0;
    }

    private String getTargetTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "esx";
            }
            case 2: {
                return "ssh";
            }
            case 3: {
                return "localhost";
            }
        }
        return "unknown";
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    protected void handleDestinationBrowseButtonPressed() {
        SystemSelectRemoteFolderAction action = new SystemSelectRemoteFolderAction(this.getShell());
        action.setShowNewConnectionPrompt(true);
        action.setFoldersOnly(true);
        action.setShowPropertySheet(true, false);
        String destValue = this.getDestinationValue();
        if (destValue != null) {
            IHost host = Utilities.parseForSystemConnection((String)destValue);
            IRemoteFile path = Utilities.parseForIRemoteFile((String)destValue);
            action.setDefaultConnection(host);
            action.setPreSelection(path);
        }
        action.run();
        IRemoteFile folder = action.getSelectedFolder();
        if (folder != null) {
            UniFilePlus destinationFolder = new UniFilePlus(folder);
            destValue = FileDeployUtilities.getTargetFolderName(destinationFolder);
            this.setDestinationValue(destValue);
        }
    }

    public boolean finish() {
        this.saveWidgetValues();
        return true;
    }

    protected boolean validateDestinationGroup() {
        boolean valid = true;
        StringBuffer errorMessage = new StringBuffer();
        String destination = this.getDestinationValue();
        if (destination.isEmpty()) {
            errorMessage.append("Destination is not specified.\n");
            valid = false;
        } else {
            int index = destination.indexOf(58);
            if (index < 0 || index >= destination.length() - 1) {
                errorMessage.append("The destination [" + destination + "] is formatted incorrectly. Please specify with the form remotehost:folder.\n");
                valid = false;
            }
        }
        if (this.getWhiteCheckedResources().isEmpty()) {
            errorMessage.append("No resource is specified.\n");
            valid = false;
        }
        if (this.getOperationName().isEmpty()) {
            errorMessage.append("Missing operation name.\n");
            valid = false;
        }
        if (!valid) {
            this.setErrorMessage(errorMessage.toString());
        }
        return valid;
    }

    public String getOperationName() {
        return this.operationName.getText().trim();
    }

    public ArrayList<IResource> getResources() {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        List<IResource> list = this.getWhiteCheckedResources();
        for (IResource o : list) {
            if (!(o instanceof IResource)) continue;
            resources.add(o);
        }
        return resources;
    }

    public boolean getCreateDirectoryStructureOption() {
        return this.createDirectoryStructureButton.getSelection();
    }

    public String getTargetType() {
        return FileDeployUtilities.getDestinationTargetType(this.getShell(), this.getDestinationValue(), this.database.getAllFileDeployExportDataReaders());
    }

    @Override
    protected void updateWidgetEnablements() {
        super.updateWidgetEnablements();
        this.data.setResources(this.getResources());
    }
}

