/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.jdt.project;

import com.vmware.vide.jdt.JavaDevPlugin;
import com.vmware.vide.project.config.devkit.ProjectNatureInfo;
import com.vmware.vide.project.manager.AbstractProjectIdentity;
import com.vmware.vide.project.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathAttribute;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;

public class JavaDevProjectIdentity
extends AbstractProjectIdentity {
    private static final ILog logger = JavaDevPlugin.getDefault().getLog();
    private static final String KEY_CLASS_LIBRARY_PATHS = "CLASS_LIBRARY_PATHS";
    private static final String KEY_CLASS_LIBRARY_PATHS_ATTRS = "CLASS_LIBRARY_PATHS_ATTRS";
    private static final String KEY_SRC_PATHS = "SRC_PATHS";
    private static final String KEY_OUTPUT_PATH = "OUTPUT_PATH";
    private static final String KEY_CLASS_CONTAINER_PATHS = "CLASS_CONTAINER_PATHS";
    private static final String KEY_SYSTEM_CONTAINER = "SYSTEM_CONTAINER";
    private static final String DEFAULT_JAVA_EE = "DefaultJavaEE";
    private static final String DEFAULT_INSTALLED_JRE = "DefaultInstalledJRE";

    public String getProjectNatureID() {
        return "org.eclipse.jdt.core.javanature";
    }

    public String getProjectPerspectiveID() {
        return "org.eclipse.jdt.ui.JavaPerspective";
    }

    public IProject createIProject(String projectname, String projectpath, Map<String, String> properties, IProgressMonitor monitor) throws Exception {
        IFolder folder;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectname);
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(projectname);
        if (!Platform.getLocation().equals((Object)new Path(projectpath).removeLastSegments(1))) {
            desc.setLocation((IPath)new Path(projectpath));
        }
        project.create(desc, null);
        project.open(null);
        IPath projectPath = project.getFullPath();
        String[] natures = new String[]{"org.eclipse.jdt.core.javanature"};
        desc.setNatureIds(natures);
        project.setDescription(desc, null);
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        entries.addAll(this.getSrcPaths(project, properties));
        entries.addAll(this.getSystemContainers(properties));
        entries.addAll(this.getContainerPaths(project, properties));
        entries.addAll(this.getLibraryPaths(project, properties));
        String outputDir = properties.get(KEY_OUTPUT_PATH);
        Path outputPath = new Path("");
        if (outputDir != null && !outputDir.isEmpty() && !(folder = project.getFolder((IPath)(outputPath = new Path(outputDir = Utils.replaceContent((String)outputDir, properties))))).exists()) {
            folder.create(true, true, null);
        }
        outputPath = projectPath.append((IPath)outputPath);
        JavaProject javaProject = (JavaProject)JavaCore.create((IProject)project);
        IClasspathEntry[] classpathEntries = entries.toArray(new IClasspathEntry[entries.size()]);
        javaProject.setRawClasspath(classpathEntries, (IPath)outputPath, monitor);
        return project;
    }

    public void configureProject(IProject project, File projectfile, ProjectNatureInfo[] vmwareprojectnatures, Map<String, String> properties, boolean onFinish, IProgressMonitor monitor) throws Exception {
    }

    private List<IClasspathEntry> getSrcPaths(IProject project, Map<String, String> properties) throws CoreException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        IPath projectPath = project.getFullPath();
        String srcPathNameList = properties.get(KEY_SRC_PATHS);
        if (srcPathNameList != null) {
            srcPathNameList = Utils.replaceContent((String)srcPathNameList, properties);
            PathsStringParser parser = new PathsStringParser(srcPathNameList);
            parser.parse();
            if (!parser.errors.isEmpty()) {
                System.err.println(parser.errors);
            }
            for (List<String> paths : parser.result) {
                if (paths.get(0).isEmpty()) continue;
                Path srcPath = new Path(paths.get(0));
                Path outPath = null;
                this.createFolder(project, (IPath)srcPath);
                if (paths.size() > 1) {
                    outPath = new Path(paths.get(1));
                    if (outPath.segmentCount() > 0) {
                        this.createFolder(project, (IPath)outPath);
                    }
                    outPath = projectPath.append((IPath)outPath);
                }
                entries.add(JavaCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath), (IPath[])new IPath[0], (IPath)outPath));
            }
        }
        return entries;
    }

    private void createFolder(IProject project, IPath path) throws CoreException {
        IProject container = project;
        int i = 0;
        while (i < path.segmentCount()) {
            IFolder folder = container.getFolder((IPath)new Path(path.segment(i)));
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            container = folder;
            ++i;
        }
    }

    private List<IClasspathEntry> getLibraryPaths(IProject project, Map<String, String> properties) throws CoreException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        IPath projectPath = project.getFullPath();
        String libPathNameList = properties.get(KEY_CLASS_LIBRARY_PATHS);
        if (libPathNameList != null && !libPathNameList.isEmpty()) {
            String[] libs;
            libPathNameList = Utils.replaceContent((String)libPathNameList, properties);
            String[] stringArray = libs = libPathNameList.split("\\s*,\\s*");
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                String lib = stringArray[n2];
                if (!lib.isEmpty()) {
                    Path libPath = new Path(lib);
                    if (!libPath.isAbsolute()) {
                        libPath = projectPath.append((IPath)libPath);
                    }
                    entries.add(JavaCore.newLibraryEntry((IPath)libPath, null, null));
                }
                ++n2;
            }
        }
        if ((libPathNameList = properties.get(KEY_CLASS_LIBRARY_PATHS_ATTRS)) != null && !libPathNameList.isEmpty()) {
            libPathNameList = Utils.replaceContent((String)libPathNameList, properties);
            PathsStringParser parser = new PathsStringParser(libPathNameList);
            parser.parse();
            if (!parser.errors.isEmpty()) {
                System.err.println(parser.errors);
            }
            for (List<String> block : parser.result) {
                String path;
                if (block.isEmpty() || (path = block.get(0)).isEmpty()) continue;
                Path libPath = new Path(path);
                if (!libPath.isAbsolute()) {
                    libPath = projectPath.append((IPath)libPath);
                }
                ArrayList<IClasspathAttribute> attrs = new ArrayList<IClasspathAttribute>();
                if (block.size() > 1) {
                    int i = 1;
                    while (i + 1 < block.size()) {
                        String name = block.get(i);
                        if (!name.isEmpty()) {
                            String value = block.get(i + 1);
                            attrs.add(JavaCore.newClasspathAttribute((String)name, (String)value));
                        }
                        i += 2;
                    }
                }
                entries.add(JavaCore.newLibraryEntry((IPath)libPath, null, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])attrs.toArray(new IClasspathAttribute[attrs.size()]), (boolean)false));
            }
        }
        return entries;
    }

    private List<IClasspathEntry> getSystemContainers(Map<String, String> properties) {
        IExecutionEnvironment[] ees;
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        String systemContainer = properties.get(KEY_SYSTEM_CONTAINER);
        if (systemContainer != null && systemContainer.equals(DEFAULT_INSTALLED_JRE)) {
            IClasspathEntry entry = JavaRuntime.getDefaultJREContainerEntry();
            if (entry == null) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.jdt", "Default JRE was not specified."));
            } else {
                entries.add(JavaCore.newContainerEntry((IPath)entry.getPath()));
            }
            return entries;
        }
        String javaEE = null;
        javaEE = systemContainer == null || systemContainer.isEmpty() || systemContainer.equals(DEFAULT_JAVA_EE) ? this.getDefaultEE() : systemContainer;
        IExecutionEnvironment[] iExecutionEnvironmentArray = ees = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        int n = ees.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment ee = iExecutionEnvironmentArray[n2];
            if (ee.getId().equals(javaEE)) {
                IPath path = JavaRuntime.newJREContainerPath((IExecutionEnvironment)ee);
                entries.add(JavaCore.newContainerEntry((IPath)path));
                break;
            }
            ++n2;
        }
        if (entries.isEmpty()) {
            String msg = String.format("Java Execution Environment [%s] was not found.", javaEE);
            logger.log((IStatus)new Status(4, "com.vmware.vide.jdt", msg));
        }
        return entries;
    }

    private String getDefaultEE() {
        int n;
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        IExecutionEnvironment[] ees = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        if (defaultVM != null) {
            IExecutionEnvironment[] iExecutionEnvironmentArray = ees;
            n = ees.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutionEnvironment ee = iExecutionEnvironmentArray[n2];
                IVMInstall eeDefaultVM = ee.getDefaultVM();
                if (eeDefaultVM != null && defaultVM.getId().equals(eeDefaultVM.getId())) {
                    return ee.getId();
                }
                ++n2;
            }
        }
        String defaultCC = "1.4";
        if (defaultVM instanceof IVMInstall2 && ((IVMInstall2)defaultVM).getJavaVersion() != null) {
            defaultCC = ((IVMInstall2)defaultVM).getJavaVersion();
        }
        IExecutionEnvironment[] iExecutionEnvironmentArray = ees;
        int n3 = ees.length;
        n = 0;
        while (n < n3) {
            String executionEnvironmentCC;
            Object o;
            IExecutionEnvironment ee = iExecutionEnvironmentArray[n];
            Map options = ee.getComplianceOptions();
            if (options != null && (o = options.get("org.eclipse.jdt.core.compiler.compliance")) instanceof String && (executionEnvironmentCC = (String)o).endsWith(defaultCC)) {
                return ee.getId();
            }
            ++n;
        }
        return "JavaSE-1.7";
    }

    private List<IClasspathEntry> getContainerPaths(IProject project, Map<String, String> properties) {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        String pathNameList = properties.get(KEY_CLASS_CONTAINER_PATHS);
        if (pathNameList != null && !pathNameList.isEmpty()) {
            pathNameList = Utils.replaceContent((String)pathNameList, properties);
            PathsStringParser parser = new PathsStringParser(pathNameList);
            parser.parse();
            for (List<String> elems : parser.result) {
                if (elems.isEmpty() || elems.get(0).isEmpty()) continue;
                ArrayList<ClasspathAttribute> attrs = new ArrayList<ClasspathAttribute>();
                if (elems.size() > 1) {
                    int i = 1;
                    while (i + 1 < elems.size()) {
                        if (!elems.get(i).isEmpty()) {
                            attrs.add(new ClasspathAttribute(elems.get(i), elems.get(i + 1)));
                        }
                        i += 2;
                    }
                }
                IClasspathEntry entry = JavaCore.newContainerEntry((IPath)new Path(elems.get(0)), (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])attrs.toArray(new IClasspathAttribute[attrs.size()]), (boolean)false);
                entries.add(entry);
            }
        }
        return entries;
    }

    class PathsStringParser {
        private final String pathsString;
        List<List<String>> result;
        List<String> errors;
        int index = 0;
        int postSpaces = 0;
        char quoted;

        PathsStringParser(String pathsString) {
            this.pathsString = pathsString;
        }

        void parse() {
            this.errors = new ArrayList<String>();
            this.result = new ArrayList<List<String>>();
            ArrayList<String> block = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            while (this.hasNext()) {
                char c = this.next();
                if (this.isQuoted()) {
                    if (this.isQuotedEnd(c)) {
                        this.quoted = '\u0000';
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (c == ';') {
                    this.processBlock(sb, block);
                    sb.setLength(0);
                    block = new ArrayList();
                    continue;
                }
                if (c == ',') {
                    this.trimPostSpaces(sb);
                    block.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    if (sb.length() == 0) continue;
                    sb.append(c);
                    ++this.postSpaces;
                    continue;
                }
                if (c == '\\') {
                    if (this.hasNext()) {
                        sb.append(this.next());
                    }
                    this.postSpaces = 0;
                    continue;
                }
                if (c == '\"' || c == '\'') {
                    this.startQuoted(c);
                    this.postSpaces = 0;
                    continue;
                }
                sb.append(c);
                this.postSpaces = 0;
            }
            if (this.isQuoted()) {
                this.errors.add(String.format("Unmatched [%c] in [%s].", Character.valueOf(this.quoted), this.pathsString));
            }
            this.processBlock(sb, block);
        }

        void processBlock(StringBuilder sb, List<String> block) {
            this.trimPostSpaces(sb);
            block.add(sb.toString());
            this.result.add(block);
        }

        void trimPostSpaces(StringBuilder sb) {
            if (this.postSpaces != 0) {
                sb.setLength(sb.length() - this.postSpaces);
                this.postSpaces = 0;
            }
        }

        void startQuoted(char c) {
            this.quoted = c;
        }

        boolean isQuotedEnd(char c) {
            return (c == '\"' || c == '\'') && c == this.quoted;
        }

        boolean isQuoted() {
            return this.quoted != '\u0000';
        }

        boolean hasNext() {
            return this.pathsString.length() > this.index;
        }

        char next() {
            return this.pathsString.charAt(this.index++);
        }
    }
}

