/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.devkit;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.init.InitPlugin;
import com.vmware.vide.project.config.devkit.ProjectNatureInfo;
import com.vmware.vide.project.config.devkit.ProjectProperty;
import com.vmware.vide.project.config.resource.AbstractProjectResource;
import com.vmware.vide.project.manager.AbstractProjectIdentity;
import com.vmware.vide.project.manager.ProjectManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;

public class DevkitInfo {
    private static final String KEYPATH_PROJECTNATURE = "project.projectnature";
    private final String devkitid;
    private final String devkittype;
    private final String devkitname;
    private final String devkitdesc;
    private final String devkitversion;
    private Hashtable<String, ProjectNatureInfo> projectnatures;
    private final Hashtable<String, AbstractProjectResource> resources = new Hashtable();
    private final AbstractProjectIdentity projectidentity;

    public DevkitInfo(String id, String type, String name, String version, String projectidentityid, String desc) throws Exception {
        this.devkitid = id;
        if (this.devkitid == null || this.devkitid.isEmpty()) {
            throw new Exception("Invalid devlopment kit ID");
        }
        this.devkittype = type;
        this.devkitname = name;
        this.devkitversion = version;
        this.devkitdesc = desc;
        this.projectidentity = ProjectManager.getProjectIdentity(projectidentityid);
        if (this.projectidentity == null) {
            throw new Exception("Unable to find a matched project identity extension");
        }
        this.setProjectNatures();
    }

    public DevkitInfo(String id, Map<String, String> values) throws Exception {
        this(id, ConfigUtil.lookupString(values, (String)"type"), ConfigUtil.lookupString(values, (String)"name"), ConfigUtil.lookupString(values, (String)"version"), ConfigUtil.lookupString(values, (String)"projectidentity"), ConfigUtil.lookupString(values, (String)"description"));
    }

    public String getId() {
        return this.devkitid;
    }

    public String getType() {
        return this.devkittype;
    }

    public String getName() {
        return this.devkitname;
    }

    public String getVersion() {
        return this.devkitversion;
    }

    public String getDescription() {
        return this.devkitdesc;
    }

    public AbstractProjectIdentity getProjectIdentity() {
        return this.projectidentity;
    }

    public String getDevkitProjectRootPath(String natureid) {
        if (this.projectnatures.containsKey(natureid)) {
            return this.projectnatures.get(natureid).getProperty(ProjectProperty.getProjectRootPathPropertyID());
        }
        return null;
    }

    public LinkedHashMap<String, ProjectProperty> getOrderedProjectProperties(String[] natureids) {
        LinkedHashMap<String, ProjectProperty> properties = new LinkedHashMap<String, ProjectProperty>();
        String[] stringArray = natureids;
        int n = natureids.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectNatureInfo pni;
            LinkedHashMap<String, ProjectProperty> props;
            String natureid = stringArray[n2];
            if (this.projectnatures.containsKey(natureid) && (props = (pni = this.projectnatures.get(natureid)).getOrderedProjectProperties()) != null && props.size() > 0) {
                properties.putAll(props);
            }
            ++n2;
        }
        return properties;
    }

    public boolean updateProjectNature(String[] natureids, IProject project, File projectfile) {
        boolean success = true;
        String[] stringArray = natureids;
        int n = natureids.length;
        int n2 = 0;
        while (n2 < n) {
            String natureid = stringArray[n2];
            if (this.projectnatures.containsKey(natureid)) {
                ProjectManager.getDefault().createVMwareDevkitProjectNature(project, natureid, this.devkitid, this.devkittype);
                if (!ProjectManager.putProjectProperties(project, this.projectnatures.get(natureid).getProperties(projectfile), true)) {
                    success = false;
                }
            }
            ++n2;
        }
        return success;
    }

    public void addResource(String type, AbstractProjectResource resource) {
        if (!this.resources.containsKey(type)) {
            this.resources.put(type, resource);
        }
    }

    public AbstractProjectResource getResource(String resourceid) {
        if (this.resources.containsKey(resourceid)) {
            return this.resources.get(resourceid);
        }
        return null;
    }

    private void setProjectNatures() {
        this.projectnatures = new Hashtable();
        ArrayList natures = InitPlugin.getDefault().getAllNodeValues(this.devkitid, KEYPATH_PROJECTNATURE);
        if (natures == null || natures.size() == 0) {
            return;
        }
        int i = 0;
        while (i < natures.size()) {
            Map natureinfo = (Map)natures.get(i);
            Iterator it = natureinfo.keySet().iterator();
            while (it.hasNext()) {
                ProjectNatureInfo nature = new ProjectNatureInfo(this, natureinfo.get(it.next()));
                if (!nature.isValid()) continue;
                this.projectnatures.put(nature.getNatureId(), nature);
                break;
            }
            ++i;
        }
    }

    public Map<String, String> getSystemProperties() {
        return InitPlugin.getDefault().getSystemOptions(this.devkitid);
    }

    public ProjectNatureInfo[] getProjectNatureInfo(String[] natureids) {
        ArrayList<ProjectNatureInfo> natures = new ArrayList<ProjectNatureInfo>();
        String[] stringArray = natureids;
        int n = natureids.length;
        int n2 = 0;
        while (n2 < n) {
            String natureid = stringArray[n2];
            if (this.projectnatures.containsKey(natureid)) {
                natures.add(this.projectnatures.get(natureid));
            }
            ++n2;
        }
        return natures.toArray(new ProjectNatureInfo[natures.size()]);
    }
}

