/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.devkit;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.project.config.wizard.project.IProjectDataAccessor;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.utils.local.ArchiveUtils;
import com.vmware.vide.utils.local.FileHelper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ProjectProperty {
    private static final String NAME_VIDE_ERROR_PARSER = "VIDE_ERROR_PARSER";
    private static final String NAME_DEFAULT_BUILD_TARGET = "DEFAULT_BUILD_TARGET";
    private static final String NAME_DEFAULT_CLEAN_BUILD_TARGET = "DEFAULT_CLEAN_BUILD_TARGET";
    private static final String NAME_DEFAULT_BUILD_DIRECTORY = "DEFAULT_BUILD_DIRECTORY";
    private static final String NAME_DEVKIT_PROJECT_ROOTPATH = "DEVKIT_PROJECT_ROOTPATH";
    private static final String NAME_COMMON_INCLUDEPATH = "COMMON_INCLUDE_PATH";
    public static final String NAME_PROJECT_CREATION_TYPE = "PROJECT_CREATION_TYPE";
    public static final String PROJECT_CREATION_TYPE_NEW = "new";
    public static final String PROJECT_CREATION_TYPE_IMPORT = "import";
    public static final String PATTERN_VALUE = "{{VALUE}}";
    private static final String TAG_NAME = "name";
    private static final String TAG_TYPE = "type";
    private static final String TAG_REGEXP = "regexp";
    private static final String TAG_VALUE = "value";
    private static final String TAG_FILE = "file";
    private static final String TAG_VALUE_REGEXP = "value_regexp";
    private static final String TYPE_PROJECTFILE = "extract_from_project_file";
    private static final String TYPE_A_FILE = "extract_from_a_file";
    private static final String TYPE_FILESYSTEM = "extract_from_filesystem";
    private String[] regexps;
    private Map<String, String> contextResults = null;
    private final String file;
    String name;
    String type;
    String value;
    String value_regexp;

    public ProjectProperty(Map<String, String> properties) {
        this.name = ConfigUtil.lookupString(properties, (String)TAG_NAME);
        this.type = ConfigUtil.lookupString(properties, (String)TAG_TYPE);
        this.value = ConfigUtil.lookupString(properties, (String)TAG_VALUE);
        this.value_regexp = ConfigUtil.lookupString(properties, (String)TAG_VALUE_REGEXP);
        String regexp = ConfigUtil.lookupString(properties, (String)TAG_REGEXP);
        if (regexp != null && !regexp.isEmpty()) {
            this.regexps = regexp.indexOf(";") != -1 ? regexp.split(";") : new String[]{regexp};
        }
        this.file = ConfigUtil.lookupString(properties, (String)TAG_FILE);
    }

    public boolean isValid() {
        return this.name != null;
    }

    public boolean isDefaultBuildTarget() {
        return this.name.equals(ProjectProperty.getDefaultBuildTargetPropertyID()) && this.getValue() != null;
    }

    public boolean isDefaultCleanBuildTarget() {
        return this.name.equals(ProjectProperty.getDefaultCleanBuildTargetPropertyID()) && this.getValue() != null;
    }

    public boolean isDefaultBuildDirectory() {
        return this.name.equals(ProjectProperty.getDefaultBuildDirectoryPropertyID()) && this.getValue() != null;
    }

    public boolean isErrorParser() {
        return this.name.equals(ProjectProperty.getErrorParserPropertyID()) && this.getValue() != null;
    }

    public boolean isDevkitProjectRootPath() {
        return this.name.equals(ProjectProperty.getProjectRootPathPropertyID()) && this.getValue() != null;
    }

    public boolean isErrorParserEnabled() {
        if (this.isErrorParser()) {
            return Boolean.parseBoolean(this.value);
        }
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(IProjectDataAccessor access) {
        if (this.type != null && access != null) {
            File f;
            if (this.type.equals(TYPE_PROJECTFILE)) {
                File f2 = access.getFirstFindProjectFile();
                if (f2 != null) {
                    String result = this.getFromExistingResults(f2);
                    if (result != null) {
                        return result;
                    }
                    result = this.getValueFromFile(f2);
                    if (result != null) {
                        this.putExistingResults(f2, result);
                    }
                    return result;
                }
            } else if (this.type.equals(TYPE_A_FILE)) {
                File f3;
                if (this.file != null && (f3 = new File(Utils.replaceContent(this.file, access.getCurrentProperties()))).isFile() && f3.exists()) {
                    String result = this.getFromExistingResults(f3);
                    if (result != null) {
                        return result;
                    }
                    result = this.getValueFromFile(f3);
                    if (result != null) {
                        this.putExistingResults(f3, result);
                    }
                    return result;
                }
            } else if (this.type.equals(TYPE_FILESYSTEM) && this.file != null && (f = new File(Utils.replaceContent(this.file, access.getCurrentProperties()))).exists()) {
                String result = this.getFromExistingResults(f);
                if (result != null) {
                    return result;
                }
                result = this.getValueFromFileSystem(f);
                if (result != null) {
                    this.putExistingResults(f, result);
                }
                return result;
            }
        }
        return this.value;
    }

    private String getFromExistingResults(File f) {
        if (this.contextResults == null) {
            return null;
        }
        if (this.contextResults.containsKey(f.getAbsolutePath())) {
            return this.contextResults.get(f.getAbsolutePath());
        }
        return null;
    }

    private void putExistingResults(File f, String result) {
        if (this.contextResults == null) {
            this.contextResults = new HashMap<String, String>();
        }
        this.contextResults.put(f.getAbsolutePath(), result);
    }

    public void setValue(String updatedvalue) {
        this.value = updatedvalue;
    }

    public String getName() {
        return this.name;
    }

    private String getValueFromFile(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        String content = Utils.getFileContent(file, true);
        if (content == null || content.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.regexps.length) {
            String parsevalue = Utils.getRegExpValue(content, this.regexps[i], PATTERN_VALUE, this.value_regexp, true);
            if (parsevalue != null && !parsevalue.trim().isEmpty()) {
                return parsevalue.trim();
            }
            ++i;
        }
        return null;
    }

    private String getValueFromFileSystem(File file) {
        if (file.isDirectory()) {
            return FileHelper.findFileNamePatternLocation((File)file, (String[])this.regexps);
        }
        return ArchiveUtils.findFileNamePatternInArchive((File)file, (String[])this.regexps);
    }

    public static String getDefaultBuildTargetPropertyID() {
        return NAME_DEFAULT_BUILD_TARGET;
    }

    public static String getDefaultCleanBuildTargetPropertyID() {
        return NAME_DEFAULT_CLEAN_BUILD_TARGET;
    }

    public static String getDefaultBuildDirectoryPropertyID() {
        return NAME_DEFAULT_BUILD_DIRECTORY;
    }

    public static String getErrorParserPropertyID() {
        return NAME_VIDE_ERROR_PARSER;
    }

    public static String getProjectRootPathPropertyID() {
        return NAME_DEVKIT_PROJECT_ROOTPATH;
    }

    public static String getComonIncludePathPropertyID() {
        return NAME_COMMON_INCLUDEPATH;
    }
}

