/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.vib;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.vib.UserInputEnableCondition;
import com.vmware.vide.project.config.vib.UserInputHelper;
import com.vmware.vide.project.config.vib.UserInputHelperCommand;
import com.vmware.vide.project.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;

public class UserInput
implements Cloneable {
    private static ILog logger = ProjectPlugin.getDefault().getLog();
    public static final String VALIDITY_NOT_EMPTY = "not_empty";
    public static final String VALIDITY_MATCH = "match";
    public static final String SEVERITY_CRITICAL = "critical";
    public static final String SEVERITY_MODERATE = "moderate";
    public static final String SEVERITY_INFORMATIONAL = "informational";
    public static final String INPUT_STATE_NORMAL = "normal";
    public static final String INPUT_STATE_ERROR = "error";
    public static final String INPUT_STATE_WARNING = "warning";
    public static final String INPUT_STATE_INFORMATIONAL = "informational";
    public static final String INPUTTYPE_TEXT = "text";
    public static final String INPUTTYPE_COMBO = "combo";
    public static final String INPUTTYPE_TEXTBOX = "textbox";
    public static final String INPUTTYPE_COMBOTEXT = "combotext";
    public static final String INPUTTYPE_LABEL = "label";
    private static final String INPUTTYPE_CHECKBOX = "checkbox";
    public static final String CHECKBOX_SELECTED = "selected";
    public static final String CHECKBOX_NOTSELECTED = "notselected";
    public static final String INPUT_HELPER_NAME = "name";
    public static final String INPUT_HELPER_COMMAND = "command";
    public static final String INPUT_HELPER_COMMAND_ID = "id";
    public static final String INPUT_HELPER_COMMAND_ARG = "arg";
    public static final String ENABLE_WHEN = "enable_when";
    public static final String ENABLE_WHEN_TITLE = "title";
    public static final String ENABLE_WHEN_PATTERN = "pattern";
    public static final String CHECKBOX_PREFIX = "checkbox:";
    private final String UNEXPECTED_ELEMENT = "Unexpected element %s in %s.";
    private final String BAD_ELEMENT = "Bad element in %s.";
    private final String ERR_TOO_MANY_ELEMENT = "Userinput [%s] specifies multiple %s elements in %s element.";
    private final String ERR_MISSING_ELEMENT = "Userinput [%s] does not specify a %s element in %s element.";
    private final String title;
    private final String desc;
    private String def_value;
    private final String property_var;
    private final String input_pattern;
    private String value;
    private final String input_values;
    private final String input_type;
    private String checkbox;
    private final String validity;
    private final String severity;
    private String inputvalue_status;
    private List<UserInputHelper> inputHelpers;
    private final List<UserInputEnableCondition> enableConditions;
    private boolean enabled;
    private Map<String, String> values;

    public UserInput(Object configinfo) {
        this.title = ConfigUtil.lookupString((Object)configinfo, (String)ENABLE_WHEN_TITLE);
        this.desc = ConfigUtil.lookupString((Object)configinfo, (String)"description");
        this.value = this.def_value = ConfigUtil.lookupString((Object)configinfo, (String)"default");
        this.property_var = ConfigUtil.lookupString((Object)configinfo, (String)"property_variable");
        this.input_pattern = ConfigUtil.lookupString((Object)configinfo, (String)"input_pattern");
        this.input_values = ConfigUtil.lookupString((Object)configinfo, (String)"input_values");
        this.checkbox = ConfigUtil.lookupString((Object)configinfo, (String)INPUTTYPE_CHECKBOX);
        this.input_type = ConfigUtil.lookupString((Object)configinfo, (String)"type");
        this.validity = ConfigUtil.lookupString((Object)configinfo, (String)"validity");
        this.severity = ConfigUtil.lookupString((Object)configinfo, (String)"severity");
        this.inputHelpers = this.lookupUserInputHelpers(configinfo);
        this.enableConditions = this.lookupUserInputEnableConditions(configinfo);
        this.inputvalue_status = null;
    }

    public UserInput clone() {
        UserInput input = null;
        try {
            input = (UserInput)super.clone();
            if (this.inputHelpers != null) {
                input.inputHelpers = new ArrayList<UserInputHelper>();
                for (UserInputHelper helper : this.inputHelpers) {
                    input.inputHelpers.add(helper.clone());
                }
            }
        }
        catch (CloneNotSupportedException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Failed to clone the UserInput.", (Throwable)e));
        }
        return input;
    }

    public boolean isValid() {
        if (this.title == null || this.title.isEmpty()) {
            return false;
        }
        return this.property_var != null && !this.property_var.isEmpty();
    }

    public boolean isUserInputEnabled() {
        return this.checkbox != null ? this.isCheckBoxSelected() : this.isEnabled();
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public String getWidgetType() {
        if (this.input_type == null || this.input_type.isEmpty()) {
            return INPUTTYPE_TEXT;
        }
        return this.input_type;
    }

    public String getOptionVariable() {
        return this.property_var;
    }

    public boolean hasMultipleValues() {
        return this.values != null && !this.values.isEmpty();
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public void putValueForMultipleValues(String name, String value) {
        if (this.values == null) {
            this.values = new HashMap<String, String>();
        }
        if (value == null) {
            this.values.remove(name);
            return;
        }
        this.values.put(name, value);
    }

    public String getTitle() {
        int index = this.title.indexOf(".");
        if (index != -1) {
            return this.title.substring(index + 1);
        }
        return this.title;
    }

    public String getFullTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.desc;
    }

    public boolean isCheckBoxNeeded() {
        return this.checkbox != null;
    }

    public boolean isCheckBoxSelected() {
        return this.checkbox != null && this.checkbox.equalsIgnoreCase(CHECKBOX_SELECTED);
    }

    public void setUserInputEnable(boolean enable) {
        if (this.checkbox != null) {
            this.checkbox = enable ? CHECKBOX_SELECTED : CHECKBOX_NOTSELECTED;
        }
    }

    public String getDefaultValue(Map<String, String> properties, boolean updatecurrentvalue) {
        String cur_def_value = this.def_value;
        if (properties.containsKey(this.property_var) && !cur_def_value.contains("PROJECT_NAME")) {
            cur_def_value = properties.get(this.property_var);
        }
        if (cur_def_value.contains("{{")) {
            cur_def_value = Utils.replaceContent(cur_def_value, properties);
        }
        if (updatecurrentvalue && !this.value.equals(cur_def_value)) {
            this.setValue(cur_def_value);
        }
        return cur_def_value;
    }

    public String getDefaultValue(Map<String, String> properties) {
        return this.getDefaultValue(properties, false);
    }

    public String getInputPattern() {
        return this.input_pattern;
    }

    public String[] getInputValues() {
        if (this.input_values != null) {
            if (this.input_values.indexOf(";") != -1) {
                return this.input_values.split(";");
            }
            return new String[]{this.input_values};
        }
        return new String[0];
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.inputvalue_status = this.getInputValueStatus(true);
    }

    public static LinkedHashMap<String, UserInput> getOrderedUserInputs(Object config) {
        LinkedHashMap<String, UserInput> userinputs = new LinkedHashMap<String, UserInput>();
        ArrayList inputs = ConfigUtil.lookupList((Object)config, (String)"userinput");
        if (inputs != null) {
            int i = 0;
            while (i < inputs.size()) {
                UserInput input = new UserInput(inputs.get(i));
                if (input.isValid() && !userinputs.containsKey(input.property_var)) {
                    userinputs.put(input.property_var, input);
                }
                ++i;
            }
        }
        return userinputs;
    }

    public String getValidity() {
        return this.validity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public List<UserInputHelper> getUserInputHelpers() {
        return this.inputHelpers;
    }

    public List<UserInputEnableCondition> getEnableConditions() {
        return this.enableConditions;
    }

    public boolean isValidValue() {
        String validate = this.getValidity();
        String value = this.getValue();
        if (validate != null && !validate.isEmpty()) {
            if (validate.equals(VALIDITY_NOT_EMPTY)) {
                return value != null && !value.trim().isEmpty();
            }
            if (validate.equals(VALIDITY_MATCH)) {
                String[] inputValues = this.getInputValues();
                String regexp = this.getInputPattern();
                if (inputValues.length != 0) {
                    if (value == null || value.isEmpty()) {
                        return false;
                    }
                    String[] stringArray = inputValues;
                    int n = inputValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        if (val.equals(value)) {
                            return true;
                        }
                        ++n2;
                    }
                    if (regexp != null && !regexp.isEmpty()) {
                        return value.matches(regexp);
                    }
                    return false;
                }
                if (regexp != null && !regexp.isEmpty()) {
                    if (value == null) {
                        return false;
                    }
                    return value.matches(regexp);
                }
            }
        }
        return true;
    }

    public boolean isInputValueNormal() {
        return this.getInputValueStatus(false).equals(INPUT_STATE_NORMAL);
    }

    public boolean isInputValueError() {
        return this.getInputValueStatus(false).equals(INPUT_STATE_ERROR);
    }

    public boolean isInputValueWarning() {
        return this.getInputValueStatus(false).equals(INPUT_STATE_WARNING);
    }

    public boolean isInputValueInformational() {
        return this.getInputValueStatus(false).equals("informational");
    }

    public boolean hasEnableConditions() {
        return this.enableConditions != null && !this.enableConditions.isEmpty();
    }

    public String getInputValueStatus(boolean refresh) {
        if (!refresh && this.inputvalue_status != null) {
            return this.inputvalue_status;
        }
        this.inputvalue_status = this.isValidValue() ? INPUT_STATE_NORMAL : (this.getSeverity().equals(SEVERITY_CRITICAL) ? INPUT_STATE_ERROR : (this.getSeverity().equals(SEVERITY_MODERATE) ? INPUT_STATE_WARNING : "informational"));
        return this.inputvalue_status;
    }

    public QualifiedName getQualifiedName(String base) {
        return new QualifiedName(base, String.valueOf(this.title) + this.getWidgetType());
    }

    public QualifiedName getQualifiedCheckboxName(String base) {
        return new QualifiedName(base, String.valueOf(this.title) + INPUTTYPE_CHECKBOX);
    }

    private List<UserInputHelper> lookupUserInputHelpers(Object configinfo) {
        ArrayList<UserInputHelper> helpers = new ArrayList<UserInputHelper>();
        ArrayList helperNodes = ConfigUtil.lookupList((Object)configinfo, (String)"input_helper");
        if (helperNodes != null && !helperNodes.isEmpty()) {
            for (Object helperNode : helperNodes) {
                if (helperNode instanceof List) {
                    UserInputHelper helper = new UserInputHelper();
                    helper.commands = new ArrayList<UserInputHelperCommand>();
                    for (Object item : (List)helperNode) {
                        if (item instanceof Map) {
                            Map nodeItem = (Map)item;
                            if (nodeItem.containsKey(INPUT_HELPER_NAME)) {
                                helper.name = (String)nodeItem.get(INPUT_HELPER_NAME);
                            }
                            if (!nodeItem.containsKey(INPUT_HELPER_COMMAND)) continue;
                            UserInputHelperCommand command = new UserInputHelperCommand();
                            command.args = new ArrayList<String>();
                            List elems = (List)nodeItem.get(INPUT_HELPER_COMMAND);
                            for (Object elem : elems) {
                                if (elem instanceof Map) {
                                    Map cmdElem = (Map)elem;
                                    if (cmdElem.containsKey(INPUT_HELPER_COMMAND_ID)) {
                                        command.command = (String)cmdElem.get(INPUT_HELPER_COMMAND_ID);
                                        continue;
                                    }
                                    if (cmdElem.containsKey(INPUT_HELPER_COMMAND_ARG)) {
                                        command.args.add((String)cmdElem.get(INPUT_HELPER_COMMAND_ARG));
                                        continue;
                                    }
                                    String msg = cmdElem.isEmpty() ? String.format("Bad element in %s.", "input_helper") : String.format("Unexpected element %s in %s.", cmdElem.keySet().iterator().next(), "input_helper");
                                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                                    continue;
                                }
                                String msg = String.format("Bad element in %s.", "input_helper");
                                logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                            }
                            helper.commands.add(command);
                            continue;
                        }
                        String msg = String.format("Bad element in %s.", "input_helper");
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                    }
                    if (helper.name == null) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Missing name in input_helper"));
                        continue;
                    }
                    if (helper.commands.isEmpty()) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Missing command in input_helper"));
                        continue;
                    }
                    helpers.add(helper);
                    continue;
                }
                String msg = String.format("Bad element in %s.", "input_helper");
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
            }
        }
        return helpers;
    }

    private List<UserInputEnableCondition> lookupUserInputEnableConditions(Object configinfo) {
        ArrayList enableWhen = ConfigUtil.lookupList((Object)configinfo, (String)ENABLE_WHEN);
        if (enableWhen != null && !enableWhen.isEmpty()) {
            ArrayList<UserInputEnableCondition> conditions = new ArrayList<UserInputEnableCondition>();
            for (Object o : enableWhen) {
                String msg;
                String condTitle = null;
                String condPattern = null;
                boolean condCheckbox = false;
                boolean seenTitle = false;
                boolean seenPattern = false;
                for (Map m : (List)o) {
                    String msg2;
                    if (m.containsKey(ENABLE_WHEN_TITLE)) {
                        if (seenTitle) {
                            msg2 = String.format("Userinput [%s] specifies multiple %s elements in %s element.", this.title, ENABLE_WHEN_TITLE, ENABLE_WHEN);
                            logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg2));
                            continue;
                        }
                        condTitle = (String)m.get(ENABLE_WHEN_TITLE);
                        if (condTitle.startsWith(CHECKBOX_PREFIX)) {
                            condCheckbox = true;
                            condTitle = condTitle.substring(CHECKBOX_PREFIX.length());
                        } else {
                            condCheckbox = false;
                        }
                        seenTitle = true;
                    }
                    if (!m.containsKey(ENABLE_WHEN_PATTERN)) continue;
                    if (seenPattern) {
                        msg2 = String.format("Userinput [%s] specifies multiple %s elements in %s element.", this.title, ENABLE_WHEN_PATTERN, ENABLE_WHEN);
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg2));
                        continue;
                    }
                    condPattern = (String)m.get(ENABLE_WHEN_PATTERN);
                    seenPattern = true;
                }
                if (!seenTitle) {
                    msg = String.format("Userinput [%s] does not specify a %s element in %s element.", this.title, ENABLE_WHEN_TITLE, ENABLE_WHEN);
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                    continue;
                }
                if (!seenPattern) {
                    msg = String.format("Userinput [%s] does not specify a %s element in %s element.", this.title, ENABLE_WHEN_PATTERN, ENABLE_WHEN);
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                    continue;
                }
                if (condTitle.equals(this.title)) {
                    msg = String.format("Userinput [%s] specifies itself.", this.title);
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                    continue;
                }
                conditions.add(new UserInputEnableCondition(condTitle, condPattern, condCheckbox));
            }
            return conditions;
        }
        return null;
    }
}

