/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.wizard;

import com.vmware.vide.project.config.devkit.DevkitInfo;
import com.vmware.vide.project.config.devkit.ProjectProperty;
import com.vmware.vide.project.config.wizard.AbstractContent;
import com.vmware.vide.project.config.wizard.AbstractWizardData;
import com.vmware.vide.project.config.wizard.AbstractWizardType;
import com.vmware.vide.project.config.wizard.IWindVisitor;
import com.vmware.vide.project.config.wizard.WizardCategory;
import com.vmware.vide.project.config.wizard.project.ProjectData;
import com.vmware.vide.project.config.wizard.project.ProjectOption;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Set;

public class SearchVariable {
    private static final String EMPTY_STRING = "";

    public static String evaluateVariables(String str, AbstractContent ac) {
        HashSet<String> haveSeen = new HashSet<String>();
        return SearchVariable.evaluateVariables(str, ac, haveSeen);
    }

    /*
     * Unable to fully structure code
     */
    private static String evaluateVariables(String s, AbstractContent ac, Set<String> haveSeen) {
        if (s.indexOf("{{") == -1) {
            return s;
        }
        sb = new StringBuffer();
        index = 0;
        ** GOTO lbl24
        {
            ++start;
            do {
                if (s.charAt(start + 2) == '{') continue block0;
                end = s.indexOf("}}", start + 2);
                if (end == -1) break block0;
                sb.append(s.substring(index, start));
                variable = s.substring(start + 2, end);
                haveSeen.add(variable);
                value = SearchVariable.evaluate(variable, ac, haveSeen);
                if (haveSeen.contains(value)) {
                    System.err.println("Found circular definition: [" + variable + " : " + value + "] in " + haveSeen.toString());
                    return "";
                }
                if (value != null) {
                    sb.append(value);
                }
                index = end + 2;
lbl24:
                // 2 sources

            } while ((start = s.indexOf("{{", index)) != -1);
        }
        sb.append(s.substring(index));
        return sb.toString();
    }

    private static String evaluate(String var, AbstractContent ac, Set<String> haveSeen) {
        SearchVariable searchVariable = new SearchVariable();
        searchVariable.getClass();
        SearchVariableVisitor visitor = searchVariable.new SearchVariableVisitor(var);
        ac.wind(visitor);
        String val = visitor.getValue();
        if (val == null) {
            System.err.println("Specified variable [" + var + "] is not found in the scope.");
            return EMPTY_STRING;
        }
        if (val.contains("{{")) {
            val = SearchVariable.evaluateVariables(val, ac, haveSeen);
        }
        return val;
    }

    class SearchVariableVisitor
    implements IWindVisitor {
        private final String variable;
        private String value;
        private String[] natureids;

        SearchVariableVisitor(String variable) {
            this.variable = variable;
        }

        @Override
        public boolean visit(AbstractContent data) {
            if (data instanceof ProjectData) {
                ProjectOption opt;
                ProjectData pd = (ProjectData)data;
                if (pd.getOptions() != null && (opt = pd.getOptions().get(this.variable)) != null) {
                    this.value = opt.getValue();
                    return false;
                }
            } else if (data instanceof WizardCategory) {
                ProjectOption opt;
                Hashtable<String, ProjectOption> opts;
                Hashtable<String, String> props;
                String ids;
                WizardCategory wc = (WizardCategory)data;
                if (this.natureids == null && (ids = (props = wc.getProperties()).get("project_nature")) != null) {
                    this.natureids = ids.split(",");
                }
                if ((opts = wc.getProjectOptions()) != null && (opt = (ProjectOption)opts.get(this.variable)) != null) {
                    this.value = opt.getValue();
                    return false;
                }
            } else if (data instanceof AbstractWizardType) {
                LinkedHashMap<String, ProjectProperty> props;
                ProjectProperty prop;
                AbstractWizardType awt = (AbstractWizardType)data;
                DevkitInfo di = awt.getDevkitInfo();
                if (this.natureids != null && (prop = (ProjectProperty)(props = di.getOrderedProjectProperties(this.natureids)).get(this.variable)) != null) {
                    this.value = prop.getValue(null);
                    return false;
                }
                String str = di.getSystemProperties().get(this.variable);
                if (str != null) {
                    this.value = str;
                    return false;
                }
                str = AbstractWizardData.globalInfo.get(this.variable);
                if (str != null) {
                    this.value = str;
                    return false;
                }
            }
            return true;
        }

        public String getValue() {
            return this.value;
        }
    }
}

