/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.wizard;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.project.config.devkit.DevkitInfo;
import com.vmware.vide.project.config.devkit.ProjectProperty;
import com.vmware.vide.project.config.vib.UserInput;
import com.vmware.vide.project.config.wizard.AbstractContent;
import com.vmware.vide.project.config.wizard.AbstractWizardData;
import com.vmware.vide.project.config.wizard.AbstractWizardType;
import com.vmware.vide.project.config.wizard.project.Builder;
import com.vmware.vide.project.config.wizard.project.ProjectCommand;
import com.vmware.vide.project.config.wizard.project.ProjectCommandRunner;
import com.vmware.vide.project.config.wizard.project.ProjectData;
import com.vmware.vide.project.config.wizard.project.ProjectFile;
import com.vmware.vide.project.config.wizard.project.ProjectOption;
import com.vmware.vide.project.config.wizard.project.Template;
import com.vmware.vide.project.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WizardCategory
extends AbstractContent {
    public static final String TAG_CATEGORY = "category";
    private static final String TAG_TITLE = "title";
    private static final String TAG_DESC = "description";
    private static final String VALID_KEY = "VALID";
    private static final String[] propertytypes = new String[]{"title", "description", "initpath", "projpath", "project_nature", "sourcepath", "project_destpath", "file_permission", "invalid_project_path"};
    private boolean isvalid;
    private final Object parent;
    private ArrayList<WizardCategory> subcategories;
    private ArrayList<AbstractWizardData> wizarddata;
    private List<Template> templates;
    protected Hashtable<String, String> properties;
    private Hashtable<String, ProjectOption> projectOptions;
    private LinkedHashMap<String, UserInput> orderedUserInputs;
    private Map<String, List<Builder>> builders;
    private List<ProjectCommand> configurators;
    private List<ProjectCommand> validators;

    public WizardCategory(Object parent, Object config) {
        this.parent = parent;
        this.refreshConfig(config);
    }

    public void refreshConfig(Object config) {
        this.isvalid = false;
        if (config == null) {
            return;
        }
        try {
            this.projectOptions = ProjectOption.getOptions(config);
            this.properties = new Hashtable();
            int i = 0;
            while (i < propertytypes.length) {
                String value = ConfigUtil.lookupString((Object)config, (String)propertytypes[i]);
                if (value != null && !value.isEmpty()) {
                    this.properties.put(propertytypes[i], value);
                }
                ++i;
            }
            this.wizarddata = AbstractWizardData.createWizardData(this, config);
            this.builders = ProjectData.getBuilders(config, true);
            this.configurators = ProjectData.getProjectConfigurators(config);
            this.validators = ProjectData.getProjectValidators(config);
            this.templates = ProjectFile.getTemplates(config, this.getProperty("sourcepath", true));
            this.orderedUserInputs = UserInput.getOrderedUserInputs(config);
            this.subcategories = new ArrayList();
            ArrayList nodes = ConfigUtil.lookupList((Object)config, (String)TAG_CATEGORY);
            if (nodes != null && nodes.size() > 0) {
                int i2 = 0;
                while (i2 < nodes.size()) {
                    WizardCategory category = new WizardCategory(this, nodes.get(i2));
                    if (category.isValid()) {
                        this.subcategories.add(category);
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (this.getTitle() != null && !this.getTitle().isEmpty()) {
            if (this.wizarddata != null && this.wizarddata.size() > 0) {
                this.isvalid = true;
            }
            if (this.subcategories != null && this.subcategories.size() > 0) {
                this.isvalid = true;
            }
        }
    }

    public boolean isValid() {
        if (this.isvalid && this.validators != null) {
            this.isvalid = this.runCategoryValidators();
        }
        return this.isvalid;
    }

    private boolean runCategoryValidators() {
        Map<String, String> properties = this.getAccessibleProperties();
        for (ProjectCommand cmd : this.validators) {
            ProjectCommandRunner runner = ProjectCommandRunner.createProjectCommandRunner(null, cmd, properties);
            runner.start();
            Map<String, String> cmdProperties = runner.getProjectCommandProperties();
            if (this.isValidCategory(cmdProperties)) continue;
            return false;
        }
        return true;
    }

    private Map<String, String> getAccessibleProperties() {
        LinkedList<String> natures = new LinkedList<String>();
        LinkedList<WizardCategory> categories = new LinkedList<WizardCategory>();
        HashMap<String, String> properties = new HashMap<String, String>(AbstractWizardData.globalInfo);
        Object o = this;
        while (o != null && o instanceof WizardCategory) {
            String id;
            Object object = o;
            Hashtable<String, String> wcProperties = ((WizardCategory)object).getProperties();
            if (wcProperties.containsKey("project_nature") && !natures.contains(id = (String)wcProperties.get("project_nature"))) {
                natures.addFirst(id);
            }
            categories.addFirst((WizardCategory)object);
            o = ((WizardCategory)object).getParent();
        }
        if (o instanceof AbstractWizardType) {
            DevkitInfo devkitInfo = ((AbstractWizardType)o).getDevkitInfo();
            properties.putAll(devkitInfo.getSystemProperties());
            String[] natureIDs = natures.toArray(new String[natures.size()]);
            for (ProjectProperty pp : devkitInfo.getOrderedProjectProperties(natureIDs).values()) {
                properties.put(pp.getName(), pp.getValue());
            }
        }
        for (WizardCategory wizardCategory : categories) {
            for (ProjectOption option : wizardCategory.getProjectOptions().values()) {
                properties.put(option.getPropertyVariable(), option.getValue());
            }
        }
        return properties;
    }

    private boolean isValidCategory(Map<String, String> properties) {
        return properties != null && properties.containsKey(VALID_KEY) && Boolean.parseBoolean(properties.get(VALID_KEY));
    }

    public String getTitle() {
        return this.getProperty(TAG_TITLE, false);
    }

    public String getRootTitle() {
        if (this.parent instanceof WizardCategory) {
            return ((WizardCategory)this.parent).getRootTitle();
        }
        return this.getTitle();
    }

    public String getDescription() {
        return this.getProperty(TAG_DESC, false);
    }

    public String getProperty(String type, boolean searchparent) {
        if (this.properties.containsKey(type)) {
            return Utils.replaceContent(this.properties.get(type), AbstractWizardData.globalInfo);
        }
        if (searchparent && this.parent instanceof WizardCategory) {
            return ((WizardCategory)this.parent).getProperty(type, searchparent);
        }
        return "";
    }

    public boolean hasCategory() {
        return this.subcategories.size() > 0;
    }

    public boolean hasData() {
        return this.wizarddata.size() > 0;
    }

    public AbstractWizardData[] getAllData(String datatype) {
        ArrayList<AbstractWizardData> array;
        if (datatype == null) {
            array = this.wizarddata;
        } else {
            array = new ArrayList();
            int i = 0;
            while (i < this.wizarddata.size()) {
                if (this.wizarddata.get(i).getType().equals(datatype)) {
                    array.add(this.wizarddata.get(i));
                }
                ++i;
            }
        }
        return array.toArray(new AbstractWizardData[array.size()]);
    }

    public AbstractWizardData getOneData(String datatype) {
        AbstractWizardData[] data;
        if (datatype != null && this.wizarddata.size() > 0 && (data = this.getAllData(datatype)).length > 0) {
            return data[0];
        }
        return null;
    }

    public ProjectData getProjectData() {
        AbstractWizardData pdata = this.getOneData("projectinfo");
        if (pdata != null && pdata instanceof ProjectData) {
            return (ProjectData)pdata;
        }
        return null;
    }

    public Hashtable<String, ProjectOption> getAllProjectOptions() {
        Hashtable<String, ProjectOption> opts = new Hashtable<String, ProjectOption>();
        if (this.parent instanceof WizardCategory) {
            opts.putAll(((WizardCategory)this.parent).getAllProjectOptions());
        }
        opts.putAll(this.projectOptions);
        return opts;
    }

    public Hashtable<String, ProjectOption> getProjectOptions() {
        return this.projectOptions;
    }

    public Hashtable<String, String> getProperties() {
        return this.properties;
    }

    public List<Template> getTemplates() {
        ArrayList<Template> files = new ArrayList<Template>();
        if (this.parent instanceof WizardCategory) {
            files.addAll(((WizardCategory)this.parent).getTemplates());
        }
        files.addAll(this.templates);
        return files;
    }

    @Override
    public Object[] getChildren() {
        return this.subcategories.toArray(new WizardCategory[this.subcategories.size()]);
    }

    @Override
    public boolean hasChildren() {
        return this.subcategories.size() > 0;
    }

    @Override
    public String getText() {
        return this.getTitle();
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    public LinkedHashMap<String, UserInput> getOrderedUserInputs() {
        LinkedHashMap<String, UserInput> inputs = new LinkedHashMap<String, UserInput>();
        inputs.putAll(this.orderedUserInputs);
        if (this.parent instanceof WizardCategory) {
            LinkedHashMap<String, UserInput> parentinputs = ((WizardCategory)this.parent).getOrderedUserInputs();
            for (UserInput input : parentinputs.values()) {
                if (inputs.containsKey(input.getOptionVariable())) continue;
                inputs.put(input.getOptionVariable(), input);
            }
        }
        return inputs;
    }

    public List<Builder> lookupBuilders(String buildersName) {
        if (this.builders.containsKey(buildersName)) {
            return this.builders.get(buildersName);
        }
        if (this.parent instanceof WizardCategory) {
            return ((WizardCategory)this.parent).lookupBuilders(buildersName);
        }
        return null;
    }

    public List<ProjectCommand> getConfigurators() {
        return this.configurators;
    }
}

