/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.wizard.project;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.wizard.project.ProjectCommand;
import com.vmware.vide.project.config.wizard.project.ProjectOperation;
import com.vmware.vide.project.utils.StreamReaderThread;
import com.vmware.vide.project.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public abstract class ProjectCommandRunner
implements Runnable {
    private static final ILog logger = ProjectPlugin.getDefault().getLog();
    private static final String ARG_VAL_SEP = "=";
    protected final ProjectCommand config;
    protected final IProject project;
    protected final Map<String, String> properties;

    public static ProjectCommandRunner createProjectCommandRunner(IProject project, ProjectCommand command, Map<String, String> properties) {
        if (command.isExternal()) {
            return new ExternalCommandRunner(project, command, properties);
        }
        return new CommandRunner(project, command, properties);
    }

    protected ProjectCommandRunner(IProject project, ProjectCommand command, Map<String, String> properties) {
        this.config = command;
        this.project = project;
        this.properties = properties;
    }

    public void start() {
        this.run();
    }

    public String getArgValue(String name) {
        String key = String.valueOf(name) + ARG_VAL_SEP;
        for (String arg : this.config.getArgs()) {
            if (!arg.startsWith(key)) continue;
            return arg.substring(key.length());
        }
        return null;
    }

    public String getArgValue(String name, String defaultValue) {
        String value = this.getArgValue(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public abstract void run();

    public abstract Map<String, String> getProjectCommandProperties();

    static class CommandRunner
    extends ProjectCommandRunner {
        private static final String PROPERTIES = "properties";
        private Map<String, String> commandProperties;

        protected CommandRunner(IProject project, ProjectCommand config, Map<String, String> properties) {
            super(project, config, properties);
        }

        @Override
        public void run() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    String id = CommandRunner.this.config.getCommand();
                    ICommandService service = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
                    if (service == null) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", "No command service."));
                        return;
                    }
                    Command cmd = service.getCommand(id);
                    Map args = CommandRunner.this.getArgs();
                    ExecutionEvent ee = new ExecutionEvent(null, args, (Object)"CommandRunner", (Object)CommandRunner.this.properties);
                    try {
                        Object o;
                        cmd.executeWithChecks(ee);
                        if (args.containsKey(CommandRunner.PROPERTIES) && (o = args.get(CommandRunner.PROPERTIES)) instanceof Map) {
                            CommandRunner.this.commandProperties = (Map)o;
                        }
                    }
                    catch (ExecutionException e) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                    }
                    catch (NotDefinedException e) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                    }
                    catch (NotEnabledException e) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                    }
                    catch (NotHandledException e) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                    }
                }
            });
        }

        @Override
        public Map<String, String> getProjectCommandProperties() {
            return this.commandProperties;
        }

        private Map<String, Object> getArgs() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            for (String arg : this.config.getArgs()) {
                int index = arg.indexOf(ProjectCommandRunner.ARG_VAL_SEP);
                String key = arg;
                String value = null;
                if (index != -1) {
                    key = arg.substring(0, index);
                    value = Utils.replaceContent(arg.substring(index + ProjectCommandRunner.ARG_VAL_SEP.length()), this.properties);
                }
                args.put(key, value);
            }
            return args;
        }
    }

    static class ExternalCommandRunner
    extends ProjectCommandRunner {
        private final String CONTROL = "control:";
        private final String CONTROL_CHARSET = "control:charset";
        private final String CONTROL_CWD = "control:cwd";
        private Map<String, String> commandProperties;

        ExternalCommandRunner(IProject project, ProjectCommand command, Map<String, String> properties) {
            super(project, command, properties);
        }

        private String[] getCommandLine() {
            ArrayList<String> cmdLine = new ArrayList<String>();
            cmdLine.add(Utils.replaceContent(this.config.getCommandName(), this.properties));
            for (String arg : this.config.getArgs()) {
                if (arg.startsWith("control:")) continue;
                cmdLine.add(Utils.replaceContent(arg, this.properties));
            }
            return cmdLine.toArray(new String[cmdLine.size()]);
        }

        @Override
        public void run() {
            block20: {
                Thread outReader;
                block19: {
                    String[] cmdline = this.getCommandLine();
                    ProcessBuilder pb = new ProcessBuilder(cmdline);
                    String cwd = this.getArgValue("control:cwd", null);
                    if (cwd != null) {
                        pb.directory(new File(cwd));
                    } else if (this.project != null) {
                        pb.directory(this.project.getLocation().toFile().getAbsoluteFile());
                    }
                    outReader = null;
                    ErrorReader errReader = null;
                    try {
                        Process process = pb.start();
                        String charset = this.getArgValue("control:charset", "UTF-8");
                        outReader = new StreamReaderThread(String.valueOf(cmdline[0]) + " reading stdout", process.getInputStream(), logger, charset);
                        errReader = new ErrorReader(String.valueOf(cmdline[0]) + " reading stderr", process.getErrorStream());
                        outReader.start();
                        errReader.start();
                        process.waitFor();
                        outReader.join();
                        errReader.join();
                    }
                    catch (IOException e) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                        if (outReader != null && outReader.isAlive()) {
                            ((StreamReaderThread)outReader).kill();
                        }
                        break block19;
                    }
                    catch (InterruptedException e) {
                        try {
                            logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                            break block19;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (outReader != null && outReader.isAlive()) {
                                ((StreamReaderThread)outReader).kill();
                            }
                        }
                    }
                    if (outReader != null && outReader.isAlive()) {
                        ((StreamReaderThread)outReader).kill();
                    }
                }
                if (outReader != null) {
                    BufferedReader br = new BufferedReader(new StringReader(((StreamReaderThread)outReader).getRead()));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            this.executeWorkbenchProjectOperation(line);
                        }
                    }
                    catch (IOException e) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                        if (br == null) break block20;
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e2));
                        }
                    }
                }
            }
        }

        private void executeWorkbenchProjectOperation(String op) {
            ProjectOperation operation;
            Map<String, String> properties;
            if (ProjectOperation.isWorkbenchProjectOperation(op) && (properties = (operation = new ProjectOperation(this.project, op = Utils.replaceContent(op, this.properties))).run()) != null) {
                if (this.commandProperties == null) {
                    this.commandProperties = new HashMap<String, String>();
                }
                this.commandProperties.putAll(properties);
            }
        }

        @Override
        public Map<String, String> getProjectCommandProperties() {
            return this.commandProperties;
        }

        class ErrorReader
        extends Thread {
            static final int MAX_ERRORS = 5;
            InputStream is;

            ErrorReader(String name, InputStream is) {
                super(name);
                this.is = is;
            }

            @Override
            public void run() {
                block14: {
                    int errors = 5;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));
                    try {
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                if (errors > 0) {
                                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", line));
                                    --errors;
                                }
                                if (!this.isInterrupted()) continue;
                                break;
                            }
                        }
                        catch (IOException e) {
                            logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                            if (reader == null) break block14;
                            try {
                                reader.close();
                            }
                            catch (IOException e2) {
                                logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e2));
                            }
                        }
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                            }
                        }
                    }
                }
            }
        }
    }
}

