/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.manager;

import com.vmware.vide.project.config.devkit.ProjectNatureInfo;
import com.vmware.vide.project.manager.IProjectIdentity;
import com.vmware.vide.project.manager.IProjectStorage;
import com.vmware.vide.project.manager.ProjectDescription;
import com.vmware.vide.project.manager.ProjectManager;
import com.vmware.vide.project.utils.NameValueData;
import com.vmware.vide.project.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;

public abstract class AbstractProjectIdentity
implements IProjectIdentity,
IProjectStorage {
    String name;

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isProjectStorageAvailable() {
        return false;
    }

    @Override
    public Map<String, String> getAllProjectProperties(IProject project) {
        ProjectDescription desc = ProjectManager.getProjectDescription(project);
        if (desc != null) {
            return desc.getAllProperties();
        }
        return new HashMap<String, String>();
    }

    @Override
    public String getProjectProperty(IProject project, String property) {
        ProjectDescription desc = ProjectManager.getProjectDescription(project);
        if (desc != null) {
            return desc.getProperty(property);
        }
        return null;
    }

    @Override
    public boolean putProjectProperties(IProject project, Map<String, String> properties, boolean overwrite) {
        ProjectDescription desc = ProjectManager.getProjectDescription(project);
        if (desc != null) {
            return desc.putProperties(properties, overwrite);
        }
        return false;
    }

    @Override
    public boolean putProjectProperty(IProject project, String property, String value, boolean overwrite) {
        ProjectDescription desc = ProjectManager.getProjectDescription(project);
        if (desc != null) {
            return desc.putProperty(property, value, overwrite);
        }
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void writeMessageInBuildConsole(IProject project, String message) throws Exception {
        throw new Exception("Project build console is not supported");
    }

    public final String replaceContent(String content, Map<String, String> properties) {
        return Utils.replaceContent(content, properties);
    }

    public final List<String> getValuesBySeparator(String value, String separator) {
        ArrayList<String> values = new ArrayList<String>();
        if (separator != null && value.contains(separator)) {
            String[] separatedvalues = value.split(separator);
            values.addAll(Arrays.asList(separatedvalues));
        } else {
            values.add(value);
        }
        return values;
    }

    public List<String> collectValuesFromProjectNatureInfo(String propertyid, String separator, ProjectNatureInfo[] projectnatures, Map<String, String> properties) {
        ArrayList<String> values = new ArrayList<String>();
        ProjectNatureInfo[] projectNatureInfoArray = projectnatures;
        int n = projectnatures.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectNatureInfo nature = projectNatureInfoArray[n2];
            String value = nature.getProperty(propertyid);
            if (value != null && !value.isEmpty()) {
                values.addAll(this.getValuesBySeparator(value, separator));
            }
            ++n2;
        }
        return values;
    }

    public Map<String, String> parseMacroPattern(String macrostr) {
        HashMap<String, String> macros = new HashMap<String, String>();
        macrostr = macrostr.trim();
        ArrayList<String> errs = new ArrayList<String>();
        ArrayList<NameValueData> namevals = Utils.parseNameValue(macrostr, errs);
        Pattern pattern = Pattern.compile("^[_a-zA-Z][_a-zA-Z0-9]*$");
        for (NameValueData nameval : namevals) {
            String name = nameval.getName();
            Matcher matcher = pattern.matcher(name);
            if (matcher.matches()) {
                if (macros.containsKey(name) && !nameval.getValue().equals(macros.get(name))) {
                    System.out.println("Informational: The value [" + (String)macros.get(name) + "] of the macro [" + name + "] is replaced with the value[" + nameval.getValue() + "].");
                }
                macros.put(name, nameval.getValue());
                continue;
            }
            errs.add("Bad macro name [" + name + "] is specified.");
        }
        for (String err : errs) {
            System.err.println(err);
        }
        return macros;
    }

    public String getProperty(ProjectNatureInfo[] natures, String propertyid) {
        ProjectNatureInfo[] projectNatureInfoArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectNatureInfo nature = projectNatureInfoArray[n2];
            String value = nature.getProperty(propertyid);
            if (value != null && !value.isEmpty()) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public String getProperty(ProjectNatureInfo[] natures, String defaultvalue, String propertyid, Map<String, String> userproperties) {
        String value = defaultvalue;
        value = userproperties != null && userproperties.containsKey(propertyid) ? userproperties.get(propertyid) : this.getProperty(natures, propertyid);
        if (value != null) {
            value = this.replaceContent(value, userproperties);
        }
        return value;
    }
}

