/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.vib;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.vib.VIBData;
import com.vmware.vide.project.config.vib.VIBFilesInfo;
import com.vmware.vide.project.manager.ProjectManager;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.vib.PropertyManager;
import com.vmware.vide.project.vib.VIBFileManager;
import com.vmware.vide.project.vib.VIBProperty;
import com.vmware.vide.project.vib.ui.VIBDesignPage;
import com.vmware.vide.utils.xml.XMLParser;
import com.vmware.vide.vxmleditor.Schema;
import com.vmware.vide.vxmleditor.editors.XMLEditor;
import com.vmware.vide.vxmleditor.model.XMLDataModel;
import com.vmware.vide.vxmleditor.model.XMLNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VIBFileInfo {
    protected static final String VIBFILEID_BULLETIN = "bulletin";
    protected static final String VIBFILEID_DESCRIPTOR = "descriptor";
    private static final String MSG_CATEGORY = "VIB File Creation";
    private static final String MSG_MISSINGFILE = " VIB file is required but doesn't exist. Do you want to create a default one?";
    private XMLDataModel datamodel = new XMLDataModel(this.getXSDSchemaFile());
    private XMLEditor textpage;
    private String vibpagename;
    protected String rootnodename;
    protected String vibfilename;
    private File templatexmlfile;
    private IFile vibfile;
    private int textpageindex;
    private VIBFileManager vibfilemanager;

    public VIBFileInfo(VIBFileManager manager, String pagename, String tag, String name, File tempfile) {
        this.vibfilemanager = manager;
        this.rootnodename = tag;
        this.vibfilename = name;
        this.vibpagename = pagename;
        this.templatexmlfile = tempfile;
    }

    protected VIBFileManager getFileManager() {
        return this.vibfilemanager;
    }

    public boolean isValid() {
        return this.vibfile != null && this.vibfile.exists();
    }

    public boolean isPrimaryVIBfile() {
        return false;
    }

    public String getVIBPageName() {
        return this.vibpagename;
    }

    public File getXSDSchemaFile() {
        return null;
    }

    public String getFilename() {
        return this.vibfilename;
    }

    public IFile getVIBFile() {
        return this.vibfile;
    }

    public String getRootNodeName() {
        return this.rootnodename;
    }

    public XMLDataModel getDataModel() {
        return this.datamodel;
    }

    public PropertyManager getPropertyManager() {
        return this.vibfilemanager.getPropertyManager();
    }

    public boolean exists(IPath path) {
        return path.append(this.vibfilename).toFile().exists();
    }

    public IFile getVIBFile(IProject project, IPath vibpath) {
        if (project.getLocation().equals((Object)vibpath)) {
            return project.getFile(this.vibfilename);
        }
        IPath path = vibpath.makeRelativeTo(project.getLocation());
        return project.getFile(path.append(this.vibfilename));
    }

    public void setInput(IEditorInput input) {
        if (!(input instanceof IFileEditorInput)) {
            return;
        }
        IFileEditorInput inputfile = (IFileEditorInput)input;
        IFile file = inputfile.getFile();
        if (!file.getName().equals(this.vibfilename) && (file = this.findVIBFileFromProject(file)) == null) {
            this.vibfile = null;
            return;
        }
        this.vibfile = file;
        if (this.getTextPage() != null) {
            this.getTextPage().getDocumentProvider().changed((Object)this.vibfile);
        }
        this.updateDataForDesignPages();
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.isValid()) {
            return;
        }
        if (this.getTextPage() != null) {
            this.getTextPage().doSave(monitor);
        }
        this.updateDataForDesignPages();
    }

    public void updateDataForDesignPages() {
        VIBDesignPage[] pages;
        if (!this.isValid()) {
            return;
        }
        this.datamodel.setInput(this.getTextPage(), (IEditorInput)new FileEditorInput(this.vibfile), this.getXSDSchemaFile());
        this.vibfilemanager.getPropertyManager().setInput(this);
        VIBDesignPage[] vIBDesignPageArray = pages = this.getDesignPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            VIBDesignPage page = vIBDesignPageArray[n2];
            page.refresh();
            ++n2;
        }
    }

    public void updateDataForTextPage() {
        if (!this.isValid()) {
            return;
        }
        this.datamodel.updateBaseDocuemnt();
    }

    private IFile findVIBFileFromProject(IFile inputfile) {
        File newvibfile;
        File[] files;
        IPath vibpath = inputfile.getParent().getLocation();
        IProject project = inputfile.getProject();
        IPath projectpath = project.getLocation();
        IPath relativepath = vibpath.makeRelativeTo(projectpath);
        File[] fileArray = files = vibpath.toFile().listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile foundfile;
            File file = fileArray[n2];
            if (this.vibfilename.equals(file.getName()) && (foundfile = project.getFile(relativepath.append(this.vibfilename))).exists()) {
                return foundfile;
            }
            ++n2;
        }
        if (ProjectManager.getDefault().hasProjectNature(project, "com.vmware.vide.core.devkitnature") && MessageDialog.openQuestion(null, (String)MSG_CATEGORY, (String)(String.valueOf(this.vibfilename) + MSG_MISSINGFILE)) && (newvibfile = this.generateVIBFile(project, vibpath, null)) != null && newvibfile.exists()) {
            try {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                System.out.println(e.getMessage());
            }
            return project.getFile(relativepath.append(newvibfile.getName()));
        }
        return null;
    }

    public XMLEditor getTextPage() {
        if (!this.isValid()) {
            return null;
        }
        if (this.textpage != null) {
            return this.textpage;
        }
        this.textpage = new XMLEditor(null);
        return this.textpage;
    }

    public void setTextPageIndex(int index) {
        this.textpageindex = index;
    }

    public boolean isTextPage(int pageindex) {
        return this.textpageindex == pageindex;
    }

    public VIBDesignPage[] getDesignPages() {
        return null;
    }

    public IFormPage[] getSpecificPages() {
        return new IFormPage[0];
    }

    public File generateVIBFile(IProject project, IPath vibpath, File tempfile) {
        block7: {
            block6: {
                if (project != null && vibpath != null && vibpath.toFile().exists()) break block6;
                return null;
            }
            tempfile = this.getTemplateFile(project);
            if (tempfile != null) break block7;
            System.out.println("Unable to find a VIB template file, please check vibtool installation");
            return null;
        }
        try {
            File destfile = vibpath.append(this.vibfilename).toFile();
            Document document = this.getDocument(project, tempfile);
            if (document != null) {
                XMLParser.parser.genXML(document, destfile.getAbsolutePath());
                if (destfile.exists()) {
                    return destfile;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    private File getTemplateFile(IProject project) {
        String devkitid = ProjectManager.getDevkitId(project);
        ArrayList<VIBData> data = ProjectPlugin.getConfig().getVIBData(devkitid);
        String templateFileName = null;
        File templateFile = null;
        block0: for (VIBData vdata : data) {
            List<VIBFilesInfo> vfinfos = vdata.getVIBFilesInfos();
            for (VIBFilesInfo vfinfo : vfinfos) {
                if (!vfinfo.getFilename().equals(this.vibfilename) || vfinfo.getDevkitbase() == null || vfinfo.getDevkitbase().isEmpty()) continue;
                templateFileName = vfinfo.getDevkitbase();
                break block0;
            }
        }
        if (templateFileName != null) {
            Map<String, String> properties = ProjectManager.getAllProjectProperties(project);
            templateFileName = Utils.replaceContent(templateFileName, properties);
            templateFile = new File(templateFileName);
        } else {
            templateFile = this.templatexmlfile;
        }
        if (templateFile.exists()) {
            return templateFile;
        }
        return null;
    }

    public Document getDocument(IProject project, File templatefile) {
        if (templatefile == null || !templatefile.exists()) {
            return null;
        }
        Document document = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(templatefile);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        if (document != null) {
            VIBProperty[] vIBPropertyArray = this.vibfilemanager.getPropertyManager().getAllProperties();
            int n = vIBPropertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                VIBProperty tagproperty = vIBPropertyArray[n2];
                this.updateXMLDocument(project, document, tagproperty, true);
                ++n2;
            }
        }
        return document;
    }

    public boolean updateXMLDocument(IProject project, Document doc, VIBProperty vibproperty, boolean create) {
        String[] names = vibproperty.getSeparateNodeNames();
        Node node = doc.getDocumentElement();
        if (node.getNodeName().equals(names[0])) {
            int i = 1;
            while (i < names.length) {
                boolean islasttag = i == names.length - 1;
                if ((node = this.updateXMLNode(node, names[i], create, islasttag, vibproperty.getAttribute(), vibproperty.getDefaultPropertyValue(project))) == null) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private Node updateXMLNode(Node parent, String tag, boolean create, boolean islasttag, String attribute, String value) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if ((child.getNodeType() != 3 || child.getNodeValue() != null && !child.getNodeValue().trim().isEmpty()) && child.getNodeType() != 8 && child.getNodeName().equals(tag)) {
                if (islasttag && value != null && !value.isEmpty()) {
                    if (attribute != null && !attribute.isEmpty()) {
                        Element element = (Element)child;
                        element.setAttribute(attribute, value);
                    } else {
                        child.setTextContent(value);
                    }
                }
                return child;
            }
            ++i;
        }
        if (create && value != null && !value.isEmpty()) {
            Element node = parent.getOwnerDocument().createElement(tag);
            parent.appendChild(node);
            if (attribute != null && !attribute.isEmpty()) {
                node.setAttribute(attribute, value);
            } else {
                node.setNodeValue(value);
            }
            return node;
        }
        return null;
    }

    public XMLNode findXMLNode(VIBProperty property) {
        List<XMLNode> nodes = this.collectAllXMLNodes(property.getSeparateNodeNames());
        if (nodes != null && nodes.size() > 0) {
            return nodes.get(nodes.size() - 1);
        }
        return null;
    }

    public XMLNode findXMLNodeByPath(String nodePath) {
        List<XMLNode> nodes;
        String[] nodeNames = nodePath.split("\\.");
        if (!nodePath.contains(".")) {
            nodeNames = new String[]{nodePath};
        }
        if ((nodes = this.collectAllXMLNodes(nodeNames)) != null && nodes.size() > 0) {
            return nodes.get(nodes.size() - 1);
        }
        return null;
    }

    public XMLNode[] getNodes(VIBProperty starttag, VIBProperty endtag) {
        List<XMLNode> nodes = this.collectAllXMLNodes(endtag.getSeparateNodeNames());
        if (nodes != null) {
            int i = 0;
            while (i < nodes.size()) {
                if (nodes.get(i).getNode().getNodeName().equals(starttag.getTailTag())) {
                    List<XMLNode> foundnodes = nodes.subList(i, nodes.size());
                    return foundnodes.toArray(new XMLNode[foundnodes.size()]);
                }
                ++i;
            }
        }
        return null;
    }

    private List<XMLNode> collectAllXMLNodes(String[] nodeNames) {
        ArrayList<XMLNode> nodes = new ArrayList<XMLNode>();
        XMLNode[] elements = this.datamodel.getElements();
        XMLNode xmlnode = null;
        String[] stringArray = nodeNames;
        int n = nodeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            xmlnode = this.findXMLNode(name, elements);
            if (xmlnode == null) {
                return null;
            }
            nodes.add(xmlnode);
            elements = xmlnode.getChildren(true);
            ++n2;
        }
        return nodes;
    }

    private XMLNode findXMLNode(String tag, XMLNode[] nodes) {
        if (nodes == null) {
            return null;
        }
        XMLNode[] xMLNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            XMLNode node = xMLNodeArray[n2];
            if (tag.equals(node.getNode().getNodeName())) {
                return node;
            }
            ++n2;
        }
        return null;
    }

    public List<XMLNode> findAllSiblingNodes(VIBProperty property) {
        XMLNode[] children;
        ArrayList<XMLNode> myNodeList = new ArrayList<XMLNode>();
        XMLNode parentElement = this.findXMLNodeByPath(property.getNodeNames().substring(0, property.getNodeNames().lastIndexOf(".")));
        if (parentElement == null) {
            return null;
        }
        XMLNode[] xMLNodeArray = children = parentElement.getChildren(true);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            XMLNode myNode = xMLNodeArray[n2];
            if (property.getNodeNames().endsWith(myNode.getNode().getNodeName())) {
                myNodeList.add(myNode);
            }
            ++n2;
        }
        return myNodeList;
    }

    public void removeChildren(String tagPath) {
        XMLNode[] children;
        XMLNode parentElement = this.findXMLNodeByPath(tagPath.substring(0, tagPath.lastIndexOf(".")));
        XMLNode[] xMLNodeArray = children = parentElement.getChildren(true);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            XMLNode x = xMLNodeArray[n2];
            parentElement.removeChildNode(x);
            ++n2;
        }
        this.datamodel.updateBaseDocuemnt();
    }

    public XMLNode createXMLNode(VIBProperty property) {
        String[] nodeNames = property.getSeparateNodeNames();
        XMLNode[] elements = this.datamodel.getElements();
        XMLNode xmlnode = null;
        XMLNode parentNode = null;
        int i = 0;
        while (i < nodeNames.length) {
            xmlnode = this.findXMLNode(nodeNames[i], elements);
            if (xmlnode == null || i == nodeNames.length - 1) {
                Object[] elem;
                Object[] objectArray = elem = parentNode.getSchemaElements();
                int n = elem.length;
                int n2 = 0;
                while (n2 < n) {
                    Object singleElem = objectArray[n2];
                    if (((Schema.Elem)singleElem).refName.equals(nodeNames[i])) {
                        parentNode.appendChildNode(singleElem);
                    }
                    ++n2;
                }
            } else {
                parentNode = xmlnode;
                elements = xmlnode.getChildren(true);
            }
            ++i;
        }
        if (parentNode != null) {
            XMLNode[] childNodes = parentNode.getChildren(true);
            xmlnode = childNodes[childNodes.length - 1];
        }
        return xmlnode;
    }

    public ArrayList<Schema.Elem> getAttributeList(VIBProperty property) {
        String[] nodeNames = property.getSeparateNodeNames();
        XMLNode[] elements = this.datamodel.getElements();
        XMLNode xmlnode = null;
        XMLNode parentNode = null;
        int i = 0;
        while (i < nodeNames.length) {
            xmlnode = this.findXMLNode(nodeNames[i], elements);
            if (xmlnode == null || i == nodeNames.length - 1) {
                Object[] elem;
                Object[] objectArray = elem = parentNode.getSchemaElements();
                int n = elem.length;
                int n2 = 0;
                while (n2 < n) {
                    Object singleElem = objectArray[n2];
                    if (((Schema.Elem)singleElem).refName.equals(nodeNames[i])) {
                        return ((Schema.Elem)singleElem).getType().attrs;
                    }
                    ++n2;
                }
            } else {
                parentNode = xmlnode;
                elements = xmlnode.getChildren(true);
            }
            ++i;
        }
        return null;
    }
}

