/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.vib;

import com.vmware.vide.project.config.devkit.AbstractCommandRunner;
import com.vmware.vide.project.config.devkit.MenuRunner;
import com.vmware.vide.project.manager.ProjectManager;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.vib.BulletinFileInfo;
import com.vmware.vide.project.vib.DescriptorFileInfo;
import com.vmware.vide.project.vib.PropertyManager;
import com.vmware.vide.project.vib.VIBFileInfo;
import com.vmware.vide.project.vib.VIBProperty;
import com.vmware.vide.project.vib.ui.IVIBFormPage;
import com.vmware.vide.project.vib.ui.VIBDesignPage;
import com.vmware.vide.project.vib.ui.VIBEditor;
import com.vmware.vide.project.vib.ui.VIBOverviewPage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;

public class VIBFileManager {
    public static final IPath ROOT_VIBPATH = new Path("/opt/vmware/vibtools/");
    public static final IPath VIB_SAMPLEPATH = ROOT_VIBPATH.append("sample");
    private static final String DESCRIPTOR_XML = "descriptor.xml";
    private static final String BULLETIN_XML = "bulletin.xml";
    private static final String[] knownFiles = new String[]{"descriptor.xml", "bulletin.xml"};
    private static final int DESCRIPTOR = 1;
    private static final int BULLETIN = 2;
    public static final String PROPERTY_VIBBUILD = "VIBBUILD_COMMAND";
    public static final String PROPERTY_DEBUG_VIBBUILD_COMMAND = "VIBBUILD_DEBUG_COMMAND";
    public static final String PROPERTY_RELEASE_VIBBUILD_COMMAND = "VIBBUILD_RELEASE_COMMAND";
    public static final String PROPERTY_BUILD_PATH = "VIBBUILD_DIRECTORY";
    public static final String BUILDTYPE_DEBUG = "debug";
    public static final String BUILDTYPE_RELEASE = "release";
    private static final String MAKE_BUILDER_NAME = "org.eclipse.cdt.managedbuilder.core.genmakebuilder";
    public static final String[][] BUILDTYPES = new String[][]{{"debug", "VIBBUILD_DEBUG_COMMAND"}, {"release", "VIBBUILD_RELEASE_COMMAND"}};
    private List<VIBFileInfo> allvibfiles;
    private IProject project;
    private VIBEditor vibeditor;
    private VIBOverviewPage viboverviewpage;
    private PropertyManager propertymanager;
    private VIBCommandManager vibcommand;
    private int prevpageindex;
    private boolean initializepages;

    private VIBFileManager(VIBEditor editor, int flag) {
        this.vibeditor = editor;
        this.propertymanager = new PropertyManager();
        this.allvibfiles = new ArrayList<VIBFileInfo>();
        if ((flag & 1) != 0) {
            this.allvibfiles.add(new DescriptorFileInfo(this));
        }
        if ((flag & 2) != 0) {
            this.allvibfiles.add(new BulletinFileInfo(this));
        }
        if (editor != null) {
            this.viboverviewpage = new VIBOverviewPage(editor);
        }
        this.initializepages = false;
    }

    public VIBFileManager() {
        this(null, 3);
    }

    public VIBEditor getEditor() {
        return this.vibeditor;
    }

    public PropertyManager getPropertyManager() {
        return this.propertymanager;
    }

    public List<VIBFileInfo> getAllVIBInfo() {
        return this.allvibfiles;
    }

    public VIBOverviewPage getVIBOverviewPage() {
        return this.viboverviewpage;
    }

    public void setInput(IEditorInput input) {
        if (!(input instanceof IFileEditorInput)) {
            return;
        }
        IFile inputfile = VIBFileManager.getFile(input);
        for (VIBFileInfo vibinfo : this.allvibfiles) {
            vibinfo.setInput(input);
        }
        IProject currentproject = inputfile.getProject();
        if (this.project != currentproject || this.vibcommand == null) {
            this.project = currentproject;
            this.vibcommand = new VIBCommandManager(this.project);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.viboverviewpage.isDirty()) {
            for (VIBFileInfo info : this.vibeditor.getVIBFileManager().getAllVIBInfo()) {
                info.updateDataForTextPage();
            }
        }
        this.viboverviewpage.doSave(monitor);
        for (VIBFileInfo vibinfo : this.allvibfiles) {
            VIBDesignPage[] pages;
            IFormPage[] formPages;
            IFormPage[] iFormPageArray = formPages = vibinfo.getSpecificPages();
            int n = formPages.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPage page = iFormPageArray[n2];
                if (page.isDirty()) {
                    vibinfo.updateDataForTextPage();
                }
                page.doSave(monitor);
                ++n2;
            }
            VIBDesignPage[] vIBDesignPageArray = pages = vibinfo.getDesignPages();
            int n3 = pages.length;
            n = 0;
            while (n < n3) {
                VIBDesignPage page = vIBDesignPageArray[n];
                if (page.isDirty()) {
                    vibinfo.updateDataForTextPage();
                }
                ++n;
            }
            vibinfo.doSave(monitor);
        }
    }

    public void pageChange(int newpageindex) {
        VIBDesignPage page;
        int n;
        int n2;
        VIBDesignPage[] vIBDesignPageArray;
        if (!this.initializepages) {
            for (VIBFileInfo info : this.allvibfiles) {
                info.updateDataForDesignPages();
            }
            this.viboverviewpage.refresh(null);
            this.initializepages = true;
        }
        if (this.viboverviewpage.getIndex() == this.prevpageindex) {
            if (this.viboverviewpage.isDirty()) {
                for (VIBFileInfo info : this.allvibfiles) {
                    info.updateDataForTextPage();
                }
            }
            for (VIBFileInfo info : this.allvibfiles) {
                IFormPage[] formPages;
                IFormPage[] iFormPageArray = formPages = info.getSpecificPages();
                int n3 = formPages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFormPage page2 = iFormPageArray[n4];
                    if (page2 instanceof IVIBFormPage) {
                        this.viboverviewpage.findErrorsOnPage();
                        this.viboverviewpage.addErrorMaptoOverviewPage(((IVIBFormPage)page2).getErrorSet());
                    }
                    ++n4;
                }
            }
            this.prevpageindex = newpageindex;
            return;
        }
        for (VIBFileInfo info : this.allvibfiles) {
            VIBDesignPage[] pages;
            if (!info.isValid()) continue;
            vIBDesignPageArray = pages = info.getDesignPages();
            n2 = pages.length;
            n = 0;
            while (n < n2) {
                page = vIBDesignPageArray[n];
                if (page.getIndex() == this.prevpageindex) {
                    if (page.isDirty()) {
                        info.updateDataForTextPage();
                    }
                    this.prevpageindex = newpageindex;
                    return;
                }
                ++n;
            }
        }
        for (VIBFileInfo info : this.allvibfiles) {
            IFormPage[] formPages = info.getSpecificPages();
            vIBDesignPageArray = formPages;
            n2 = formPages.length;
            n = 0;
            while (n < n2) {
                page = vIBDesignPageArray[n];
                if (page instanceof IVIBFormPage) {
                    this.viboverviewpage.findErrorsOnPage();
                    this.viboverviewpage.addErrorMaptoOverviewPage(((IVIBFormPage)((Object)page)).getErrorSet());
                }
                ++n;
            }
            if (!info.isTextPage(this.prevpageindex)) continue;
            if (info.getTextPage().isDirty()) {
                this.textPageIsUpdated(info);
            }
            this.prevpageindex = newpageindex;
            return;
        }
    }

    private void textPageIsUpdated(VIBFileInfo updatedpage) {
        updatedpage.updateDataForDesignPages();
        this.viboverviewpage.refresh(updatedpage);
        for (VIBFileInfo pageinfo : this.allvibfiles) {
            if (pageinfo.getVIBPageName().equals(updatedpage.getVIBPageName())) continue;
            pageinfo.updateDataForTextPage();
            pageinfo.updateDataForDesignPages();
        }
    }

    private VIBDesignPage findDesignPage(String fulltag) {
        for (VIBFileInfo vibinfo : this.allvibfiles) {
            VIBDesignPage[] pages;
            VIBDesignPage[] vIBDesignPageArray = pages = vibinfo.getDesignPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                VIBDesignPage page = vIBDesignPageArray[n2];
                if (page.isPrpoeryTagIncluded(fulltag)) {
                    return page;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean activateDesignPage(String fulltag, boolean focus) {
        VIBDesignPage page = this.findDesignPage(fulltag);
        if (page != null) {
            VIBProperty property;
            this.getEditor().setActivePage(page.getId());
            if (focus && (property = this.getPropertyManager().getProperty(fulltag)) != null) {
                return page.setSelection(property);
            }
        }
        return false;
    }

    public boolean allVIBFilesExists(IProject project, IPath vibpath) {
        if (vibpath == null || !vibpath.toFile().exists()) {
            return false;
        }
        for (VIBFileInfo vibinfo : this.allvibfiles) {
            if (vibinfo.exists(vibpath)) continue;
            return false;
        }
        return true;
    }

    public IFile getPrimaryVIBFile(IProject project, IPath vibpath) {
        if (vibpath == null || !vibpath.toFile().exists()) {
            return null;
        }
        for (VIBFileInfo vibinfo : this.allvibfiles) {
            if (!vibinfo.exists(vibpath) || !vibinfo.isPrimaryVIBfile()) continue;
            return vibinfo.getVIBFile(project, vibpath);
        }
        return null;
    }

    public boolean generateVIBFiles(IProject project, Path vibpath, Map<String, String> templatefiles) {
        if (vibpath == null || !vibpath.toFile().exists() || project == null) {
            return false;
        }
        boolean allvibcreated = true;
        for (VIBFileInfo vibinfo : this.allvibfiles) {
            File tempfile;
            File xml;
            if (vibinfo.exists((IPath)vibpath) || (xml = vibinfo.generateVIBFile(project, (IPath)vibpath, tempfile = templatefiles.containsKey(vibinfo.getVIBPageName()) ? new File(templatefiles.get(vibinfo.getVIBPageName())) : null)) != null && xml.exists()) continue;
            System.out.println("Failed to create a VIB file " + vibinfo.getFilename());
            allvibcreated = false;
        }
        try {
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            System.out.println(e.getMessage());
        }
        return allvibcreated;
    }

    public boolean isVIBBuildCommandAvailable() {
        return this.vibcommand != null && this.vibcommand.isValid();
    }

    public String getDefaultBuildType() {
        return this.vibcommand != null ? this.vibcommand.getDefaultType() : null;
    }

    public String[] getBuildTypes() {
        return this.vibcommand != null ? this.vibcommand.getTypes() : new String[]{};
    }

    public boolean buildVIBPackage(String buildtype) {
        String command;
        Shell shell;
        HashMap<String, String> envs;
        Map<String, String> commandProperties;
        AbstractCommandRunner runner;
        block5: {
            runner = this.getVIBPackageBuildRunner();
            if (runner == null) {
                return false;
            }
            this.doSave((IProgressMonitor)new NullProgressMonitor());
            commandProperties = this.getCommandProperties();
            envs = new HashMap<String, String>();
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            command = this.vibcommand.getBuildCommand(buildtype);
            if (!runner.isBlock()) break block5;
            Job job = new Job("building VIB"){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status;
                    try {
                        status = runner.execute(shell, VIBFileManager.this.project, command, 0, commandProperties, envs, monitor);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        status = Status.CANCEL_STATUS;
                    }
                    return status;
                }
            };
            job.setPriority(20);
            job.setRule((ISchedulingRule)this.project);
            job.schedule();
            return true;
        }
        try {
            if (runner.execute(shell, this.project, command, 0, commandProperties, envs, (IProgressMonitor)new NullProgressMonitor()) == Status.OK_STATUS) {
                return true;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return false;
    }

    private Map<String, String> getCommandProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        String dir = ProjectManager.getProjectProperty(this.project, PROPERTY_BUILD_PATH);
        if (dir != null && !dir.isEmpty()) {
            dir = Utils.replaceContent(dir, ProjectManager.getAllProjectProperties(this.project));
            properties.put("ExecutePath", dir);
        }
        return properties;
    }

    public AbstractCommandRunner getVIBPackageBuildRunner() {
        Map<String, AbstractCommandRunner> runners = MenuRunner.getCommandRunners();
        if (this.hasMakeBuilders() && runners.containsKey("makefile")) {
            return runners.get("makefile");
        }
        if (runners.containsKey("shcommand")) {
            return runners.get("shcommand");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasMakeBuilders() {
        try {
            ICommand[] commands;
            ICommand[] iCommandArray = commands = this.project.getDescription().getBuildSpec();
            int n = commands.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICommand command = iCommandArray[n2];
                if (command.getBuilderName().equals(MAKE_BUILDER_NAME)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static IFile getFile(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return fileInput.getFile();
        }
        return null;
    }

    private static boolean isKnownFile(String name) {
        String[] stringArray = knownFiles;
        int n = knownFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (name.equals(file)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static VIBFileManager getVIBFileManager(VIBEditor editor, IFileEditorInput finput) throws PartInitException {
        IFile file = finput.getFile();
        if (!VIBFileManager.isKnownFile(file.getName())) {
            throw new PartInitException(String.format("Unsupported file [%s].", file.getName()));
        }
        IProject project = finput.getFile().getProject();
        IPath p = file.getProjectRelativePath().removeLastSegments(1);
        int flag = 0;
        if (project.findMember(p.append(DESCRIPTOR_XML)) != null) {
            flag |= 1;
        }
        if (project.findMember(p.append(BULLETIN_XML)) != null) {
            flag |= 2;
        }
        return new VIBFileManager(editor, flag);
    }

    private class VIBCommandManager {
        Map<String, String> buildtypes;
        String defaultcommand;
        String defaulttype;

        public VIBCommandManager(IProject project) {
            String command = this.getProperty(VIBFileManager.PROPERTY_VIBBUILD, project);
            this.buildtypes = new LinkedHashMap<String, String>();
            String[][] stringArray = BUILDTYPES;
            int n = BUILDTYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String[] type = stringArray[n2];
                String title = type[0];
                String property = type[1];
                String value = this.getProperty(property, project);
                if (value != null && !value.isEmpty()) {
                    this.buildtypes.put(title, value);
                    if (command != null && command.equals(value)) {
                        this.defaulttype = title;
                        this.defaultcommand = value;
                    }
                }
                ++n2;
            }
            if (this.defaultcommand == null || this.defaultcommand.isEmpty() || command != null) {
                this.defaultcommand = command;
            }
        }

        public boolean isValid() {
            return this.defaultcommand != null && !this.defaultcommand.isEmpty();
        }

        public String[] getTypes() {
            return this.buildtypes.keySet().toArray(new String[this.buildtypes.size()]);
        }

        public String getDefaultType() {
            return this.defaulttype;
        }

        public String getBuildCommand(String type) {
            if (this.buildtypes.containsKey(type)) {
                return this.buildtypes.get(type);
            }
            return this.defaultcommand;
        }

        private String getProperty(String key, IProject project) {
            Map<String, String> properties = ProjectManager.getAllProjectProperties(project);
            if (properties.containsKey(key)) {
                String value = properties.get(key);
                if (value.contains("{{")) {
                    value = Utils.replaceContent(value, properties);
                }
                return value;
            }
            return null;
        }
    }
}

