/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.vib;

import com.vmware.vide.project.manager.ProjectManager;
import com.vmware.vide.project.vib.PropertyManager;
import com.vmware.vide.project.vib.VIBFileInfo;
import com.vmware.vide.vxmleditor.model.XMLAttribute;
import com.vmware.vide.vxmleditor.model.XMLNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;

public class VIBProperty {
    public static final String TAG_SEPARATOR = ".";
    public static final String ATTR_SEPARATOR = ":";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_CHECKBOX = "checkbox";
    public static final String TYPE_RELATIONSHIPS = "relationships";
    public static final String TYPE_PLATFORMS = "platforms";
    public static final String TYPE_SYSTEM = "system";
    public static final String TYPE_HYPERLINK = "hyperlink";
    public static final String TYPE_LIST = "list";
    public static final String TYPE_MULTI_TEXT = "multitext";
    public static final String TAG_NAME = "vib.name";
    public static final String TAG_VERSION = "vib.version";
    public static final String TAG_VIB_SUMMARY = "vib.summary";
    public static final String TAG_VIB_DESC = "vib.description";
    public static final String TAG_VIB_VENDOR = "vib.vendor";
    public static final String TAG_MAINT = "vib.system-requires.maintenance-mode";
    public static final String TAG_VIB_RELEASE_DATE = "vib.release-date";
    public static final String TAG_BULLETIN_ID = "bulletin.id";
    public static final String TAG_BULLETIN_VENDOR = "bulletin.vendor";
    public static final String TAG_BULLETIN_SUMMARY = "bulletin.summary";
    public static final String TAG_BULLETIN_DESC = "bulletin.description";
    public static final String TAG_VIB_URLS_URL = "vib.urls.url";
    public static final String TAG_VENDOR_EMAIL = "bulletin.contact";
    public static final String TAG_BULLETIN_KBURL = "bulletin.kbUrl";
    public static final String TAG_ESX_VERSION = "bulletin.platforms.softwarePlatform:version";
    public static final String TAG_RELATIONSHIPS = "vib.relationships";
    public static final String TAG_DEPENDS = "vib.relationships.depends";
    public static final String TAG_CONFLICTS = "vib.relationships.conflicts";
    public static final String TAG_REPLACES = "vib.relationships.replaces";
    public static final String TAG_PROVIDES = "vib.relationships.provides";
    public static final String TAG_COMPATIBLEWITH = "vib.relationships.compatibleWith";
    public static final String TAG_PLATFORMS = "bulletin.platforms";
    public static final String TAG_SOFTWARE_PLATFORM = "bulletin.platforms.softwarePlatform";
    public static final String TAG_SYSTEM_REQUIRES = "vib.system-requires";
    public static final String TAG_LIVE_INSTALL_ALLOWED = "vib.live-install-allowed";
    public static final String TAG_LIVE_REMOVE_ALLOWED = "vib.live-remove-allowed";
    private static final String TAG_STATELESS_READY = "vib.stateless-ready";
    public static final String TAG_CIMOM_RESTART = "vib.cimom-restart";
    public static final String TAG_CATEGORY = "bulletin.category";
    public static final String TAG_URGENCY = "bulletin.urgency";
    private static final String ARG_NAME = "DESC_NAME";
    private static final String ARG_RELEASE_DATE = "DESC_RELEASE_DATE";
    private static final String ARG_VERSION = "DESC_VERSION";
    private static final String ARG_SUMMARY = "DESC_SUMMARY";
    private static final String ARG_DESC = "DESC_DESCRIPTION";
    private static final String ARG_VENDOR = "DESC_VENDOR";
    private static final String ARG_VENDOR_EMAIL = "DESC_VENDOR_EMAIL";
    private static final String ARG_MAINT = "DESC_MAINT";
    private static final String ARG_BULLETIN_ID = "VIB_BULLETIN_ID";
    private static final String ARG_KB_URL = "BULL_KBURL";
    private static final String ARG_LIVE_INSTALL_ALLOWED = "DESC_LIVE_INSTALL_ALLOWED";
    private static final String ARG_LIVE_REMOVE_ALLOWED = "DESC_LIVE_REMOVE_ALLOWED";
    private static final String TITLE_NAME = "VIB Package Name";
    private static final String TITLE_VERSION = "VIB Package Version";
    private static final String TITLE_SUMMARY = "Summary";
    private static final String TITLE_DESC = "Description";
    private static final String TITLE_VENDOR = "Vendor Name";
    private static final String TITLE_MAINT = "Enable Maintenance mode";
    private static final String TITLE_BULLETIN_ID = "Bulletin ID";
    private static final String TITLE_KB_URL = "Knowledge Base URL";
    private static final String TITLE_VENDOR_EMAIL = "Vendor Contact";
    private static final String TITLE_RELEASE_DATE = "Release Date";
    private static final String TITLE_DEPENDS = "Depends";
    private static final String TITLE_CONFLICTS = "Conflicts";
    private static final String TITLE_REPLACES = "Replaces";
    private static final String TITLE_PROVIDES = "Provides";
    private static final String TITLE_COMPATIBLEWITH = "CompatibleWith";
    private static final String TITLE_SOFTWARE_PLATFORM = "Software Platform";
    private static final String TITLE_SYSTEM_REQUIRES = "System installation requirements";
    private static final String TITLE_LIVE_INSTALL_ALLOWED = "Live install allowed";
    private static final String TITLE_LIVE_REMOVE_ALLOWED = "Live remove allowed";
    private static final String TITLE_STATELESS_READY = "Stateless Ready";
    private static final String TITLE_CIMOM_RESTART = "Restart CIMOM";
    private static final String TITLE_CATEGORY = "Category";
    private static final String TITLE_URGENCY = "Urgency";
    private static final String DESC_NAME = "The VIB package name must be 35 or less characters and must only contain [0-9a-zA-Z], -, _, and . Also it is advised that vendor be left out as there is a separate vendor field.";
    private static final String DESC_VERSION = "The VIB version should be of the form: ver-rel, where ver and rel are both strings, 17 characters or less, that must start with digits, and can end with a combination of digits, period, and letters.";
    private static final String DESC_SUMMARY = "A one-line summary of the VIB package contents. 80 chars max.";
    private static final String DESC_VENDOR = "Vendor has the same formatting restrictions as the VIB package name field. Vendor name is used as a part of VIB ID.";
    private static final String DESC_VIB_KB_URL = "Used for specifying KB article URLs.  Key is a short friendly identifier, no more than 20 characters long, to display instead of or alongside the URL.";
    private static final String DESC_MAINTENACE_MODE = "If true, the ESX host will have to be put in maintenance mode before installation.";
    private static final String DESC_RELEASE_DATE = "The release date of this package. YYYY-MM-DDThh:mm:ss[+/-hh:mm].";
    private static final String DESC_LIVE_INSTALL_ALLOWED = "Both live install and live removes must be true for a live upgrade.";
    private static final String DESC_BULLETIN_ID = "The bulletin ID must be globally unique. To facilitate this, the ID must begin with the designated vendor code. The vendor code will be assigned by VMware. The rest of the bulletin ID must be locally unique within that vendor code. The bulletin ID may incorporate information such as product/component and version information, if applicable. The bulletin ID must not contain spaces.";
    private static final String DESC_BULLETIN_VENDOR = "The name of your company.";
    private static final String DESC_BULLETIN_SUMMARY = " A short (1 line) summary of this bulletin.";
    private static final String DESC_BULLETIN_DESCRIPTION = "A much more detailed explanation of the bulletin contents.";
    private static final String DESC_BULLETIN_KB_URL = "A URL link to a KnowledgeBase article or similar online documentation about this issue. This field must contain text, but may indicate that no URL is available.";
    private static final String DESC_STATELESS_READY = "Mark this VIB as stateless ready - meaning that this VIB can be booted from a stateless host and its configuration has a host profiles plugin.";
    private static final String DESC_BULLETIN_CONTACT = "An email address to which end users should submit queries if they have an issue with this software.";
    private static final String DESC_CIMOM_RESTART = "Restart cimom after installation or removal of this VIB. Applies only to live installation.  Should be set to True for plugins that require cimom to be restarted for activation, such as CIM provider.";
    private static final String DESC_CATEGORY = "A category of this distribution. The value is one of Security, BugFix, Enhancement, Recall, RecallFix, Info or Misc.";
    private static final String DESC_URGENCY = "A level of urgency. The value is one of Critical, Important, Moderate or Low.";
    private static final String INPUT_NAMESTRING = "[0-9A-Za-z_\\-\\.]{1,35}";
    private static final String INPUT_VERSION = "[0-9][a-zA-Z0-9\\.]{0,16}\\-[0-9][a-zA-Z0-9\\.]{0,16}";
    private static final String INPUT_SUMMARY = ".{1,80}";
    private static final String INPUT_EMAIL = "^[^@]+@[^@]+\\.[^@]+$";
    private static final String INPUT_BULLETIN_ID = "^[^\\s]+$";
    private static final String INPUT_RELEASE_DATE = "\\d{4}-[01]\\d-[0-3]\\dT[012]\\d:[0-5]\\d:[0-5]\\d([+\\-][012]\\d:[0-5]\\d)?";
    private static final String INPUT_KB_URL = ".+";
    private static final String INPUT_CATEGORY = "(Security|BugFix|Enhancement|Recall|RecallFix|Info|Misc)";
    private static final String INPUT_URGENCY = "(Critical|Important|Moderate|Low)";
    private static final String INPUT_NOEMPTY = ".+";
    public static final String TITLE_RELATIONSHIPS = "VIB's Relationships with Other VIBs";
    public static final String DESC_RELATIONSHIPS = "This section defines a VIB's relationships with other VIBs or with external entities.";
    public static final String DESC_DEPENDS = "Depends defines other packages that this package requires.";
    public static final String DESC_CONFLICTS = "Packages that this package should not be installed with.";
    public static final String DESC_REPLACES = "Packages that this one replaces.";
    public static final String DESC_PROVIDES = "Interfaces or virtual packages that this VIB package provides.";
    public static final String DESC_COMPATIBLEWITH = "Indicates relationships with software entities.";
    public static final String TITLE_PLATFORMS = "Software Platform";
    public static final String DESC_PLATFORMS = "List the platforms to which this software will apply.";
    public static final String DESC_SOFTWARE_PLATFORM = "A platform to which this software will apply.";
    public static final String XMLTAG_VALUE = "::XMLTAGVALUE::";
    private PropertyManager manager;
    private String propertywidgettype;
    private String propertykey;
    private String nodenames;
    private String inputformat;
    private String defvalue;
    private String propertyvalue;
    private String title;
    private String description;
    private VIBFileInfo vibinfo;
    private Object tagxmlnode;
    private List<Map<String, String>> listObjects;

    public VIBProperty(PropertyManager manager, String propertywidgettype, String nodenames, String propertykey, String title, String desc, String inputformat, String defvalue) {
        this.manager = manager;
        this.propertywidgettype = propertywidgettype;
        this.nodenames = nodenames;
        this.propertykey = propertykey;
        this.title = title;
        this.description = desc;
        this.inputformat = inputformat;
        this.defvalue = defvalue;
    }

    public void setVIBInfo(VIBFileInfo info) {
        if (info == null) {
            return;
        }
        this.vibinfo = info;
        if (this.isListbox()) {
            List<XMLNode> nodes;
            this.tagxmlnode = nodes = info.findAllSiblingNodes(this);
            if (nodes != null) {
                this.loadNodeListObject(nodes);
            }
        } else {
            String value;
            XMLNode node = info.findXMLNode(this);
            this.tagxmlnode = node;
            if (node != null && (value = node.getTextNodeValue()) != null && !value.equals(this.propertyvalue)) {
                this.propertyvalue = value;
            }
        }
    }

    private void loadNodeListObject(List<XMLNode> tagXMLObjects) {
        this.listObjects = new ArrayList<Map<String, String>>();
        for (XMLNode node : tagXMLObjects) {
            Map nodeAttributes = node.getAttributes();
            TreeMap<String, String> attributes = new TreeMap<String, String>();
            for (String key : nodeAttributes.keySet()) {
                String value = ((XMLAttribute)nodeAttributes.get(key)).getValue();
                attributes.put(key, value);
            }
            attributes.put(XMLTAG_VALUE, node.getTextNodeValue());
            this.listObjects.add(attributes);
        }
    }

    public String getPropertyKey() {
        return this.propertykey;
    }

    public String getNodeNames() {
        return this.nodenames;
    }

    public String getRootNodeName() {
        return this.nodenames.contains(TAG_SEPARATOR) ? this.nodenames.substring(0, this.nodenames.indexOf(TAG_SEPARATOR)) : this.nodenames;
    }

    public String getTailTag() {
        String separator = this.isAttribute() ? ATTR_SEPARATOR : TAG_SEPARATOR;
        return !this.nodenames.contains(separator) ? this.nodenames : this.nodenames.substring(this.nodenames.lastIndexOf(separator) + 1);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAttribute() {
        return this.nodenames.contains(ATTR_SEPARATOR);
    }

    public boolean isHyperlinkWidget() {
        return this.isHyperlinkProperty() || this.isRelationshipsProperty() || this.isPlatformsProperty() || this.isSystemProperty();
    }

    public boolean isHyperlinkProperty() {
        return this.propertywidgettype.equals(TYPE_HYPERLINK);
    }

    public boolean isRelationshipsProperty() {
        return this.propertywidgettype.equals(TYPE_RELATIONSHIPS);
    }

    public boolean isSystemProperty() {
        return this.propertywidgettype.equals(TYPE_SYSTEM);
    }

    public boolean isPlatformsProperty() {
        return this.propertywidgettype.equals(TYPE_PLATFORMS);
    }

    public boolean isCheckBoxWidget() {
        return this.propertywidgettype.equals(TYPE_CHECKBOX);
    }

    public boolean isListbox() {
        return this.propertywidgettype.equals(TYPE_LIST);
    }

    public boolean isCheckBoxSelected() {
        if (!this.isCheckBoxWidget()) {
            return false;
        }
        String value = this.getPropertyValue();
        return value != null && value.equalsIgnoreCase("true");
    }

    public boolean isTextWidget() {
        return this.propertywidgettype.equals(TYPE_TEXT);
    }

    public boolean isMultiTextWidget() {
        return this.propertywidgettype.equals(TYPE_MULTI_TEXT);
    }

    public boolean isVIB() {
        return this.nodenames.startsWith("vib.");
    }

    public boolean isBulletin() {
        return this.nodenames.startsWith("bulletin.");
    }

    public String getAttribute() {
        if (!this.isAttribute()) {
            return "";
        }
        return this.nodenames.substring(this.nodenames.lastIndexOf(ATTR_SEPARATOR) + 1);
    }

    public String[] getSeparateNodeNames() {
        String tags = !this.isAttribute() ? this.nodenames : this.nodenames.substring(0, this.nodenames.lastIndexOf(ATTR_SEPARATOR));
        return tags.split("\\.");
    }

    public String getWidgetType() {
        return this.propertywidgettype;
    }

    public VIBFileInfo getVIBFile() {
        return this.vibinfo;
    }

    public String getPropertyValue() {
        return this.propertyvalue;
    }

    public boolean isValidVibFileInfo(VIBFileInfo vibFileInfo) {
        if (vibFileInfo == null) {
            return false;
        }
        return this.vibinfo == vibFileInfo;
    }

    public List<Map<String, String>> getListElements() {
        return this.listObjects;
    }

    public void updateXML() {
        this.vibinfo.removeChildren(this.nodenames);
        for (Map<String, String> listMembers : this.listObjects) {
            XMLNode newTag = this.vibinfo.createXMLNode(this);
            for (String key : listMembers.keySet()) {
                if (key.equals(XMLTAG_VALUE)) {
                    newTag.updated((Object)newTag, listMembers.get(key));
                    continue;
                }
                ((XMLAttribute)newTag.getAttributes().get(key)).setAttributeValue(listMembers.get(key));
            }
        }
        this.vibinfo.getDataModel().updateBaseDocuemnt();
    }

    private void setPropertyValue(String value) {
        this.propertyvalue = value;
        if (this.manager != null) {
            this.manager.fireVIBPropertyChanged(this);
        }
        if (this.vibinfo == null || !this.vibinfo.isValid() || this.tagxmlnode == null) {
            return;
        }
        if (this.isAttribute()) {
            String attrName = this.getAttribute();
            XMLAttribute attr = (XMLAttribute)((XMLNode)this.tagxmlnode).getAttributes().get(attrName);
            if (attr != null) {
                attr.setAttributeValue(value);
            }
        } else {
            ((XMLNode)this.tagxmlnode).updated(this.tagxmlnode, value);
        }
    }

    public void valueChagned(String value) {
        if (value != this.getPropertyValue()) {
            this.setPropertyValue(value);
        }
    }

    public String getDefaultPropertyValue(IProject project) {
        LinkedHashMap projectproperties = project != null ? ProjectManager.getAllProjectProperties(project) : new LinkedHashMap();
        String value = null;
        if (projectproperties != null && projectproperties.containsKey(this.propertykey)) {
            value = (String)projectproperties.get(this.propertykey);
        }
        if (value == null) {
            value = this.defvalue;
        }
        if (value != null && this.isCheckBoxWidget() && !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            try {
                int intvalue = Integer.parseInt(value);
                value = intvalue == 0 ? "false" : "true";
            }
            catch (Exception exception) {
                value = null;
            }
        }
        return value;
    }

    public String getInputFormat() {
        return this.inputformat;
    }

    public String getHyperlinkTitle() {
        if (this.nodenames.equals(TAG_PLATFORMS)) {
            return TYPE_PLATFORMS;
        }
        if (this.nodenames.equals(TAG_RELATIONSHIPS)) {
            return TYPE_RELATIONSHIPS;
        }
        return null;
    }

    public String getHyperlinkFormText() {
        if (this.nodenames.equals(TAG_PLATFORMS)) {
            return this.getPlatformFormText();
        }
        if (this.nodenames.equals(TAG_RELATIONSHIPS)) {
            return this.getRelationshipsFormText();
        }
        return null;
    }

    public String getRelationshipsFormText() {
        VIBProperty[] vibproperties;
        StringBuilder buffer = new StringBuilder();
        buffer.append("<form>");
        buffer.append("<p>This section defines a VIB's relationships with other VIBs or with external entities.</p>");
        VIBProperty[] vIBPropertyArray = vibproperties = this.manager.getAllProperties();
        int n = vibproperties.length;
        int n2 = 0;
        while (n2 < n) {
            VIBProperty property = vIBPropertyArray[n2];
            if (property.isRelationshipsProperty()) {
                buffer.append("<li value=\"page\" bindent=\"5\">");
                buffer.append("<a href=\"" + property.getNodeNames() + "\">" + property.getTitle() + "</a>: " + property.getDescription());
                buffer.append("</li>");
            }
            ++n2;
        }
        buffer.append("<p></p>");
        buffer.append("</form>");
        return buffer.toString();
    }

    public String getPlatformFormText() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<form>");
        buffer.append("<p>List the platforms to which this software will apply.</p>");
        buffer.append("<li value=\"page\" bindent=\"5\">");
        buffer.append("<a href=\"bulletin.platforms.softwarePlatform\">Software Platform</a>: A platform to which this software will apply.");
        buffer.append("</li>");
        buffer.append("<p></p>");
        buffer.append("</form>");
        return buffer.toString();
    }

    public static Map<String, String> getProperties(IProject project, Map<String, VIBProperty> infoproperties) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (VIBProperty property : infoproperties.values()) {
            properties.put(property.getNodeNames(), property.getDefaultPropertyValue(project));
        }
        return properties;
    }

    public static VIBProperty[] createAllProperties(PropertyManager manager) {
        return new VIBProperty[]{new VIBProperty(manager, TYPE_TEXT, TAG_NAME, ARG_NAME, TITLE_NAME, DESC_NAME, INPUT_NAMESTRING, null), new VIBProperty(manager, TYPE_TEXT, TAG_VERSION, ARG_VERSION, TITLE_VERSION, DESC_VERSION, INPUT_VERSION, null), new VIBProperty(manager, TYPE_TEXT, TAG_VIB_VENDOR, ARG_VENDOR, TITLE_VENDOR, DESC_VENDOR, INPUT_NAMESTRING, "VMware"), new VIBProperty(manager, TYPE_TEXT, TAG_VIB_SUMMARY, ARG_SUMMARY, TITLE_SUMMARY, DESC_SUMMARY, INPUT_SUMMARY, null), new VIBProperty(manager, TYPE_TEXT, TAG_VIB_DESC, ARG_DESC, TITLE_DESC, null, null, null), new VIBProperty(manager, TYPE_TEXT, TAG_BULLETIN_ID, ARG_BULLETIN_ID, TITLE_BULLETIN_ID, DESC_BULLETIN_ID, INPUT_BULLETIN_ID, null), new VIBProperty(manager, TYPE_TEXT, TAG_BULLETIN_VENDOR, ARG_VENDOR, TITLE_VENDOR, DESC_BULLETIN_VENDOR, ".+", "VMware"), new VIBProperty(manager, TYPE_TEXT, TAG_BULLETIN_SUMMARY, ARG_SUMMARY, TITLE_SUMMARY, DESC_BULLETIN_SUMMARY, INPUT_SUMMARY, null), new VIBProperty(manager, TYPE_MULTI_TEXT, TAG_BULLETIN_DESC, ARG_DESC, TITLE_DESC, DESC_BULLETIN_DESCRIPTION, null, null), new VIBProperty(manager, TYPE_TEXT, TAG_VENDOR_EMAIL, ARG_VENDOR_EMAIL, TITLE_VENDOR_EMAIL, DESC_BULLETIN_CONTACT, INPUT_EMAIL, "support@vmware.com"), new VIBProperty(manager, TYPE_TEXT, TAG_BULLETIN_KBURL, null, TITLE_KB_URL, DESC_BULLETIN_KB_URL, ".+", null), new VIBProperty(manager, TYPE_LIST, TAG_VIB_URLS_URL, ARG_KB_URL, TITLE_KB_URL, DESC_VIB_KB_URL, null, null), new VIBProperty(manager, TYPE_TEXT, TAG_VIB_RELEASE_DATE, ARG_RELEASE_DATE, TITLE_RELEASE_DATE, DESC_RELEASE_DATE, INPUT_RELEASE_DATE, null), new VIBProperty(manager, TYPE_CHECKBOX, TAG_MAINT, ARG_MAINT, TITLE_MAINT, DESC_MAINTENACE_MODE, null, null), new VIBProperty(manager, TYPE_HYPERLINK, TAG_RELATIONSHIPS, null, TITLE_RELATIONSHIPS, DESC_RELATIONSHIPS, null, null), new VIBProperty(manager, TYPE_RELATIONSHIPS, TAG_DEPENDS, null, TITLE_DEPENDS, DESC_DEPENDS, null, null), new VIBProperty(manager, TYPE_RELATIONSHIPS, TAG_CONFLICTS, null, TITLE_CONFLICTS, DESC_CONFLICTS, null, null), new VIBProperty(manager, TYPE_RELATIONSHIPS, TAG_REPLACES, null, TITLE_REPLACES, DESC_REPLACES, null, null), new VIBProperty(manager, TYPE_RELATIONSHIPS, TAG_PROVIDES, null, TITLE_PROVIDES, DESC_PROVIDES, null, null), new VIBProperty(manager, TYPE_RELATIONSHIPS, TAG_COMPATIBLEWITH, null, TITLE_COMPATIBLEWITH, DESC_COMPATIBLEWITH, null, null), new VIBProperty(manager, TYPE_HYPERLINK, TAG_PLATFORMS, null, "Software Platform", DESC_PLATFORMS, null, null), new VIBProperty(manager, TYPE_PLATFORMS, TAG_SOFTWARE_PLATFORM, null, "Software Platform", null, null, null), new VIBProperty(manager, TYPE_SYSTEM, TAG_SYSTEM_REQUIRES, null, TITLE_SYSTEM_REQUIRES, null, null, null), new VIBProperty(manager, TYPE_CHECKBOX, TAG_LIVE_INSTALL_ALLOWED, ARG_LIVE_INSTALL_ALLOWED, TITLE_LIVE_INSTALL_ALLOWED, DESC_LIVE_INSTALL_ALLOWED, null, null), new VIBProperty(manager, TYPE_CHECKBOX, TAG_LIVE_REMOVE_ALLOWED, ARG_LIVE_REMOVE_ALLOWED, TITLE_LIVE_REMOVE_ALLOWED, DESC_LIVE_INSTALL_ALLOWED, null, null), new VIBProperty(manager, TYPE_CHECKBOX, TAG_STATELESS_READY, null, TITLE_STATELESS_READY, DESC_STATELESS_READY, null, null), new VIBProperty(manager, TYPE_CHECKBOX, TAG_CIMOM_RESTART, null, TITLE_CIMOM_RESTART, DESC_CIMOM_RESTART, null, null), new VIBProperty(manager, TYPE_TEXT, TAG_CATEGORY, null, TITLE_CATEGORY, DESC_CATEGORY, INPUT_CATEGORY, "Enhancement"), new VIBProperty(manager, TYPE_TEXT, TAG_URGENCY, null, TITLE_URGENCY, DESC_URGENCY, INPUT_URGENCY, "Important")};
    }
}

