/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.vib.ui;

import com.vmware.vide.project.vib.VIBFileInfo;
import com.vmware.vide.project.vib.VIBProperty;
import com.vmware.vide.project.vib.ui.VIBEditor;
import com.vmware.vide.project.vib.ui.VIBOverviewPage;
import com.vmware.vide.vxmleditor.model.XMLDataModel;
import com.vmware.vide.vxmleditor.model.XMLNode;
import com.vmware.vide.vxmleditor.model.XMLTreeContentProvider;
import com.vmware.vide.vxmleditor.multipageeditor.XMLDesignPage;
import java.util.Map;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public class VIBDesignPage
extends XMLDesignPage {
    private VIBFileInfo vibinfo;
    private VIBProperty rootproperty;
    protected boolean isrootremovable;

    public VIBDesignPage(VIBEditor editor, String id, VIBFileInfo info, VIBProperty root, String tabtitle, String pagetitle, String treeblocktitle, String treeblockdesc, String detailspagetitle, Map<String, String> descs) {
        super((FormEditor)editor, id, VIBOverviewPage.capitalizeFirstCharOnly(tabtitle), pagetitle, treeblocktitle, treeblockdesc, detailspagetitle, descs);
        this.vibinfo = info;
        this.rootproperty = root;
        this.isrootremovable = false;
    }

    protected void createFormContent(IManagedForm mform) {
        super.createFormContent(mform);
        this.treeblock.getTreeViewer().setContentProvider((IContentProvider)new VIBTreeContentProvider());
    }

    public Object getXMLTreeInput() {
        return this.rootproperty;
    }

    public XMLDataModel getDataModel() {
        return this.vibinfo.getDataModel();
    }

    public void firePropertyChange() {
        if (this.getEditor() instanceof VIBEditor) {
            ((VIBEditor)this.editor).firePropertyChange();
        }
    }

    public boolean isPrpoeryTagIncluded(String propertynodenames) {
        return propertynodenames != null && propertynodenames.startsWith(this.rootproperty.getNodeNames());
    }

    public boolean setSelection(VIBProperty property) {
        if (property == null || !this.isPrpoeryTagIncluded(property.getNodeNames())) {
            return false;
        }
        Object[] nodes = this.vibinfo.getNodes(this.rootproperty, property);
        if (nodes != null && nodes.length > 0) {
            this.treeblock.getTreeViewer().setExpandedElements(nodes);
            this.treeblock.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object[])new XMLNode[]{nodes[nodes.length - 1]}), true);
            return true;
        }
        return false;
    }

    public class VIBTreeContentProvider
    extends XMLTreeContentProvider {
        public Object[] getElements(Object input) {
            if (input instanceof VIBProperty) {
                XMLNode data = VIBDesignPage.this.vibinfo.findXMLNode((VIBProperty)input);
                if (!VIBDesignPage.this.isrootremovable && input.equals(VIBDesignPage.this.rootproperty)) {
                    data.setRemovable(false);
                }
                if (data != null) {
                    return new Object[]{data};
                }
            }
            return super.getElements(input);
        }
    }
}

