/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.vib.ui;

import com.vmware.vide.project.vib.VIBFileInfo;
import com.vmware.vide.project.vib.VIBFileManager;
import com.vmware.vide.project.vib.ui.VIBDesignPage;
import com.vmware.vide.vxmleditor.editors.XMLEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class VIBEditor
extends FormEditor {
    private static final String TITLE_EDITOR = "VIB File Editor";
    private VIBFileManager vibmanager;
    private List<XMLEditor> editors = new ArrayList<XMLEditor>();

    public VIBFileManager getVIBFileManager() {
        return this.vibmanager;
    }

    protected void addPages() {
        try {
            int index = this.addPage((IFormPage)this.vibmanager.getVIBOverviewPage());
            this.vibmanager.getVIBOverviewPage().setIndex(index);
            for (VIBFileInfo vibinfo : this.vibmanager.getAllVIBInfo()) {
                XMLEditor textpage;
                IFormPage[] formPages;
                IFormPage[] iFormPageArray = formPages = vibinfo.getSpecificPages();
                int n = formPages.length;
                int n2 = 0;
                while (n2 < n) {
                    IFormPage p = iFormPageArray[n2];
                    this.addPage(p);
                    ++n2;
                }
                VIBDesignPage[] pages = vibinfo.getDesignPages();
                if (pages != null) {
                    VIBDesignPage[] vIBDesignPageArray = pages;
                    int n3 = pages.length;
                    n = 0;
                    while (n < n3) {
                        VIBDesignPage page = vIBDesignPageArray[n];
                        index = this.addPage((IFormPage)page);
                        page.setIndex(index);
                        ++n;
                    }
                }
                if ((textpage = vibinfo.getTextPage()) == null) continue;
                this.editors.add(textpage);
                index = this.addPage((IEditorPart)textpage, (IEditorInput)new FileEditorInput(vibinfo.getVIBFile()));
                this.setPageText(index, vibinfo.getFilename());
                vibinfo.setTextPageIndex(index);
            }
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)TITLE_EDITOR, (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof IFileEditorInput) {
            IFileEditorInput finput = (IFileEditorInput)input;
            if (finput.exists()) {
                this.vibmanager = VIBFileManager.getVIBFileManager(this, finput);
                super.init(site, input);
                IFile file = finput.getFile();
                if (file != null) {
                    this.setPartName(String.valueOf(file.getProject().getName()) + " vib");
                }
            }
        } else {
            throw new PartInitException("Unsupported editor input type.");
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.vibmanager.setInput(input);
    }

    protected void pageChange(int newpageindex) {
        this.vibmanager.pageChange(newpageindex);
        super.pageChange(newpageindex);
    }

    public void doSave(IProgressMonitor monitor) {
        this.vibmanager.doSave(monitor);
    }

    public void doSaveAs() {
        this.vibmanager.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void firePropertyChange() {
        this.firePropertyChange(257);
    }

    public Object getAdapter(Class c) {
        if (IContentOutlinePage.class.equals((Object)c)) {
            IEditorPart editorPart = this.getActiveEditor();
            if (editorPart == null && !this.editors.isEmpty()) {
                editorPart = (IEditorPart)this.editors.get(0);
            }
            if (editorPart instanceof XMLEditor) {
                XMLEditor editor = (XMLEditor)editorPart;
                return editor.getAdapter(c);
            }
            return null;
        }
        return super.getAdapter(c);
    }
}

