/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wbis.generator;

import com.vmware.vide.project.wbis.generator.IProjectGenerator;
import com.vmware.vide.project.wbis.model.input.SdkLibraries;
import com.vmware.vide.project.wbis.model.input.SdkSample;
import com.vmware.vide.project.wbis.model.output.ant.Project;
import com.vmware.vide.project.wbis.model.output.ant.Property;
import com.vmware.vide.project.wbis.model.output.ant.Target;
import com.vmware.vide.utils.xml.JaxbUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntProject
implements IProjectGenerator {
    private static final Logger logger = LoggerFactory.getLogger(AntProject.class);
    private static final String FILE_NAME = "build.xml";

    @Override
    public void generate(File destination, SdkSample sample, List<SdkLibraries> librariesList, IProgressMonitor monitor) throws Exception {
        Project project = new Project();
        project.setBasedir(".");
        project.setName(sample.getName());
        project.getProperty().addAll(this.createAntProperties());
        ArrayList<Target> antTargets = new ArrayList<Target>();
        antTargets.add(this.createAntTarget("clean", null));
        antTargets.add(this.createAntTarget("compile", null));
        antTargets.add(this.createAntTarget("jar", new ArrayList<String>()));
        antTargets.add(this.createAntTarget("run", null));
        project.getTarget().addAll(antTargets);
        try {
            File fXmlFile = new File(destination.toString(), FILE_NAME);
            JaxbUtils.toJaxbFormattedXml(Project.class, (File)fXmlFile, (Object)project, (boolean)false, (boolean)false);
            logger.info("Successfully generated build.xml for " + sample.getName() + " sample ");
        }
        catch (JAXBException e) {
            logger.error("JAXBException while trying to generate build file", (Throwable)e);
        }
        catch (ClassCastException e) {
            logger.error("ClassCastException while trying to generate build file", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception while trying to generate build file", (Throwable)e);
        }
    }

    private List<Property> createAntProperties() {
        ArrayList<Property> antProperties = new ArrayList<Property>();
        Property sourceProperty = new Property();
        sourceProperty.setName("src.dir");
        sourceProperty.setValue("src");
        Property buildProperty = new Property();
        buildProperty.setName("build.dir");
        buildProperty.setValue("build");
        Property classesProperty = new Property();
        classesProperty.setName("classes.dir");
        classesProperty.setValue("${build.dir}/classes");
        antProperties.add(sourceProperty);
        antProperties.add(buildProperty);
        antProperties.add(classesProperty);
        return antProperties;
    }

    private Target createAntTarget(String targetName, List<String> dependsOn) {
        Target target = new Target();
        target.setName(targetName);
        return target;
    }
}

