/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wbis.generator;

import com.vmware.vide.project.wbis.model.input.DependencySet;
import com.vmware.vide.project.wbis.model.input.Include;
import com.vmware.vide.project.wbis.model.input.MavenDependency;
import com.vmware.vide.project.wbis.model.input.SdkLibraries;
import com.vmware.vide.project.wbis.model.input.SdkSample;
import com.vmware.vide.project.wbis.model.input.SdkSamples;
import com.vmware.vide.project.wbis.model.output.config.Build;
import com.vmware.vide.project.wbis.model.output.config.Builders;
import com.vmware.vide.project.wbis.model.output.config.Category;
import com.vmware.vide.project.wbis.model.output.config.Common;
import com.vmware.vide.project.wbis.model.output.config.CreateVibxml;
import com.vmware.vide.project.wbis.model.output.config.Kit;
import com.vmware.vide.project.wbis.model.output.config.Option;
import com.vmware.vide.project.wbis.model.output.config.Project;
import com.vmware.vide.project.wbis.model.output.config.Projectinfo;
import com.vmware.vide.project.wbis.model.output.config.Projectnature;
import com.vmware.vide.project.wbis.model.output.config.System;
import com.vmware.vide.project.wbis.model.output.config.Templatefile;
import com.vmware.vide.project.wbis.model.output.config.Type;
import com.vmware.vide.project.wbis.model.output.config.Wizard;
import com.vmware.vide.utils.xml.JaxbUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigTemplateGenerator {
    private static final String MAVEN_REPO_URL = "http://repo1.maven.org/maven2";
    private static final String JAVA_BUILDER = "org.eclipse.jdt.core.javabuilder";
    private static final String PUBLIC_LIBRARIES = "public-libraries";
    private final List<SdkLibraries> sdkLibrariesList;
    private final List<SdkSamples> sdkSamplesList;
    private static final Logger logger = LoggerFactory.getLogger(ConfigTemplateGenerator.class);

    public ConfigTemplateGenerator(List<SdkLibraries> sdkLibrariesList, List<SdkSamples> sdkSamples, File destinationDirectory) {
        this.sdkLibrariesList = sdkLibrariesList;
        this.sdkSamplesList = sdkSamples;
    }

    public void write(File outputXmlFile) {
        Type type = new Type();
        type.setId("new_project");
        type.setEnabled(true);
        Category topCategory = new Category();
        topCategory.setTitle("Create Java project that uses");
        topCategory.setDescription("");
        topCategory.setInitpath("{{WORKSPACE_LOC}}");
        topCategory.setProjectNature("{{BUNDLE_ID}}");
        StringBuilder SDK_LIB_PATHS_VALUE = new StringBuilder();
        for (SdkLibraries s : this.sdkLibrariesList) {
            for (DependencySet dependencySet : s.getDependencySet()) {
                List<MavenDependency> dependencyList = dependencySet.getMavenDependency();
                for (MavenDependency dependency : dependencyList) {
                    if (dependencySet.getId().equals(PUBLIC_LIBRARIES)) {
                        SDK_LIB_PATHS_VALUE.append(dependency.getArtifactId()).append("-").append(dependency.getVersion()).append(".jar").append(",");
                        continue;
                    }
                    SDK_LIB_PATHS_VALUE.append(dependency.getFile()).append(",");
                }
            }
        }
        topCategory.getOption().add(this.generateOptionElements("SDK_LIB_PATHS", SDK_LIB_PATHS_VALUE.toString()));
        topCategory.getOption().add(this.generateOptionElements("COMMON_CLASS_LIBRARY_PATHS", "{{SDK_LIB_PATHS}}"));
        topCategory.getOption().add(this.generateOptionElements("PROJECT_CLASS_LIBRARY_PATHS_ATTRS", SDK_LIB_PATHS_VALUE.toString()));
        topCategory.getOption().add(this.generateOptionElements("SHARED_CLASS_LIBRARY_PATHS_ATTRS", SDK_LIB_PATHS_VALUE.toString()));
        Builders builders = new Builders();
        Build build = new Build();
        build.setName(JAVA_BUILDER);
        builders.getContent().add(build);
        for (SdkSamples sample : this.sdkSamplesList) {
            if (sample == null && this.sdkSamplesList.size() > 0) continue;
            Category category = new Category();
            category.setTitle(sample.getSdkSample().getName());
            category.setDescription(sample.getSdkSample().getDescription());
            category.getOption().add(this.generateOptionElements("SRC_PATHS", "src"));
            category.getOption().add(this.generateOptionElements("CLASS_LIBRARY_PATHS", "{{PROJECT_CLASS_LIBRARY_PATHS_ATTRS}}"));
            category.getOption().add(this.generateOptionElements("PROJECT_BASE_NAME", sample.getSdkSample().getName()));
            category.setProjectinfo(this.generateProjectInfoElement(sample.getSdkSample()));
            topCategory.getCategory().add(category);
        }
        type.setCategory(topCategory);
        Wizard wizard = new Wizard();
        wizard.setEnabled(true);
        wizard.setType(type);
        Kit kit = this.generateKitElements();
        kit.setSystem(this.generateSystemElements());
        kit.setProject(this.generateProjectElements());
        kit.setWizard(wizard);
        try {
            if (kit != null) {
                JaxbUtils.toJaxbFormattedXml(Kit.class, (File)outputXmlFile, (Object)kit, (boolean)false, (boolean)false);
            }
        }
        catch (JAXBException e) {
            logger.info("JAXBException while trying to generate output XML" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.info("Exception while trying to generate output XML" + e.getMessage(), (Throwable)e);
        }
    }

    private Option generateOptionElements(String name, String value) {
        Option option = new Option();
        option.setName(name);
        option.setValue(value);
        return option;
    }

    private Kit generateKitElements() {
        Kit kit = new Kit();
        Common common = this.generateCommonElements();
        kit.setCommon(common);
        return kit;
    }

    private Common generateCommonElements() {
        Common common = new Common();
        common.setId("vcd-sdk");
        common.setDescription("The VMware vCloud Director Plug-in Starter Kit enables software developers to develop applications that utilize vCloud Director APIs.");
        common.setName("vCloud Director Plug-in Development");
        common.setProjectidentity("org.eclipse.jdt.core.javanature");
        common.setTitle("vCloud Director Plug-in  Starter Kit");
        return common;
    }

    private System generateSystemElements() {
        System system = new System();
        system.setRootinstallpath("{{BUNDLE_PATH}}");
        system.setVersion("{{BUNDLE_VERSION_MMM}}");
        system.setInstallversion("{{BUNDLE_VERSION_QUALIFIER}}");
        return system;
    }

    private Project generateProjectElements() {
        Project project = new Project();
        Projectnature projectNature = new Projectnature();
        projectNature.setId("com.vmware.vide.core.vcdnature");
        projectNature.getOption().add(this.generateOptionElements("BUNDLE_ID", "com.vmware.vide.sdk.vcdjava"));
        projectNature.getOption().add(this.generateOptionElements("SDK_DIR", "{{(toPluginDirectory)BUNDLE_ID}}"));
        projectNature.getOption().add(this.generateOptionElements("SRC_PATHS", "src"));
        projectNature.getOption().add(this.generateOptionElements("OUTPUT_PATH", "bin"));
        projectNature.getOption().add(this.generateOptionElements("SAMPLES_DIR", "{{SDK_DIR}}/samples"));
        projectNature.getOption().add(this.generateOptionElements("SDK_LIB_DIR", "{{SDK_DIR}}/lib"));
        project.setProjectnature(projectNature);
        return project;
    }

    private Templatefile generateTemplatefileList(SdkSample sample) {
        Templatefile templateFile = new Templatefile();
        templateFile.setSourcepath(sample.getSource().getFileset().getDir());
        templateFile.setBinary(true);
        templateFile.setDestpath("src/com/vmware/sdk/samples");
        templateFile.setRecursive(true);
        templateFile.setFile("");
        for (Include include : sample.getSource().getFileset().getInclude()) {
            templateFile.setFile(String.valueOf(include.getName()) + ";" + templateFile.getFile());
        }
        return templateFile;
    }

    private List<Templatefile> generateTemplatefileList() {
        ArrayList<Templatefile> templateFiles = new ArrayList<Templatefile>();
        for (SdkLibraries s : this.sdkLibrariesList) {
            for (DependencySet dependencySet : s.getDependencySet()) {
                List<MavenDependency> dependencyList = dependencySet.getMavenDependency();
                for (MavenDependency dependency : dependencyList) {
                    Templatefile templateFile = new Templatefile();
                    if (dependencySet.getId().contains(PUBLIC_LIBRARIES)) {
                        templateFile.setRemote(true);
                        templateFile.setSourcepath("http://repo1.maven.org/maven2/" + dependency.getGroupId().replace('.', '/') + "/" + dependency.getArtifactId() + "/" + dependency.getVersion());
                    } else {
                        templateFile.setSourcepath("{{SDK_DIR}}/lib");
                    }
                    templateFile.setFile(String.valueOf(dependency.getArtifactId()) + "-" + dependency.getVersion() + ".jar");
                    templateFile.setDestpath("lib");
                    templateFiles.add(templateFile);
                }
            }
        }
        return templateFiles;
    }

    private CreateVibxml generateCreateVibxmlElement() {
        CreateVibxml createVibxml = new CreateVibxml();
        createVibxml.setOption("support-check:support-uncheck:notsupport");
        createVibxml.setValue("not support");
        return createVibxml;
    }

    private Builders generateBuildersElement() {
        Builders builders = new Builders();
        builders.getContent().add("Simple Builders");
        Build build = new Build();
        build.setBuilders(builders);
        Builders b = new Builders();
        b.getContent().add(build);
        return b;
    }

    private Projectinfo generateProjectInfoElement(SdkSample sample) {
        Projectinfo projectInfo = new Projectinfo();
        projectInfo.getTemplatefile().add(this.generateTemplatefileList(sample));
        projectInfo.getTemplatefile().addAll(this.generateTemplatefileList());
        projectInfo.setCreateVibxml(this.generateCreateVibxmlElement());
        projectInfo.setBuilders(this.generateBuildersElement());
        return projectInfo;
    }
}

