/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wbis.parser;

import com.vmware.vide.project.wbis.exception.InvalidXmlException;
import com.vmware.vide.project.wbis.model.input.DependencySet;
import com.vmware.vide.project.wbis.model.input.SdkLibraries;
import com.vmware.vide.utils.xml.JaxbUtils;
import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkLibrariesParser {
    private static final Logger logger = LoggerFactory.getLogger(SdkLibrariesParser.class);
    private SdkLibraries sdkLibraries = new SdkLibraries();

    public SdkLibraries getSdkLibraries() {
        return this.sdkLibraries;
    }

    public boolean parse(File xmlFile) throws InvalidXmlException {
        try {
            this.sdkLibraries = (SdkLibraries)JaxbUtils.toObject((File)xmlFile, (Class[])new Class[]{SdkLibraries.class});
            if (this.sdkLibraries == null) {
                return false;
            }
        }
        catch (UnmarshalException e) {
            logger.error("UnmarshalException while trying to interpret " + xmlFile.getName() + " as libraries xml: " + e.getMessage(), (Throwable)e);
            return false;
        }
        catch (ClassCastException e) {
            logger.error("ClassCastException while trying to interpret " + xmlFile.getName() + " as libraries xml: " + e.getMessage(), (Throwable)e);
            return false;
        }
        catch (JAXBException e) {
            logger.error("JAXBException while trying to interpret " + xmlFile.getName() + " as libraries xml: " + e.getMessage(), (Throwable)e);
            return false;
        }
        try {
            List<DependencySet> dependencySets = this.sdkLibraries.getDependencySet();
            if (dependencySets.size() == 0) {
                logger.warn("WARNING: file " + xmlFile.getName() + " contains no dependency sets.  Is this intentional?");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Exception while trying to interpret " + xmlFile.getName() + " as libraries xml: " + e.getMessage(), (Throwable)e);
            throw new InvalidXmlException(e);
        }
    }
}

