/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.newwizard;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.devkit.ProjectNatureInfo;
import com.vmware.vide.project.config.devkit.ProjectNaturePath;
import com.vmware.vide.project.config.wizard.project.ProjectData;
import com.vmware.vide.project.manager.ProjectManager;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.utils.VIDEProjectException;
import com.vmware.vide.project.wizard.ui.DevkitProjectWizardPage;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ProjectInfoPage
extends DevkitProjectWizardPage {
    private static final String MSG_PAGENAME = "Create Projects ";
    private static final String MSG_PROJLOC_CHECK = "Use default location";
    private static final String MSG_PROJECT_NAME = "Project name:";
    private static final String MSG_LOCATION = "Location:";
    private static final String MSG_BROWSE = "Browse...";
    private static final String MSG_CREATE_VIB = "Create default xml files for VIB package";
    private static final String MSG_PROBLEM = "Creation problems";
    private static final String MSG_CREATE_PROJECT = "Creating projects";
    private static final String MSG_PROJECT_IN_WORKSPACE = "The project cannot be created because it already exists in the workspace";
    private static final String DESC_INIT = "Specify project information";
    private static final String DESC_MISSING_PROJDIR = "Project location directory must be specified";
    private static final String DESC_MISSING_PROJNAME = "Project name must be specified";
    private static final String DESC_NAME_TOO_SHORT = "Project name must be at least two characters";
    private static final String DESC_NAME_HAS_INVALID_CHARACTER = "Project name must consist only of lower case letters, digits, minus sign and periods.";
    private static final String DESC_NAME_IS_VALID = "Project name is valid";
    private static final String WARNING_SYMLINK_SUPPORTED = "A symbolic link will be created for the project";
    private static final String WARNING_SYMLINK_NOTSUPPORTED = "The project directory should be under ";
    private static final ImageDescriptor IMG_VMWARE = ProjectPlugin.imageDescriptorFromPlugin((String)"com.vmware.vide.project", (String)"resources/images/vmware.png");
    private static final String CONTEXT_HELP_CONTENTS_ID = "context-newwizard-project-info";
    private static final String KEY_PROJECT_NATURE_PATH = "project_nature_path";
    private static final String ERR_MISSING_PROJECT_NATURE_PATH = "Specified path for [%s] does not exist.";
    private Text projpathtext;
    private Text projnametext;
    private Text projpathwarning;
    private Label projpathtitlelabel;
    private Button projpathloccheck;
    private Button projpathbutton;
    private Button checkvib;
    private ProjectData projectdata;
    private Group projectlocgroup;
    private String projectrootpath;
    private boolean is_project_inputs_available;
    private boolean is_vib_available;
    private final boolean is_symlink_supported;
    private List<Text> pathTexts;
    private Composite workArea;

    protected ProjectInfoPage() {
        this(MSG_PAGENAME, MSG_PAGENAME, IMG_VMWARE);
    }

    public ProjectInfoPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.is_symlink_supported = false;
    }

    public void setProjectData(ProjectData data) {
        String projectDest;
        if (data == null || this.projectdata != null && this.projectdata.equals(data)) {
            return;
        }
        this.projectdata = data;
        this.projectrootpath = this.projectdata.getDevkitProjectRootPath();
        this.setTitle(this.projectdata.getWizardTitle());
        boolean bl = this.is_project_inputs_available = this.projectdata.getOrderedUserInputs().size() > 0;
        if (this.projectdata.isProjectDestPathFixed()) {
            projectDest = Utils.replaceContent(data.getProjectDestPath(), data.getPropertyValues(null));
            this.projpathtext.setText(projectDest);
            this.projectlocgroup.setEnabled(false);
            this.projpathloccheck.setEnabled(false);
        } else {
            projectDest = data.getInitPath();
            if (projectDest != null) {
                projectDest = Utils.replaceContent(projectDest, data.getPropertyValues(null));
            }
            this.projpathtext.setText(projectDest);
            this.projectlocgroup.setEnabled(true);
            this.projpathloccheck.setEnabled(true);
        }
        String supportVIB = this.projectdata.getProperty("create_vibxml", true);
        boolean bl2 = this.is_vib_available = this.projectdata.getVIBData() != null && this.projectdata.getVIBData().getUserInputs().size() > 0;
        if (supportVIB != null) {
            this.is_vib_available = this.is_vib_available && !supportVIB.equals("notsupport");
        }
        this.checkvib.setVisible(this.is_vib_available);
        if (this.is_vib_available && supportVIB != null && supportVIB.equals("support-check")) {
            this.checkvib.setSelection(true);
            this.checkvib.notifyListeners(13, new Event());
        }
        this.projectdata.setVIBfileCreationInWizard(this.checkvib.getSelection());
        if (this.haveProjectNaturePaths(data)) {
            this.createProjectNaturePathsGroup();
        }
    }

    private boolean haveProjectNaturePaths(ProjectData data) {
        ProjectNatureInfo[] pnis;
        String[] natures = data.getProjectNature();
        ProjectNatureInfo[] projectNatureInfoArray = pnis = data.getDevkitInfo().getProjectNatureInfo(natures);
        int n = pnis.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectNatureInfo pni = projectNatureInfoArray[n2];
            if (!pni.getProjectNaturePaths().isEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && (this.is_project_inputs_available || this.is_vib_available && this.projectdata.isWizardCreatedVIBfiles());
    }

    public ProjectData getProjectData() {
        return this.projectdata;
    }

    public String getProjectName() {
        return this.projnametext.getText();
    }

    public IPath getProjectPath() {
        String pname = this.projnametext.getText();
        String ppath = this.projpathtext.getText();
        if (pname == null || ppath == null) {
            return null;
        }
        Path path = new Path(this.projpathtext.getText());
        return path.addTrailingSeparator().append(pname);
    }

    public Map<String, String> getAllProperties() {
        String[] properties_for_projectname = new String[]{"DRIVER_NAME"};
        Hashtable<String, String> properties = this.projectdata.getPropertyValues(null);
        if (!this.getProjectName().isEmpty() && !properties.containsKey("DRIVER_NAME")) {
            String[] stringArray = properties_for_projectname;
            int n = properties_for_projectname.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                properties.put(property, this.getProjectName());
                ++n2;
            }
        }
        return properties;
    }

    public boolean createProject() {
        MessageBox messageBox;
        final String name = this.projnametext.getText();
        final IPath path = this.getProjectPath();
        final boolean createvib = this.checkvib.getSelection();
        if (name == null || path == null) {
            Utils.openDialog(Utils.createNewWizardException("Insufficient project information ", null));
            return false;
        }
        if (path.append(".project").toFile().exists()) {
            messageBox = new MessageBox(this.getShell(), 196);
            messageBox.setMessage("A project exists in the specified project path, Existing project settings will be overridden. Do you want to overwrite it?");
            messageBox.setText("The existing project will be overridden");
            if (messageBox.open() != 64) {
                return false;
            }
        }
        if (path.toFile().exists() && path.toFile().listFiles().length > 0) {
            messageBox = new MessageBox(this.getShell(), 196);
            messageBox.setMessage("Files exist in the specified project path, all files will be overridden. Do you want to overwrite it?");
            messageBox.setText("The existing directory and files will be overridden");
            if (messageBox.open() != 64) {
                return false;
            }
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(ProjectInfoPage.MSG_CREATE_PROJECT, 100);
                        if (!name.isEmpty() && path != null) {
                            if (!path.toFile().exists() && !path.toFile().mkdirs()) {
                                Utils.openDialog(Utils.createNewWizardException("Unable to create the directory " + path.toString(), null));
                            }
                            if (path.toFile().exists()) {
                                String errormessage = null;
                                IProject project = ProjectInfoPage.this.projectdata.createIProject(name, path.toString(), (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                                if (project != null) {
                                    File projfile = ProjectInfoPage.this.projectdata.createProjectDirectory(project);
                                    ProjectInfoPage.this.projectdata.configureProject(project, projfile, true, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                                    if (createvib) {
                                        ProjectInfoPage.this.projectdata.createVIBFiles(project);
                                        ProjectInfoPage.this.projectdata.saveVIBData(project);
                                    }
                                    ProjectManager.putProjectProperty(project, "PROJECT_CREATION_TYPE", "new", false);
                                    if (project.isOpen()) {
                                        project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                    } else {
                                        project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                    }
                                } else {
                                    errormessage = "Failed to create the project ";
                                }
                                if (errormessage != null) {
                                    Utils.openDialog(Utils.createNewWizardException(errormessage, null));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof VIDEProjectException) {
                            Utils.openDialog((VIDEProjectException)e);
                        } else {
                            Utils.openDialog(Utils.createNewWizardException("Failed to create the project ", e));
                        }
                        ProjectInfoPage.this.projectdata.cleanConfiguratorProperties();
                        monitor.done();
                    }
                }
                finally {
                    ProjectInfoPage.this.projectdata.cleanConfiguratorProperties();
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = MSG_PROBLEM;
            Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "com.vmware.vide.project", 1, message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        this.saveProjectNaturePaths();
        return true;
    }

    public void createControl(Composite parent) {
        this.workArea = new Composite(parent, 0);
        this.setControl((Control)this.workArea);
        this.workArea.setLayout((Layout)new GridLayout());
        this.workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(this.workArea);
        this.createProjectLocGroup(this.workArea);
        this.createVIBGroup(this.workArea);
        this.setPageComplete(this.isProjectInfoComplete());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.vmware.vide.project.help.context-newwizard-project-info");
    }

    protected void createProjectNameGroup(Composite parent) {
        Composite projectnamegroup = new Composite(parent, 0);
        projectnamegroup.setLayout((Layout)new GridLayout(2, false));
        projectnamegroup.setLayoutData((Object)new GridData(768));
        projectnamegroup.setFont(parent.getFont());
        Label label = new Label(projectnamegroup, 0);
        label.setText(MSG_PROJECT_NAME);
        label.setLayoutData((Object)new GridData());
        this.projnametext = new Text(projectnamegroup, 2052);
        this.projnametext.setLayoutData((Object)new GridData(768));
        this.projnametext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProjectInfoPage.this.projectdata != null) {
                    ProjectInfoPage.this.projectdata.setCurrentProjectName(ProjectInfoPage.this.projnametext.getText());
                }
                ProjectInfoPage.this.setPageComplete(ProjectInfoPage.this.isProjectInfoComplete());
            }
        });
        this.projnametext.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                char k = e.character;
                if (k == '\b' || k == '\u007f') {
                    char c;
                    String text;
                    int len = e.end - e.start;
                    if (len == 0) {
                        len = 1;
                    }
                    ProjectInfoPage.this.clearErrorMessage();
                    if (ProjectInfoPage.this.projnametext.getText().length() - len < 2) {
                        ProjectInfoPage.this.setMessage(ProjectInfoPage.DESC_NAME_TOO_SHORT, 2);
                    }
                    if (e.start == 0 && (text = ProjectInfoPage.this.projnametext.getText()).length() > len && !this.isStartLetter(c = ProjectInfoPage.this.projnametext.getText().charAt(len))) {
                        ProjectInfoPage.this.setErrorMessage("Cannot start with '" + c + "'");
                    }
                    e.doit = true;
                    return;
                }
                char[] inputs = e.text.toCharArray();
                int i = 0;
                while (i < inputs.length) {
                    char c = inputs[i];
                    if (!this.isValidLetter(c)) {
                        ProjectInfoPage.this.setErrorMessage("Invalid character '" + c + "' has been typed");
                        Toolkit.getDefaultToolkit().beep();
                        e.doit = false;
                        return;
                    }
                    boolean invalidStart = false;
                    if (i == 0 && e.start == 0 && !this.isStartLetter(c)) {
                        invalidStart = true;
                    }
                    if (e.start != 0 && !this.isStartLetter(ProjectInfoPage.this.projnametext.getText().charAt(0))) {
                        c = ProjectInfoPage.this.projnametext.getText().charAt(0);
                        invalidStart = true;
                    }
                    if (invalidStart) {
                        ProjectInfoPage.this.setErrorMessage("Cannot start with '" + c + "'");
                        Toolkit.getDefaultToolkit().beep();
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
                ProjectInfoPage.this.clearErrorMessage();
                ProjectInfoPage.this.clearWarningMessage();
                if (ProjectInfoPage.this.projnametext.getText().length() + inputs.length < 2) {
                    ProjectInfoPage.this.setMessage(ProjectInfoPage.DESC_NAME_TOO_SHORT, 2);
                }
                e.doit = true;
            }

            private boolean isValidLetter(char c) {
                if (ProjectInfoPage.this.projectdata.isValidationRulesExist() && ProjectInfoPage.this.projectdata.getValidStartLetters() != null) {
                    String str = String.valueOf(c);
                    if (ProjectInfoPage.this.projectdata.getValidLetters().matcher(str).matches()) {
                        return true;
                    }
                } else if (this.isStartLetter(c) || c == '_' || c == '-') {
                    return true;
                }
                return false;
            }

            private boolean isStartLetter(char c) {
                if (ProjectInfoPage.this.projectdata.isValidationRulesExist() && ProjectInfoPage.this.projectdata.getValidStartLetters() != null) {
                    String str = String.valueOf(c);
                    if (ProjectInfoPage.this.projectdata.getValidStartLetters().matcher(str).matches()) {
                        return true;
                    }
                } else if ('a' <= c && c <= 'z' || '0' <= c && c <= '9') {
                    return true;
                }
                return false;
            }
        });
    }

    protected void createProjectLocGroup(Composite parent) {
        this.projectlocgroup = new Group(parent, 0);
        this.projectlocgroup.setLayout((Layout)new GridLayout(3, false));
        this.projectlocgroup.setLayoutData((Object)new GridData(768));
        this.projectlocgroup.setFont(parent.getFont());
        this.projectlocgroup.setText("Project Location");
        this.projpathloccheck = new Button((Composite)this.projectlocgroup, 32);
        this.projpathloccheck.setText(MSG_PROJLOC_CHECK);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.projpathloccheck.setLayoutData((Object)gridData);
        this.projpathloccheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProjectInfoPage.this.projpathloccheck.getSelection()) {
                    ProjectInfoPage.this.projpathtext.setText(ProjectInfoPage.this.projectdata.getInitPath());
                    ProjectInfoPage.this.projpathtitlelabel.setEnabled(false);
                    ProjectInfoPage.this.projpathtext.setEnabled(false);
                    ProjectInfoPage.this.projpathbutton.setEnabled(false);
                } else {
                    ProjectInfoPage.this.projpathtitlelabel.setEnabled(true);
                    ProjectInfoPage.this.projpathtext.setEnabled(true);
                    ProjectInfoPage.this.projpathbutton.setEnabled(true);
                    ProjectInfoPage.this.projpathwarning.setEnabled(true);
                }
            }
        });
        this.projpathtitlelabel = new Label((Composite)this.projectlocgroup, 0);
        this.projpathtitlelabel.setText(MSG_LOCATION);
        this.projpathtitlelabel.setLayoutData((Object)new GridData());
        this.projpathtext = new Text((Composite)this.projectlocgroup, 2052);
        this.projpathtext.setLayoutData((Object)new GridData(768));
        this.projpathtext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectInfoPage.this.setPageComplete(ProjectInfoPage.this.isProjectInfoComplete());
            }
        });
        this.projpathbutton = new Button((Composite)this.projectlocgroup, 8);
        this.projpathbutton.setText(MSG_BROWSE);
        this.projpathbutton.setLayoutData((Object)new GridData());
        this.projpathbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(ProjectInfoPage.this.getShell(), 4096);
                dirDialog.setFilterPath(ProjectInfoPage.this.projpathtext.getText());
                String path = dirDialog.open();
                if (path != null) {
                    ProjectInfoPage.this.projpathtext.setText(path);
                }
            }
        });
        this.projpathwarning = new Text((Composite)this.projectlocgroup, 10);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        this.projpathwarning.setLayoutData((Object)gridData);
        if (this.is_symlink_supported) {
            this.projpathwarning.setText(this.toMultiLine(WARNING_SYMLINK_SUPPORTED, 0));
        } else if (this.projectrootpath != null) {
            this.projpathwarning.setText(this.toMultiLine(WARNING_SYMLINK_NOTSUPPORTED + this.projectrootpath, 0));
        }
        this.projpathloccheck.setSelection(true);
        this.projpathtitlelabel.setEnabled(false);
        this.projpathtext.setEnabled(false);
        this.projpathbutton.setEnabled(false);
        this.projpathwarning.setVisible(false);
    }

    protected void createVIBGroup(Composite parent) {
        Composite vibgroup = new Composite(parent, 0);
        vibgroup.setLayout((Layout)new GridLayout(2, false));
        vibgroup.setLayoutData((Object)new GridData(768));
        vibgroup.setFont(parent.getFont());
        this.checkvib = new Button(vibgroup, 32);
        this.checkvib.setText(MSG_CREATE_VIB);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.checkvib.setLayoutData((Object)gridData);
        this.checkvib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectInfoPage.this.projectdata.setVIBfileCreationInWizard(ProjectInfoPage.this.checkvib.getSelection());
                ProjectInfoPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    private void createProjectNaturePathsGroup() {
        Composite comp = new Composite(this.workArea, 0);
        comp.setLayout((Layout)new GridLayout(3, false));
        comp.setLayoutData((Object)new GridData(768));
        comp.setFont(this.workArea.getFont());
        this.pathTexts = new ArrayList<Text>();
        List<ProjectNaturePath> pnPaths = this.getProjectNaturePaths();
        for (ProjectNaturePath pnp : pnPaths) {
            this.pathTexts.add(this.createProjectNaturePathBlock(comp, pnp));
        }
        this.workArea.layout();
        Rectangle rec = this.getContainer().getShell().getBounds();
        Point point = this.getContainer().getShell().computeSize(-1, -1);
        rec.height = point.y;
        rec.width = point.x;
        this.getContainer().getShell().setBounds(rec);
    }

    private Text createProjectNaturePathBlock(Composite comp, final ProjectNaturePath pnp) {
        Label l = new Label(comp, 0);
        l.setText(String.valueOf(pnp.getTitle()) + ":");
        final Text t = new Text(comp, 2052);
        String p = pnp.getInitialPath();
        Hashtable<String, String> properties = this.projectdata.getPropertyValues(null);
        p = Utils.replaceContent(p, properties);
        Path path = new Path(p);
        t.setText(path.toOSString());
        t.setToolTipText(pnp.getDesc());
        t.setData(KEY_PROJECT_NATURE_PATH, (Object)pnp);
        GridData gd = new GridData(768);
        t.setLayoutData((Object)gd);
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean b = ProjectInfoPage.this.isProjectInfoComplete();
                if (b) {
                    ProjectInfoPage.this.setErrorMessage(null);
                }
                ProjectInfoPage.this.setPageComplete(b);
            }
        });
        Button b = new Button(comp, 8);
        b.setText(MSG_BROWSE);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path;
                if (pnp.isDir()) {
                    DirectoryDialog dlg = new DirectoryDialog(ProjectInfoPage.this.getShell(), 4096);
                    dlg.setText(pnp.getTitle());
                    dlg.setMessage(pnp.getDesc());
                    dlg.setFilterPath(pnp.getInitialPath());
                    path = dlg.open();
                } else {
                    int opt = pnp.isRequired() ? 4096 : 8192;
                    FileDialog dlg = new FileDialog(ProjectInfoPage.this.getShell(), opt);
                    dlg.setText(pnp.getTitle());
                    dlg.setFilterPath(pnp.getInitialPath());
                    if (pnp.getFilter() != null && !pnp.getFilter().isEmpty()) {
                        dlg.setFilterExtensions(new String[]{pnp.getFilter(), "*"});
                        dlg.setFilterNames(new String[]{pnp.getFilterName(), "All files (*)"});
                    }
                    path = dlg.open();
                }
                if (path != null) {
                    t.setText(path);
                }
            }
        });
        return t;
    }

    private List<ProjectNaturePath> getProjectNaturePaths() {
        ProjectNatureInfo[] pnis;
        ArrayList<ProjectNaturePath> pnPaths = new ArrayList<ProjectNaturePath>();
        if (this.projectdata == null) {
            return pnPaths;
        }
        String[] natures = this.projectdata.getProjectNature();
        ProjectNatureInfo[] projectNatureInfoArray = pnis = this.projectdata.getDevkitInfo().getProjectNatureInfo(natures);
        int n = pnis.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectNatureInfo pni = projectNatureInfoArray[n2];
            List<ProjectNaturePath> paths = pni.getProjectNaturePaths();
            if (paths != null) {
                pnPaths.addAll(paths);
            }
            ++n2;
        }
        return pnPaths;
    }

    private void saveProjectNaturePaths() {
        if (this.pathTexts != null) {
            for (Text t : this.pathTexts) {
                ProjectNaturePath pnp = (ProjectNaturePath)t.getData(KEY_PROJECT_NATURE_PATH);
                pnp.updateInitialPath(t.getText());
            }
        }
    }

    private boolean isProjectInfoComplete() {
        String name = this.projnametext.getText();
        this.setDescription(DESC_INIT);
        if (name.isEmpty()) {
            this.setDescription(DESC_MISSING_PROJNAME);
            return false;
        }
        String message = this.projectdata.isValidationRulesExist() && this.projectdata.getValidLetters() != null && this.projectdata.getValidStartLetters() != null ? this.validateProjectName(name, this.projectdata.getValidProjectName()) : this.validateProjectName(name);
        if (!message.equals(DESC_NAME_IS_VALID)) {
            return false;
        }
        if (ProjectData.isProjectInWorkspace(name)) {
            this.setErrorMessage(MSG_PROJECT_IN_WORKSPACE);
            return false;
        }
        if (this.projpathtext.getText().isEmpty()) {
            this.setErrorMessage(DESC_MISSING_PROJDIR);
            return false;
        }
        if (this.pathTexts != null) {
            for (Text t : this.pathTexts) {
                ProjectNaturePath pnp = (ProjectNaturePath)t.getData(KEY_PROJECT_NATURE_PATH);
                if (pnp.isRequired()) {
                    File f = new File(t.getText());
                    if (pnp.isDir()) {
                        if (!f.isDirectory()) {
                            this.setErrorMessage(String.format(ERR_MISSING_PROJECT_NATURE_PATH, pnp.getTitle()));
                            return false;
                        }
                    } else if (!f.exists()) {
                        this.setErrorMessage(String.format(ERR_MISSING_PROJECT_NATURE_PATH, pnp.getTitle()));
                        return false;
                    }
                }
                if (this.projectdata == null) continue;
                this.projectdata.setProjectNatureProperty(pnp.getName(), t.getText());
            }
        }
        if (this.projectrootpath != null && !Platform.getOS().equals("win32")) {
            if (!this.projpathtext.getText().startsWith(this.projectrootpath)) {
                this.projpathwarning.setVisible(true);
                if (!this.is_symlink_supported) {
                    this.setErrorMessage(WARNING_SYMLINK_NOTSUPPORTED + this.projectrootpath);
                    return false;
                }
            } else {
                this.projpathwarning.setVisible(false);
            }
        }
        return true;
    }

    private String toMultiLine(String message, int max) {
        int n = max = max == 0 ? 80 : max;
        if (message.length() < max) {
            return message;
        }
        int size = max;
        while (message.length() > size) {
            int index = message.indexOf(" ", size);
            if (index == -1) {
                index = size;
            } else if (index - size > 5) {
                index = size;
            }
            message = String.valueOf(message.substring(0, index)) + "\n" + message.substring(index).trim();
            size = index + max;
        }
        return message;
    }

    private void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    private void clearWarningMessage() {
        this.setMessage(null, 2);
    }

    private String validateProjectName(String name) {
        if (name.length() < 2) {
            return DESC_NAME_TOO_SHORT;
        }
        if (!name.matches("^[a-z0-9][a-z0-9-_]+")) {
            return DESC_NAME_HAS_INVALID_CHARACTER;
        }
        return DESC_NAME_IS_VALID;
    }

    @Override
    public boolean okToFinish() {
        return this.isProjectInfoComplete();
    }

    private String validateProjectName(String name, Pattern validProjectName) {
        if (name.length() < 2) {
            return DESC_NAME_TOO_SHORT;
        }
        if (!validProjectName.matcher(name).matches()) {
            return DESC_NAME_HAS_INVALID_CHARACTER;
        }
        return DESC_NAME_IS_VALID;
    }
}

