/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.ui;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.vib.UserInput;
import com.vmware.vide.project.config.vib.UserInputHelper;
import com.vmware.vide.project.config.vib.UserInputHelperCommand;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.wizard.ui.BuiltinCommandRunner;
import com.vmware.vide.project.wizard.ui.EclipseCommandRunner;
import com.vmware.vide.project.wizard.ui.ExternalCommandRunner;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionEvent;

abstract class UserInputHelperCommandRunner {
    protected static final ILog logger = ProjectPlugin.getDefault().getLog();
    private static final char NAME_VALUE_SEPARATOR = '=';
    protected final SelectionEvent event;
    protected final UserInputHelperCommand command;
    protected final Map<String, String> properties;
    protected final String text;
    protected final UserInput inputdata;
    protected final UserInputHelper helper;

    UserInputHelperCommandRunner(SelectionEvent event, UserInputHelperCommand command, Map<String, String> properties, String text, UserInput inputdata, UserInputHelper helper) {
        this.event = event;
        this.command = command;
        this.properties = properties;
        this.text = text;
        this.inputdata = inputdata;
        this.helper = helper;
    }

    abstract String run(Map<String, String> var1);

    public static UserInputHelperCommandRunner createCommandRunner(SelectionEvent event, UserInputHelperCommand command, Map<String, String> properties, String text, UserInput inputdata, UserInputHelper helper) {
        if (command.isBuiltin()) {
            return BuiltinCommandRunner.createRunner(event, command, properties, text, inputdata, helper);
        }
        if (command.isExternal()) {
            return new ExternalCommandRunner(event, command, properties, text, inputdata, helper);
        }
        return new EclipseCommandRunner(event, command, properties, text, inputdata, helper);
    }

    private String getNameKey(String argName) {
        return String.valueOf(argName) + '=';
    }

    private String getArgValue(UserInputHelperCommand command, Map<String, String> properties, String argName) {
        String key = this.getNameKey(argName);
        for (String arg : command.getArgs()) {
            if (!arg.startsWith(key)) continue;
            return Utils.replaceContent(arg.substring(key.length()), properties);
        }
        return null;
    }

    protected String getArgValue(String argName) {
        return this.getArgValue(this.command, this.properties, argName);
    }

    private boolean getArgBooleanValue(UserInputHelperCommand command, Map<String, String> properties, String argName) {
        if (command.getArgs().contains(argName)) {
            return true;
        }
        String val = this.getArgValue(command, properties, argName);
        return Boolean.parseBoolean(val);
    }

    protected boolean getArgBooleanValue(String argName) {
        return this.getArgBooleanValue(this.command, this.properties, argName);
    }

    private Integer getArgIntValue(UserInputHelperCommand command, Map<String, String> properties, String argName) {
        String key = this.getNameKey(argName);
        for (String arg : command.getArgs()) {
            if (!arg.startsWith(key)) continue;
            String val = Utils.replaceContent(arg.substring(key.length()), properties);
            try {
                return new Integer(val);
            }
            catch (NumberFormatException e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Bad value " + val, (Throwable)e));
            }
        }
        return null;
    }

    protected Integer getArgIntValue(String argName) {
        return this.getArgIntValue(this.command, this.properties, argName);
    }

    private String[] getArgMultipleValues(UserInputHelperCommand command, Map<String, String> properties, String argName) {
        String key = this.getNameKey(argName);
        ArrayList<String> values = null;
        for (String arg : command.getArgs()) {
            if (!arg.startsWith(key)) continue;
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.add(arg.substring(key.length()));
        }
        if (values == null) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    protected String[] getArgMultipleValues(String argName) {
        return this.getArgMultipleValues(this.command, this.properties, argName);
    }
}

