/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.vibwizard;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.vib.VIBData;
import com.vmware.vide.project.wizard.ui.DevkitProjectWizardPage;
import com.vmware.vide.project.wizard.ui.UserInputGroupComposite;
import com.vmware.vide.project.wizard.ui.UserInputWidget;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class VIBInfoWizardPage
extends DevkitProjectWizardPage {
    private static final String MSG_PAGENAME = "VIB Information";
    private static final ImageDescriptor IMG_VMWARE = ProjectPlugin.imageDescriptorFromPlugin((String)"com.vmware.vide.project", (String)"resources/images/vmware.png");
    private static final String CONTEXT_HELP_CONTENTS_ID = "context-newwizard-vib-info";
    private VIBData curvibdata;
    private IProject curproject;
    UserInputGroupComposite inputgroupcomposite;

    protected VIBInfoWizardPage(String pageName, String title, ImageDescriptor titleImage, VIBData data, IProject project) {
        super(pageName, title, titleImage);
        this.curvibdata = data;
        this.curproject = project;
    }

    protected VIBInfoWizardPage(VIBData data, IProject project) {
        this(MSG_PAGENAME, MSG_PAGENAME, IMG_VMWARE, data, project);
    }

    public VIBInfoWizardPage() {
        this(MSG_PAGENAME, MSG_PAGENAME, IMG_VMWARE, null, null);
    }

    public void createControl(Composite parent) {
        Composite maincomposite = new Composite(parent, 0);
        this.setControl((Control)maincomposite);
        maincomposite.setLayout((Layout)new GridLayout());
        maincomposite.setLayoutData((Object)new GridData(1808));
        this.inputgroupcomposite = new UserInputGroupComposite(maincomposite);
        this.inputgroupcomposite.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (event instanceof UserInputWidget.UserInputWidgetEvent) {
                    if (VIBInfoWizardPage.this.inputgroupcomposite.hasInputGroupError()) {
                        VIBInfoWizardPage.this.setPageComplete(false);
                    } else {
                        VIBInfoWizardPage.this.setPageComplete(true);
                    }
                }
            }
        });
        HashMap<QualifiedName, String> persistentProp = new HashMap();
        if (this.curproject != null) {
            try {
                persistentProp = this.curproject.getPersistentProperties();
            }
            catch (CoreException coreException) {}
        }
        if (this.curvibdata != null && this.curvibdata.isValid()) {
            this.inputgroupcomposite.createUserInputs(this.curvibdata, this.curvibdata.getPropertyValuesForProject(this.curproject), "com.vmware.vide.project.VIBDATA", persistentProp);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.vmware.vide.project.help.context-newwizard-vib-info");
    }

    public void updateVIBData(VIBData data, Map<String, String> properties) {
        if (data != null) {
            if (this.curvibdata == null || !this.curvibdata.equals(data)) {
                HashMap<QualifiedName, String> persistentProp = new HashMap();
                if (this.curproject != null) {
                    try {
                        persistentProp = this.curproject.getPersistentProperties();
                    }
                    catch (CoreException coreException) {}
                }
                this.curvibdata = data;
                this.inputgroupcomposite.createUserInputs(this.curvibdata, properties, "com.vmware.vide.project.VIBDATA", persistentProp);
            } else {
                this.inputgroupcomposite.updateDefaultValueOfUserInputs(properties);
            }
        }
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && !this.inputgroupcomposite.hasInputGroupError();
    }

    @Override
    public boolean okToFinish() {
        return super.isPageComplete() && !this.inputgroupcomposite.hasInputGroupError() && !this.inputgroupcomposite.hasInputGroupWarning();
    }
}

