/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.AutoDeployOperationData;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AutoDeployCommandDialog
extends TitleAreaDialog {
    public static final String PRE_COMMANDS_GROUP_NAME = "Pre-deploy commands";
    public static final String PRE_COMMANDS_TEXT_NAME = "PreCommandsText";
    public static final String POST_COMMANDS_GROUP_NAME = "Post-deploy commands";
    public static final String POST_COMMANDS_TEXT_NAME = "PostCommandsText";
    public static final String OPERATION_INFORMATION_TEXT_NAME = "OperationInformationText";
    private static final int MAX_INFORMATION_TEXT_LINES = 4;
    private static final int DEFAULT_EDIT_TEXT_LINES = 5;
    private static final String CLEAR_ALL_LABEL = "&Clear All";
    private static final int CLEAR_ALL_ID = 1024;
    private static final String CLEAR_ALL_BUTTON_DESC = "Clear commands in the pre-commands and the post-commands text area.";
    private AutoDeployOperationData data;
    private Text preCommandsText;
    private Text postCommandsText;
    private Text operationInformationText;
    private String preCommands;
    private String postCommands;

    public AutoDeployCommandDialog(Shell parentShell, AutoDeployOperationData data) {
        super(parentShell);
        this.data = data;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle("Edit Commands for Auto Deploy Operation");
        this.getShell().setText("Edit Commands");
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(comp, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setFont(comp.getFont());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        composite.setLayoutData((Object)gd);
        this.createInformationGroup(composite);
        this.preCommandsText = this.createTextEditGroup(composite, PRE_COMMANDS_GROUP_NAME, this.data.getPreCommands(), PRE_COMMANDS_TEXT_NAME);
        this.postCommandsText = this.createTextEditGroup(composite, POST_COMMANDS_GROUP_NAME, this.data.getPostCommands(), POST_COMMANDS_TEXT_NAME);
        return composite;
    }

    private void createInformationGroup(Composite parent) {
        Group group = this.createGroup(parent, "File Deploy Information", 1, 1, 1808);
        Composite comp = this.createComposite((Composite)group, 1, 1, 1808);
        Label label = new Label(comp, 0);
        label.setText("File deploy operation: " + this.data.getName());
        label.setFont(comp.getFont());
        comp = this.createComposite((Composite)group, 1, 1, 1808);
        GridData gd = new GridData(1808);
        String infoText = this.data.getInformationText();
        this.operationInformationText = new Text(comp, 2826);
        this.operationInformationText.setFont(comp.getFont());
        this.operationInformationText.setData("name", (Object)OPERATION_INFORMATION_TEXT_NAME);
        this.operationInformationText.setBackground(comp.getDisplay().getSystemColor(29));
        if (infoText.split("\n").length > 4) {
            gd.heightHint = this.operationInformationText.getLineHeight() * 4;
        }
        this.operationInformationText.setLayoutData((Object)gd);
        this.operationInformationText.setText(infoText);
    }

    private Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private Text createTextEditGroup(Composite parent, String groupName, String initialText, String textName) {
        Group group = this.createGroup(parent, groupName, 1, 1, 1808);
        Text text = new Text((Composite)group, 2818);
        text.setFont(group.getFont());
        GridData gd = new GridData(1808);
        gd.heightHint = text.getLineHeight() * 5;
        text.setLayoutData((Object)gd);
        if (initialText != null) {
            text.setText(initialText);
        } else {
            text.setText("");
        }
        text.setData("name", (Object)textName);
        return text;
    }

    private Composite createComposite(Composite parent, int columns, int hspan, int fill) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(columns, false));
        composite.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        composite.setLayoutData((Object)gd);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        Button b = this.createButton(parent, 1024, CLEAR_ALL_LABEL, false);
        b.setToolTipText(CLEAR_ALL_BUTTON_DESC);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.preCommands = this.preCommandsText.getText();
            this.postCommands = this.postCommandsText.getText();
            this.okPressed();
        } else if (buttonId == 1) {
            this.cancelPressed();
        } else if (buttonId == 1024) {
            this.preCommandsText.setText("");
            this.postCommandsText.setText("");
        }
    }

    public String getPreCommands() {
        return this.preCommands;
    }

    public String getPostCommands() {
        return this.postCommands;
    }
}

