/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.FileDeployOperationsDatabase;
import com.vmware.vide.deploy.IFileDeployExportDataReader;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileDeployExportData
implements IFileDeployExportDataReader {
    private static final String TAG_FILE_DEPLOY = "file-deploy";
    private static final String TAG_TARGET_DESTINATION = "target-desination";
    private static final String TAG_OPTIONS = "options";
    private static final String TAG_RESOURCES = "resources";
    private static final String TAG_PROJECT = "project";
    private static final String TAG_FOLDER = "folder";
    private static final String TAG_FILE = "file";
    private static final String ATTR_TARGET_DESTINATION_PATH = "path";
    private static final String ATTR_TARGET_TYPE = "type";
    private static final String ATTR_OPTIONS_CREATE_ENTIRE_DIRS = "create-entire-dirs";
    private static final String ATTR_RESOURCES_PATH = "path";
    private List<IResource> savingResources;
    private List<RestoredResource> restoredResources;
    private String targetDestination;
    private String targetType;
    private boolean createEntireDirs;
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    public List<RestoredResource> getRestoredResources() {
        return this.restoredResources;
    }

    @Override
    public String getTargetDestination() {
        return this.targetDestination;
    }

    @Override
    public String getTargetType() {
        return this.targetType;
    }

    @Override
    public boolean getCreateEntireDirsOption() {
        return this.createEntireDirs;
    }

    public FileDeployExportData(List<IResource> resources, String targetDestination, String type, boolean createEntireDirs) {
        this.savingResources = resources;
        this.restoredResources = null;
        this.targetDestination = targetDestination;
        this.targetType = type;
        this.createEntireDirs = createEntireDirs;
    }

    public FileDeployExportData() {
        this.savingResources = null;
        this.restoredResources = new ArrayList<RestoredResource>();
        this.targetDestination = null;
        this.targetType = null;
        this.createEntireDirs = false;
    }

    public void save(String propertyName) throws Exception {
        if (propertyName.contains("deploy*")) {
            throw new Exception("Bad name");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element deployElem = doc.createElement(TAG_FILE_DEPLOY);
        doc.appendChild(deployElem);
        Element targetDestinationElem = doc.createElement(TAG_TARGET_DESTINATION);
        deployElem.appendChild(targetDestinationElem);
        targetDestinationElem.setAttribute("path", this.targetDestination);
        targetDestinationElem.setAttribute(ATTR_TARGET_TYPE, this.targetType);
        Element optionsElem = doc.createElement(TAG_OPTIONS);
        deployElem.appendChild(optionsElem);
        optionsElem.setAttribute(ATTR_OPTIONS_CREATE_ENTIRE_DIRS, "" + this.createEntireDirs);
        Element resourcesElem = doc.createElement(TAG_RESOURCES);
        deployElem.appendChild(resourcesElem);
        for (IResource r : this.savingResources) {
            if (!(r instanceof IResource)) continue;
            IResource res = r;
            Element element = null;
            if (res.getType() == 4) {
                element = doc.createElement(TAG_PROJECT);
            } else if (res.getType() == 1) {
                element = doc.createElement(TAG_FILE);
            } else if (res.getType() == 2) {
                element = doc.createElement(TAG_FOLDER);
            }
            if (element == null) continue;
            resourcesElem.appendChild(element);
            element.setAttribute("path", res.getFullPath().toString());
        }
        DOMSource source = new DOMSource(doc);
        StringWriter buf = new StringWriter();
        StreamResult result = new StreamResult(buf);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        xformer.transform(source, result);
        FileDeployOperationsDatabase.put(propertyName, buf.toString());
        this.name = propertyName;
    }

    public void restore(String propertyName) throws Exception {
        if (propertyName.contains("deploy*")) {
            throw new Exception("Bad name");
        }
        String xmlConfigData = FileDeployOperationsDatabase.get(propertyName);
        if (xmlConfigData == null) {
            throw new Exception("Specified property [" + propertyName + " is not existing in the preference.");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dbf.setIgnoringComments(true);
            ByteArrayInputStream xmlConfigDataStream = new ByteArrayInputStream(xmlConfigData.getBytes());
            doc = db.parse(xmlConfigDataStream);
        }
        catch (Exception exception) {
            throw new Exception("Failed to parse the XML data.");
        }
        assert (doc != null);
        Element elem = doc.getDocumentElement();
        if (!elem.getNodeName().equals(TAG_FILE_DEPLOY)) {
            throw new Exception("Wrong tag: Found [" + elem.getNodeName() + "] " + "!= [" + TAG_FILE_DEPLOY + "] expected.");
        }
        NodeList deployNodes = elem.getChildNodes();
        boolean doneTargetDestination = false;
        boolean doneOptions = false;
        boolean doneResources = false;
        int i = 0;
        while (i < deployNodes.getLength()) {
            Node n = deployNodes.item(i);
            if (n.getNodeType() == 1) {
                if (n.getNodeName().equals(TAG_TARGET_DESTINATION)) {
                    if (doneTargetDestination) {
                        throw new DuplicatedTagException(n.getNodeName());
                    }
                    String attrPath = ((Element)n).getAttribute("path");
                    if (attrPath == null) {
                        throw new CantFindAttrException(n.getNodeName(), "path");
                    }
                    String attrType = ((Element)n).getAttribute(ATTR_TARGET_TYPE);
                    if (attrType == null) {
                        throw new CantFindAttrException(n.getNodeName(), ATTR_TARGET_TYPE);
                    }
                    doneTargetDestination = true;
                    this.targetDestination = attrPath;
                    this.targetType = attrType;
                } else if (n.getNodeName().equals(TAG_OPTIONS)) {
                    if (doneOptions) {
                        throw new DuplicatedTagException(n.getNodeName());
                    }
                    String attr = ((Element)n).getAttribute(ATTR_OPTIONS_CREATE_ENTIRE_DIRS);
                    if (attr == null) {
                        throw new CantFindAttrException(n.getNodeName(), ATTR_OPTIONS_CREATE_ENTIRE_DIRS);
                    }
                    doneOptions = true;
                    this.createEntireDirs = Boolean.parseBoolean(attr);
                } else if (n.getNodeName().equals(TAG_RESOURCES)) {
                    if (doneResources) {
                        throw new DuplicatedTagException(n.getNodeName());
                    }
                    this.readResources((Element)n);
                } else {
                    throw new Exception("Bad tag: " + n.getNodeName());
                }
            }
            ++i;
        }
        this.name = propertyName;
    }

    private void readResources(Element resourcesElem) throws Exception {
        NodeList resourceNodes = resourcesElem.getChildNodes();
        int i = 0;
        while (i < resourceNodes.getLength()) {
            Node resNode = resourceNodes.item(i);
            if (resNode.getNodeType() == 1) {
                String attr;
                if (resNode.getNodeName().equals(TAG_FILE)) {
                    attr = ((Element)resNode).getAttribute("path");
                    if (attr == null) {
                        throw new CantFindAttrException(resNode.getNodeName(), "path");
                    }
                    this.restoredResources.add(new RestoredResource(TAG_FILE, attr));
                } else if (resNode.getNodeName().equals(TAG_FOLDER)) {
                    attr = ((Element)resNode).getAttribute("path");
                    if (attr == null) {
                        throw new CantFindAttrException(resNode.getNodeName(), "path");
                    }
                    this.restoredResources.add(new RestoredResource(TAG_FOLDER, attr));
                } else if (resNode.getNodeName().equals(TAG_PROJECT)) {
                    attr = ((Element)resNode).getAttribute("path");
                    if (attr == null) {
                        throw new CantFindAttrException(resNode.getNodeName(), "path");
                    }
                    this.restoredResources.add(new RestoredResource(TAG_PROJECT, attr));
                } else {
                    throw new Exception("Bad tag:" + resNode.getNodeName());
                }
            }
            ++i;
        }
    }

    @Override
    public List<IResource> getResources() {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (RestoredResource r : this.restoredResources) {
            IWorkspace w;
            Path path;
            if (r.getType() == TAG_FILE) {
                path = new Path(r.getResource());
                w = ResourcesPlugin.getWorkspace();
                IFile iFile = w.getRoot().getFile((IPath)path);
                if (iFile == null) continue;
                resources.add((IResource)iFile);
                continue;
            }
            if (r.getType() == TAG_FOLDER) {
                path = new Path(r.getResource());
                w = ResourcesPlugin.getWorkspace();
                IFolder iFolder = w.getRoot().getFolder((IPath)path);
                if (iFolder == null) continue;
                resources.add((IResource)iFolder);
                continue;
            }
            if (r.getType() != TAG_PROJECT) continue;
            path = new Path(r.getResource());
            w = ResourcesPlugin.getWorkspace();
            IProject iProject = w.getRoot().getProject(path.lastSegment());
            if (iProject == null) continue;
            resources.add((IResource)iProject);
        }
        return resources;
    }

    public String getInformationText() {
        StringBuffer buf = new StringBuffer();
        buf.append("Deploy operatoin: " + this.getName() + "\n");
        buf.append("Target destination: " + this.getTargetDestination() + "\n");
        buf.append("Resources: \n");
        List<RestoredResource> resources = this.getRestoredResources();
        for (RestoredResource r : resources) {
            buf.append("    " + r.getResource() + "\n");
        }
        return buf.toString();
    }

    class CantFindAttrException
    extends Exception {
        CantFindAttrException(String tagName, String attr) {
            super("Cannot find the attribute " + attr + " value in the tag " + tagName);
        }
    }

    class DuplicatedTagException
    extends Exception {
        DuplicatedTagException(String tagName) {
            super("Duplicated tag: " + tagName);
        }
    }

    public class RestoredResource {
        public static final String TYPE_FILE = "file";
        public static final String TYPE_FOLDER = "folder";
        public static final String TYPE_PROJECT = "project";
        private final String type;
        private final String resource;

        private RestoredResource(String type, String resource) {
            this.type = type;
            this.resource = resource;
        }

        public String getType() {
            return this.type;
        }

        public String getResource() {
            return this.resource;
        }
    }
}

