/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.FileDeployExportData;
import com.vmware.vide.deploy.FileDeployOperationsDatabase;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileDeploySelectionDialog
extends TitleAreaDialog {
    public static final String OPERATIONS_LIST_NAME = "OperationsList";
    public static final String OPERATION_INFORMATION_TEXT_NAME = "OperationInformationText";
    private List operationsList;
    private Text operationInfoText;
    private FileDeployExportData operationData;

    public FileDeploySelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle("Select File Deploy Operation");
        this.getShell().setText("Select Operation");
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(comp, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setFont(comp.getFont());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        composite.setLayoutData((Object)gd);
        Group group = this.createGroup(composite, "Operations", 1, 1, 1808);
        this.operationsList = new List((Composite)group, 2564);
        this.operationsList.setLayoutData((Object)new GridData(1808));
        this.operationsList.setFont(composite.getFont());
        this.operationsList.setData("name", (Object)OPERATIONS_LIST_NAME);
        this.operationsList.setItems(FileDeployOperationsDatabase.getOperationNames());
        this.operationsList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDeployExportData data = new FileDeployExportData();
                String op = FileDeploySelectionDialog.this.operationsList.getSelection()[0];
                try {
                    data.restore(op);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    FileDeploySelectionDialog.this.setErrorMessage("Failed to get the operation [" + op + "] from the database");
                    return;
                }
                FileDeploySelectionDialog.this.setMessage("Operation: " + op, 1);
                FileDeploySelectionDialog.this.operationInfoText.setText(data.getInformationText());
                FileDeploySelectionDialog.this.setOperationData(data);
            }
        });
        group = this.createGroup(composite, "File Deploy Information", 1, 1, 1808);
        this.operationInfoText = new Text((Composite)group, 778);
        this.operationInfoText.setFont(composite.getFont());
        this.operationInfoText.setData("name", (Object)OPERATION_INFORMATION_TEXT_NAME);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        this.operationInfoText.setLayoutData((Object)gd);
        return composite;
    }

    private Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private void setOperationData(FileDeployExportData op) {
        this.operationData = op;
    }

    public FileDeployExportData getOperationData() {
        return this.operationData;
    }
}

