/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.AutoDeployOperationData;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class WizardDeployEditCommandPage
extends WizardPage {
    public static final String PRE_COMMANDS_GROUP_NAME = "Pre-deploy commands";
    public static final String PRE_COMMANDS_TEXT_NAME = "PreCommandsText";
    public static final String POST_COMMANDS_GROUP_NAME = "Post-deploy commands";
    public static final String POST_COMMANDS_TEXT_NAME = "PostCommandsText";
    public static final String OPERATION_INFORMATION_TEXT_NAME = "OperationInformationText";
    private static final String PAGE_TITLE = "Edit pre-deploy commands and post-deploy commands";
    private static final String PAGE_DESC = "Specify pre-deploy commands (that are invoked on the remote host before the file deploy operation starts) and post-deploy commands (that are invoked on the remote host after the file deploy operation has been done).";
    private static final int MAX_INFORMATION_TEXT_LINES = 4;
    private static final int DEFAULT_EDIT_TEXT_LINES = 5;
    private static final String CLEAR_LABEL = "Clear";
    private final AutoDeployOperationData data;
    private Text preCommandsText;
    private Text postCommandsText;
    private Text operationInformationText;

    protected WizardDeployEditCommandPage(String pageName, AutoDeployOperationData data) {
        super(pageName);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESC);
        this.data = data;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setFont(parent.getFont());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        composite.setLayoutData((Object)gd);
        this.createInformationGroup(composite);
        this.preCommandsText = this.createTextEditGroup(composite, PRE_COMMANDS_GROUP_NAME, this.data.getPreCommands(), PRE_COMMANDS_TEXT_NAME);
        this.preCommandsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardDeployEditCommandPage.this.data.setPreCommands(WizardDeployEditCommandPage.this.preCommandsText.getText());
            }
        });
        this.postCommandsText = this.createTextEditGroup(composite, POST_COMMANDS_GROUP_NAME, this.data.getPostCommands(), POST_COMMANDS_TEXT_NAME);
        this.postCommandsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardDeployEditCommandPage.this.data.setPostCommands(WizardDeployEditCommandPage.this.postCommandsText.getText());
            }
        });
        this.setControl((Control)composite);
        composite.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                String infoText = WizardDeployEditCommandPage.this.data.getInformationText();
                WizardDeployEditCommandPage.this.operationInformationText.setText(infoText);
            }
        });
    }

    private void createInformationGroup(Composite parent) {
        Group group = this.createGroup(parent, "File Deploy Information", 1, 1, 1808);
        Composite comp = this.createComposite((Composite)group, 1, 1, 1808);
        GridData gd = new GridData(1808);
        String infoText = this.data.getInformationText();
        this.operationInformationText = new Text(comp, 2826);
        this.operationInformationText.setFont(comp.getFont());
        this.operationInformationText.setData("name", (Object)OPERATION_INFORMATION_TEXT_NAME);
        this.operationInformationText.setBackground(comp.getDisplay().getSystemColor(29));
        if (infoText.split("\n").length > 4) {
            gd.heightHint = this.operationInformationText.getLineHeight() * 4;
        }
        this.operationInformationText.setLayoutData((Object)gd);
        this.operationInformationText.setText(infoText);
    }

    private Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private Text createTextEditGroup(Composite parent, String groupName, String initialText, String textName) {
        Group group = this.createGroup(parent, groupName, 1, 1, 1808);
        final Text text = new Text((Composite)group, 2818);
        text.setFont(group.getFont());
        GridData gd = new GridData(1808);
        gd.heightHint = text.getLineHeight() * 5;
        text.setLayoutData((Object)gd);
        if (initialText != null) {
            text.setText(initialText);
        } else {
            text.setText("");
        }
        text.setData("name", (Object)textName);
        Button button = new Button((Composite)group, 8);
        button.setFont(group.getFont());
        button.setLayoutData((Object)new GridData(128));
        button.setText(CLEAR_LABEL);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                text.setText("");
            }
        });
        return text;
    }

    private Composite createComposite(Composite parent, int columns, int hspan, int fill) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(columns, false));
        composite.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        composite.setLayoutData((Object)gd);
        return composite;
    }
}

