/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard;

import com.vmware.vide.dashboard.Activator;
import com.vmware.vide.dashboard.ContentPanel;
import com.vmware.vide.dashboard.IInstalledPackages;
import com.vmware.vide.dashboard.PortalManager;
import com.vmware.vide.init.InitPlugin;
import com.vmware.vide.utils.symbol.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class InstalledPackagesPanel
extends ContentPanel {
    String content;
    private static final String VMWB_OPEN_URL = "vide:pkgs/";
    private String[] packageList;
    private InitPlugin initPlugin;
    private final List<String> tmPlugins = new ArrayList<String>();
    private final List<String> devKitPlugins = new ArrayList<String>();

    @Override
    public boolean init() {
        super.init();
        this.initPlugin = InitPlugin.getDefault();
        if (this.initPlugin != null) {
            this.packageList = this.initPlugin.getKitIds();
        }
        this.setInstalledPackagesChecker(new VIDEInstalledPackages());
        return true;
    }

    @Override
    public String getHeader() {
        return "Installed Packages";
    }

    @Override
    public String getHtml() {
        return this.getHomeHtml();
    }

    @Override
    public void setHtml(String content) {
        this.content = content;
    }

    @Override
    public boolean handleActionClick(String url) {
        if (url.startsWith(VMWB_OPEN_URL) && !url.equals(this.getPrefix())) {
            String location = url.substring(VMWB_OPEN_URL.length());
            PortalManager.getInstance().openVMWBPage(location);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleClick(String url) {
        if (!url.equals(this.getPrefix())) {
            return false;
        }
        this.setChanged();
        this.notifyObservers("");
        return true;
    }

    @Override
    public String getPrefix() {
        return "vide:pkgs";
    }

    @Override
    public String getHomeHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<ul class='panel'>");
        sb.append("<li class='header'>Installed Packages</li>\n");
        if (this.content == null || this.content.isEmpty()) {
            this.createContent();
        }
        if (this.content == null || this.content.isEmpty()) {
            sb.append("<li>No VMware packages are installed.</li>\n");
        } else {
            sb.append(this.content);
        }
        return sb.toString();
    }

    @Override
    public String getLinkDescription(String link) {
        return "Installed Packages";
    }

    public void createContent() {
        if (this.packageList == null || this.packageList.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder tmExtensions = new StringBuilder();
        sb.append("<ul id=\"vmwb-packages\">\n");
        ArrayList<String> rows = new ArrayList<String>();
        int index = 0;
        int tmIndex = -1;
        Arrays.sort(this.packageList, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg1.compareTo(arg0);
            }
        });
        String[] stringArray = this.packageList;
        int n = this.packageList.length;
        int n2 = 0;
        while (n2 < n) {
            String build;
            String kit = stringArray[n2];
            String name = this.initPlugin.getFirstConfigValue(kit, "common.name");
            String desc = this.initPlugin.getFirstConfigValue(kit, "common.description");
            String version = this.initPlugin.getInstalledDevkitVersion(kit);
            if ((version == null || version.isEmpty()) && ((version = this.initPlugin.getFirstConfigValue(kit, "system.version")) == null || version.isEmpty())) {
                version = this.initPlugin.getInitPluginVersionStringMMM();
            }
            if (((build = this.initPlugin.getInstalledDevkitBuildNo(kit)) == null || build.isEmpty()) && ((build = this.initPlugin.getFirstConfigValue(kit, "system.installversion")) == null || build.isEmpty())) {
                build = "00000";
            }
            if (desc.equals("@@@TM_EXTENSION@@@")) {
                tmExtensions.append("<li class=\"tm-list\">");
                tmExtensions.append(name);
                tmExtensions.append(" : ");
                tmExtensions.append(version);
                tmExtensions.append("-");
                tmExtensions.append(build);
                tmExtensions.append("</li>\n");
                this.tmPlugins.add(kit);
            } else {
                StringBuilder row = new StringBuilder();
                row.append("<li class=\"package-list\"><a href=\"");
                String type = this.initPlugin.getFirstConfigValue(kit, "common.type");
                String ID = this.initPlugin.getFirstConfigValue(kit, "common.id");
                if (type.equals("tm") || ID.equals("tm")) {
                    tmIndex = index;
                } else {
                    this.devKitPlugins.add(kit);
                }
                ++index;
                String welcome = InstalledPackagesPanel.getWelcomeURL(this.initPlugin, kit);
                if (welcome.isEmpty()) {
                    StringBuffer buffer = new StringBuffer(VMWB_OPEN_URL);
                    buffer.append("file://");
                    welcome = this.initPlugin.getRootInstallPath(kit);
                    buffer.append(welcome);
                    buffer.append("/vide/welcome.html");
                    row.append(buffer.toString());
                } else if (welcome.startsWith("file://")) {
                    welcome = welcome.replace("@@@PLUGIN_ROOT@@@", this.initPlugin.getRootInstallPath(kit));
                    welcome = welcome.replace("@@@RESOURCE@@@", Activator.getDefault().getBundle().getLocation());
                    row.append(VMWB_OPEN_URL + welcome);
                } else {
                    row.append(welcome);
                }
                row.append("\">");
                row.append(name);
                row.append(" : ");
                row.append(version);
                row.append("-");
                row.append(build);
                row.append("</a></li>\n");
                rows.add(row.toString());
            }
            ++n2;
        }
        if (tmIndex != -1) {
            StringBuilder tmRow = new StringBuilder((String)rows.get(tmIndex));
            tmRow.append("<ul>\n");
            tmRow.append(tmExtensions.toString());
            tmRow.append("</ul>\n");
            rows.set(tmIndex, tmRow.toString());
        }
        int i = 0;
        while (i < rows.size()) {
            sb.append((String)rows.get(i));
            ++i;
        }
        this.content = sb.toString();
    }

    public static String getWelcomeURL(InitPlugin ip, String kitId) {
        String url = ip.getFirstConfigValue(kitId, "system.welcomeURL");
        if (url == null) {
            return "";
        }
        Map options = ip.getSystemOptions(kitId);
        return Variable.replaceVariables((String)url, (Map)options);
    }

    public class VIDEInstalledPackages
    implements IInstalledPackages {
        @Override
        public List<String> getInstalledCerts() {
            return InstalledPackagesPanel.this.tmPlugins;
        }

        @Override
        public List<String> getInstalledDevkits() {
            return InstalledPackagesPanel.this.devKitPlugins;
        }
    }
}

