/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard;

import com.vmware.vide.dashboard.Activator;
import com.vmware.vide.dashboard.ContentProvider;
import com.vmware.vide.dashboard.PortalEditor;
import com.vmware.vide.dashboard.PortalEditorInput;
import com.vmware.vide.dashboard.VMWBPageEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PortalManager {
    private static String PORTAL_EDITOR_ID = "com.vmware.vide.dashboard.editor";
    private static String VMWB_PAGE_EDITOR_ID = "com.vmware.vide.dashboard.vmwbpageeditor";
    private static PortalManager INSTANCE = null;
    private PortalEditor portalEditor;
    ContentProvider contentProvider;
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private static final String BASE_ID = "com.vmware.vide.dashboard.dashboard.";
    private static final String ENABLED_ID = "com.vmware.vide.dashboard.dashboard.enabled";
    private static final String DISABLE_UPDATE_SITES_ID = "com.vmware.vide.dashboard.dashboard.disableUpdateSites";

    public PortalManager() {
        this.store.setDefault(ENABLED_ID, true);
        this.store.setDefault(DISABLE_UPDATE_SITES_ID, true);
    }

    public static PortalManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PortalManager();
        }
        return INSTANCE;
    }

    public boolean shouldOpen() {
        return PortalManager.getEnabledOnStartup();
    }

    public PortalEditor open() {
        try {
            IEditorReference[] editors;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference er = iEditorReferenceArray[n2];
                if (er.getEditor(false) instanceof PortalEditor) {
                    this.portalEditor = (PortalEditor)er.getEditor(false);
                    page.openEditor(this.portalEditor.getEditorInput(), PORTAL_EDITOR_ID);
                    return this.portalEditor;
                }
                ++n2;
            }
            this.contentProvider = new ContentProvider();
            PortalEditorInput input = new PortalEditorInput();
            this.portalEditor = (PortalEditor)page.openEditor((IEditorInput)input, PORTAL_EDITOR_ID);
            this.portalEditor.setContentProvider(this.contentProvider);
            this.contentProvider.update();
            return this.portalEditor;
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean getEnabledOnStartup() {
        return PortalManager.getInstance().store.getBoolean(ENABLED_ID);
    }

    public static void setEnabledOnStartup(boolean value) {
        PortalManager.getInstance().store.setValue(ENABLED_ID, value);
    }

    public static void setNeedDisableRepositories(boolean value) {
        PortalManager.getInstance().store.setValue(DISABLE_UPDATE_SITES_ID, value);
    }

    public static boolean needDisableRepositories() {
        return PortalManager.getInstance().store.getBoolean(DISABLE_UPDATE_SITES_ID);
    }

    public void openVMWBPage(String path) {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IEditorPart editor = page.getActiveEditor();
            PortalEditorInput input = new PortalEditorInput();
            VMWBPageEditor vmwbEditor = (VMWBPageEditor)page.openEditor((IEditorInput)input, VMWB_PAGE_EDITOR_ID);
            vmwbEditor.setOldEditor(editor);
            vmwbEditor.show(path);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }
}

