/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard;

import com.vmware.vide.dashboard.ContentPanel;
import com.vmware.vide.rse.util.RSSContentProvider;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

public class RSSPanel
extends ContentPanel
implements Observer {
    private RSSContentProvider rssProvider = new RSSContentProvider();

    @Override
    public boolean init() {
        this.rssProvider.init((Observer)this);
        return super.init();
    }

    @Override
    public String getHeader() {
        return "News";
    }

    @Override
    public String getPrefix() {
        return "vide:rss/";
    }

    @Override
    public String getHomeHtml() {
        String news = "";
        try {
            StringWriter pw = new StringWriter();
            ((Writer)pw).write("<ul class='panel'>");
            ((Writer)pw).write("<li class='header'>News</li>\n");
            this.rssProvider.createContent(this.getPrefix(), (Writer)pw);
            news = ((Object)pw).toString();
        }
        catch (IOException e) {
            news = e.getMessage();
            news = String.valueOf(news) + "<br>\n";
            news = String.valueOf(news) + e.getStackTrace();
        }
        return news;
    }

    @Override
    public String getHtml() {
        return this.getHomeHtml();
    }

    @Override
    public String getLinkDescription(String link) {
        return "News";
    }

    @Override
    public boolean handleClick(String location) {
        if (location.equals(this.getPrefix())) {
            this.setChanged();
            this.notifyObservers("");
            return true;
        }
        if (!location.startsWith(this.getPrefix())) {
            return false;
        }
        String url = location.substring(this.getPrefix().length());
        int style = 42;
        try {
            IWebBrowser browser = WorkbenchBrowserSupport.getInstance().createBrowser(style, "MyBrowserID", "MyBrowserName", "MyBrowser Tooltip");
            browser.openURL(new URL(url));
            return true;
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.setChanged();
        this.notifyObservers(null);
    }
}

