/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.core.cimbrowser;

import com.vmware.vide.cimtools.core.cimclient.EnumCIMClasses;
import com.vmware.vide.cimtools.core.cimcore.CIMClassData;
import com.vmware.vide.cimtools.core.cimcore.CIMHost;
import com.vmware.vide.cimtools.core.cimcore.CIMPropertyData;
import com.vmware.vide.cimtools.ui.cimbrowser.BrowserView;
import com.vmware.vide.cimtools.ui.cimbrowser.WBEMOperationView;
import com.vmware.vide.cimtools.utils.CIMToolsException;
import com.vmware.vide.cimtools.utils.UtilDialog;
import com.vmware.vide.target.api.ITarget;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class CIMBrowserEngine {
    private static CIMBrowserEngine cimbrowserengine = new CIMBrowserEngine();
    private final Hashtable<String, CIMHost> cimhosts = new Hashtable();
    private final ArrayList<CIMHost> inheritancehosts = new ArrayList();
    private final ArrayList<CIMHost> schemahosts = new ArrayList();
    private final ArrayList<CIMHost> instancehosts = new ArrayList();

    public static CIMBrowserEngine getDefault() {
        return cimbrowserengine;
    }

    public void addClassesInView(String viewid, CIMClassData[] classes) throws CIMToolsException {
        if (viewid == null) {
            return;
        }
        LinkedHashMap<CIMHost, ArrayList<CIMClassData>> hosts = this.collectClassesPerCIMHost(classes);
        for (CIMHost host : hosts.keySet()) {
            ArrayList<CIMClassData> hostclasses = hosts.get(host);
            this.addAllInView(viewid, host, false, hostclasses.toArray(new CIMClassData[hostclasses.size()]));
        }
    }

    public synchronized void addClassesInView(final String viewid, CIMHost host, final boolean addallclasses, final String[] classnames) throws CIMToolsException {
        if (host == null || viewid == null) {
            return;
        }
        CIMHost cimhost = this.findCIMHost(host);
        if (cimhost != null) {
            this.updateCIMClasses(viewid, cimhost, addallclasses, classnames);
            return;
        }
        cimhost = host;
        EnumCIMClasses job = new EnumCIMClasses(cimhost, null, true);
        this.cimhosts.put(host.getCIMHostName(), cimhost);
        cimhost.setCurrentEnumCIMClassesJob(job);
        job.schedule();
        if (job.getState() != 0) {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    try {
                        if (event.getJob() instanceof EnumCIMClasses) {
                            EnumCIMClasses resultjob = (EnumCIMClasses)event.getJob();
                            if (event.getResult().isOK()) {
                                CIMHost cimhost = resultjob.getCIMHost();
                                CIMBrowserEngine.this.updateCIMClasses(viewid, cimhost, addallclasses, classnames);
                                return;
                            }
                            if (resultjob.getException() != null) {
                                UtilDialog.openDialog(resultjob.getException());
                            }
                            CIMBrowserEngine.this.cleanUpUninitializedCIMHost(resultjob.getCIMHost());
                        }
                    }
                    catch (CIMToolsException e) {
                        UtilDialog.openDialog(e);
                    }
                }
            });
        } else {
            this.updateCIMClasses(viewid, cimhost, addallclasses, classnames);
        }
    }

    public void updateCIMClasses(String viewid, CIMHost host, boolean addallclasses, String[] classnames) throws CIMToolsException {
        if (CIMBrowserEngine.isWBEMOperationView(viewid)) {
            try {
                WBEMOperationView.refreshView(false);
            }
            catch (Exception e) {
                throw CIMToolsException.createCommonException(e.getMessage(), e);
            }
            return;
        }
        ArrayList classes = new ArrayList();
        classes = classnames != null && classnames.length > 0 ? host.find(classnames) : new ArrayList();
        this.addAllInView(viewid, host, addallclasses, classes.toArray(new CIMClassData[classes.size()]));
        if (classnames.length > classes.size()) {
            StringBuffer failclasses = new StringBuffer();
            String[] stringArray = classnames;
            int n = classnames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                boolean added = false;
                for (CIMClassData addedclass : classes) {
                    if (!addedclass.getCIMClassName().equalsIgnoreCase(name)) continue;
                    added = true;
                    break;
                }
                if (!added) {
                    failclasses.append(failclasses.toString().isEmpty() ? name : ", " + name);
                }
                ++n2;
            }
            throw CIMToolsException.createCommonException("Unable to access CIM class(es) " + failclasses, null);
        }
    }

    public void removeHost(String viewid, CIMHost host) {
        ArrayList<CIMHost> hosts = this.getViewHosts(viewid);
        if (hosts.contains(host)) {
            host.removeAllClasses(viewid);
            hosts.remove(host);
        }
        if (!(this.inheritancehosts.contains(host) || this.schemahosts.contains(host) || this.instancehosts.contains(host))) {
            this.cimhosts.remove(host);
        }
    }

    private ArrayList<CIMHost> getViewHosts(String viewid) {
        if (CIMBrowserEngine.isInheritanceView(viewid)) {
            return this.inheritancehosts;
        }
        if (CIMBrowserEngine.isSchemaView(viewid)) {
            return this.schemahosts;
        }
        if (CIMBrowserEngine.isInstanceView(viewid)) {
            return this.instancehosts;
        }
        return new ArrayList<CIMHost>();
    }

    private void addAllInView(String viewid, CIMHost host, boolean addallclasses, CIMClassData[] classes) throws CIMToolsException {
        if (viewid == null || host == null) {
            return;
        }
        ArrayList<CIMHost> viewhosts = this.getViewHosts(viewid);
        if (viewhosts != null) {
            if (!viewhosts.contains(host)) {
                viewhosts.add(host);
            }
            if (CIMBrowserEngine.isInheritanceView(viewid) && addallclasses) {
                host.addAllClassesToInheritance();
            } else if (classes.length > 0) {
                host.addViewClasses(viewid, classes);
            }
            try {
                BrowserView.refreshView(viewid, true, addallclasses ? null : classes);
            }
            catch (Exception e) {
                throw CIMToolsException.createCommonException(e.getMessage(), e);
            }
        }
    }

    private LinkedHashMap<CIMHost, ArrayList<CIMClassData>> collectClassesPerCIMHost(CIMClassData[] classes) throws CIMToolsException {
        LinkedHashMap<CIMHost, ArrayList<CIMClassData>> hosts = new LinkedHashMap<CIMHost, ArrayList<CIMClassData>>();
        CIMClassData[] cIMClassDataArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            CIMClassData cimclass = cIMClassDataArray[n2];
            CIMHost host = cimclass.getCIMHost();
            if (host != null) {
                if (hosts.containsKey(host)) {
                    hosts.get(host).add(cimclass);
                } else {
                    ArrayList<CIMClassData> cimclasses = new ArrayList<CIMClassData>();
                    cimclasses.add(cimclass);
                    hosts.put(host, cimclasses);
                }
            }
            ++n2;
        }
        return hosts;
    }

    public CIMHost findCIMHost(CIMHost host) {
        if (this.cimhosts.contains(host) && this.cimhosts.get(host.getCIMHostName()).isInitialized()) {
            return host;
        }
        for (CIMHost cimhost : this.cimhosts.values()) {
            if (!cimhost.getCIMHostName().equals(host.getCIMHostName()) || !cimhost.isInitialized()) continue;
            return cimhost;
        }
        return null;
    }

    public CIMHost findCIMHost(ITarget target, String namespace) {
        for (CIMHost host : this.cimhosts.values()) {
            if (!host.getTarget().getHostName().equals(target.getHostName()) || !host.getNamespace().equals(namespace) || !host.isInitialized()) continue;
            return host;
        }
        return null;
    }

    public CIMHost findCIMHost(String cimhostname) {
        if (this.cimhosts.containsKey(cimhostname)) {
            return this.cimhosts.get(cimhostname);
        }
        return null;
    }

    public void cleanUpUninitializedCIMHost(CIMHost host) {
        if (!host.isInitialized() && this.cimhosts.containsValue(host)) {
            this.cimhosts.remove(host.getCIMHostName());
        }
    }

    public String[] getAllCIMHostnames() {
        return this.cimhosts.keySet().toArray(new String[this.cimhosts.size()]);
    }

    public synchronized void findClassForReferenceProperty(final CIMPropertyData propertydata, CIMHost host, String namespace, final String refclassname) {
        if (propertydata == null || refclassname == null) {
            return;
        }
        CIMHost refhost = this.findCIMHost(host.getTarget(), namespace);
        if (refhost != null && refhost.isInitialized()) {
            CIMClassData refclass = refhost.find(refclassname);
            if (refclass != null && refclass.isValid()) {
                propertydata.appendReference(refclass);
                try {
                    BrowserView.refreshView("com.vmware.vide.cimtools.instanceview", false, null);
                }
                catch (Exception exception) {}
            }
            return;
        }
        EnumCIMClasses job = null;
        if (refhost != null && refhost.getCurrentEnumCIMClassesJob() != null) {
            job = refhost.getCurrentEnumCIMClassesJob();
        } else {
            refhost = new CIMHost(host, namespace);
            job = new EnumCIMClasses(refhost, null, true);
            refhost.setCurrentEnumCIMClassesJob(job);
            this.cimhosts.put(refhost.getCIMHostName(), refhost);
            job.schedule();
        }
        if (job.getState() != 0) {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    try {
                        if (event.getJob() instanceof EnumCIMClasses) {
                            EnumCIMClasses resultjob = (EnumCIMClasses)event.getJob();
                            if (event.getResult().isOK()) {
                                CIMHost resulthost = resultjob.getCIMHost();
                                CIMClassData refclass = resulthost.find(refclassname);
                                if (refclass != null && refclass.isValid()) {
                                    propertydata.appendReference(refclass);
                                    BrowserView.refreshView("com.vmware.vide.cimtools.instanceview", false, null);
                                } else {
                                    System.err.println("[ERROR] failed to find a referenced class " + refclassname);
                                }
                                return;
                            }
                            if (resultjob.getException() != null) {
                                UtilDialog.openDialog(resultjob.getException());
                            }
                            CIMBrowserEngine.this.cleanUpUninitializedCIMHost(resultjob.getCIMHost());
                        }
                    }
                    catch (CIMToolsException e) {
                        UtilDialog.openDialog(e);
                    }
                    catch (Exception e) {
                        UtilDialog.openDialog(CIMToolsException.createCommonException(e.getMessage(), e));
                    }
                }
            });
        } else {
            CIMClassData refclass = refhost.find(refclassname);
            if (refclass != null && refclass.isValid()) {
                try {
                    propertydata.appendReference(refclass);
                    BrowserView.refreshView("com.vmware.vide.cimtools.instanceview", false, null);
                }
                catch (Exception e) {
                    UtilDialog.openDialog(CIMToolsException.createCommonException(e.getMessage(), e));
                }
            }
        }
    }

    public static boolean isInheritanceView(String viewid) {
        return "com.vmware.vide.cimtools.inheritanceview".equals(viewid);
    }

    public static boolean isSchemaView(String viewid) {
        return "com.vmware.vide.cimtools.schemaview".equals(viewid);
    }

    public static boolean isInstanceView(String viewid) {
        return "com.vmware.vide.cimtools.instanceview".equals(viewid);
    }

    public static boolean isWBEMOperationView(String viewid) {
        return "com.vmware.vide.cimtools.wbemoperationview".equals(viewid);
    }

    public static boolean isHostExist(String hostname) {
        return CIMBrowserEngine.getDefault().cimhosts.containsKey(hostname);
    }

    public static void addCIMClassesInView(String viewid, CIMHost host, boolean allclass, String[] classnames) throws CIMToolsException {
        CIMBrowserEngine.getDefault().addClassesInView(viewid, host, allclass, classnames);
    }

    public static void addCIMClassesInSchemaView(CIMClassData[] classes) throws CIMToolsException {
        CIMBrowserEngine.getDefault().addClassesInView("com.vmware.vide.cimtools.schemaview", classes);
    }

    public static void addCIMClassesInInstanceView(CIMClassData[] classes) throws CIMToolsException {
        CIMBrowserEngine.getDefault().addClassesInView("com.vmware.vide.cimtools.instanceview", classes);
    }

    public static CIMHost[] getAllHostsInView(String viewid) {
        ArrayList<CIMHost> hosts = CIMBrowserEngine.getDefault().getViewHosts(viewid);
        return hosts.toArray(new CIMHost[hosts.size()]);
    }

    public static void removeHostInView(String viewid, CIMHost host) {
        CIMBrowserEngine.getDefault().removeHost(viewid, host);
    }
}

