/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.core.cimclient;

import com.vmware.vide.cimtools.core.cimcore.CIMHost;
import com.vmware.vide.cimtools.utils.CIMToolsException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.security.auth.Subject;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.client.WBEMClient;
import javax.wbem.client.WBEMClientFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.sblim.cimclient.internal.wbem.WBEMClientCIMXML;

public abstract class CIMClientAccess
extends Job {
    private static final String ERROR_CIMHOST_UNAVAILABLE = " Unable to access CIM Host ";
    private static final String ERROR_CIMCLASS_UNAVAILABLE = " Unable to access CIM Class ";
    private static final String ERROR_ENUM_CIMCLASS = " Failed to enumerate CIM classes ";
    private static final String ERROR_ENUM_CIMCLASSNAME = " Failed to enumerate CIM class names ";
    private static final String ERROR_ENUM_CIMINSTANCE = " Failed to enumerate CIM instances ";
    private static final String ERROR_ENUM_CIMINSTANCENAME = " Failed to enumerate CIM instance namnes ";
    private static final String ERROR_GET_CIMCLASS = " Failed to get CIM class ";
    private static final String ERROR_GET_CIMASSOCIATOR = " Failed to get CIM associators ";
    private static final String ERROR_GET_CIMREFERENCE = " Failed to get CIM references ";
    protected static final String TASK_WBEM_OPERATION = "WBEM operation";
    private static final int DEFAULT_TIMEOUT = 60000;
    boolean dataprocessed = false;
    protected CIMToolsException exception;
    private final int timeout;
    private static ISchedulingRule mutexrule = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };

    protected abstract IStatus run(IProgressMonitor var1);

    public CIMClientAccess(String name) {
        super(name);
        this.timeout = 60000;
        this.setRule(mutexrule);
    }

    public CIMToolsException getException() {
        return this.exception;
    }

    protected WBEMClient getWBEMClient(CIMHost host) throws CIMToolsException {
        return this.getWBEMClient(host.getHostURL(), host.getUsername(), host.getPassword(true), host.getSslProtocol());
    }

    protected WBEMClient getWBEMClient(URL url, String user, String password, String sslProtocol) throws CIMToolsException {
        if (url == null || user == null) {
            throw CIMToolsException.createCIMClientAccessException(ERROR_CIMHOST_UNAVAILABLE, null);
        }
        WBEMClient client = WBEMClientFactory.getClient((String)"CIM-XML");
        try {
            CIMObjectPath path = new CIMObjectPath(url.getProtocol(), url.getHost(), String.valueOf(url.getPort()), null, null, null);
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new UserPrincipal(user));
            subject.getPrivateCredentials().add(new PasswordCredential(password));
            client.initialize(path, subject, Locale.getAvailableLocales());
            client.setProperty("sblim.wbem.httpTimeout", String.valueOf(this.timeout));
            WBEMClientCIMXML clientCimXml = (WBEMClientCIMXML)client;
            clientCimXml.setLocalProperty("ssl.Protocol", sslProtocol);
        }
        catch (Exception e) {
            throw CIMToolsException.createCIMClientAccessException(ERROR_CIMHOST_UNAVAILABLE + url.toString() + " " + user + " (" + e.getMessage() + ")", e);
        }
        return client;
    }

    protected List<CIMObjectPath> getEnumClassNames(CIMHost host, CIMObjectPath path, boolean deep, IProgressMonitor monitor) throws CIMToolsException {
        ArrayList<CIMObjectPath> cimclasses = new ArrayList<CIMObjectPath>();
        if (host == null) {
            throw CIMToolsException.createCIMClientAccessException(ERROR_CIMHOST_UNAVAILABLE, null);
        }
        if (monitor.isCanceled()) {
            return cimclasses;
        }
        WBEMClient client = this.getWBEMClient(host);
        try (CloseableIterator iterator = client.enumerateClassNames(path, deep);){
            if (!monitor.isCanceled()) {
                while (iterator.hasNext()) {
                    cimclasses.add((CIMObjectPath)iterator.next());
                }
            }
        }
        catch (WBEMException e) {
            throw CIMToolsException.createCIMClientAccessException(" Failed to enumerate CIM class names from " + host.getCIMHostName() + "\n" + e.getMessage(), (Exception)((Object)e));
        }
        return cimclasses;
    }

    protected ArrayList<CIMClass> getEnumClasses(CIMHost host, CIMObjectPath objectpath, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, IProgressMonitor monitor) throws CIMToolsException {
        ArrayList<Object> cimclasses;
        block8: {
            if (host == null) {
                throw CIMToolsException.createCIMClientAccessException(ERROR_CIMHOST_UNAVAILABLE, null);
            }
            cimclasses = new ArrayList<CIMClass>();
            monitor.subTask("[WBEM Operation] Connect Client " + host.getText());
            WBEMClient client = this.getWBEMClient(host);
            if (monitor.isCanceled()) {
                return cimclasses;
            }
            try {
                monitor.subTask("[WBEM Operation] enumerateClasses");
                try (CloseableIterator iterator = client.enumerateClasses(objectpath, deep, localOnly, includeQualifiers, includeClassOrigin);){
                    if (monitor.isCanceled()) break block8;
                    while (iterator.hasNext()) {
                        cimclasses.add((CIMClass)iterator.next());
                        if (!monitor.isCanceled()) continue;
                        cimclasses = new ArrayList();
                        break;
                    }
                }
            }
            catch (WBEMException e) {
                throw CIMToolsException.createCIMClientAccessException(" Failed to enumerate CIM classes from " + host.getCIMHostName() + "\n" + e.getMessage(), (Exception)((Object)e));
            }
        }
        return cimclasses;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<CIMObjectPath> getEnumInstanceNames(CIMHost host, CIMObjectPath classpath, IProgressMonitor monitor) throws CIMToolsException {
        if (host == null || classpath == null) {
            String string;
            if (host == null) {
                string = ERROR_CIMHOST_UNAVAILABLE;
                throw CIMToolsException.createCIMClientAccessException(string, null);
            }
            string = ERROR_CIMCLASS_UNAVAILABLE;
            throw CIMToolsException.createCIMClientAccessException(string, null);
        }
        ArrayList<CIMObjectPath> instances = new ArrayList<CIMObjectPath>();
        WBEMClient client = this.getWBEMClient(host);
        if (monitor.isCanceled()) {
            return instances;
        }
        try (CloseableIterator iterator = client.enumerateInstanceNames(classpath);){
            if (monitor.isCanceled()) return instances;
            do {
                if (!iterator.hasNext()) {
                    return instances;
                }
                instances.add((CIMObjectPath)iterator.next());
            } while (!monitor.isCanceled());
            ArrayList<CIMObjectPath> arrayList = instances;
            return arrayList;
        }
        catch (WBEMException e) {
            throw CIMToolsException.createCIMClientAccessException(" Failed to enumerate CIM instance namnes for " + classpath.toString() + "\n" + e.getMessage(), (Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ArrayList<CIMInstance> getEnumInstances(CIMHost host, CIMObjectPath classpath, boolean deep, boolean localOnly, boolean includeClassOrigin, String[] propertyList, IProgressMonitor monitor) throws CIMToolsException {
        if (host == null || classpath == null) {
            String string;
            if (host == null) {
                string = ERROR_CIMHOST_UNAVAILABLE;
                throw CIMToolsException.createCIMClientAccessException(string, null);
            }
            string = ERROR_CIMCLASS_UNAVAILABLE;
            throw CIMToolsException.createCIMClientAccessException(string, null);
        }
        ArrayList<CIMInstance> instances = new ArrayList<CIMInstance>();
        WBEMClient client = this.getWBEMClient(host);
        if (monitor.isCanceled()) {
            return instances;
        }
        try (CloseableIterator iterator = client.enumerateInstances(classpath, deep, localOnly, includeClassOrigin, propertyList);){
            if (monitor.isCanceled()) return instances;
            do {
                if (!iterator.hasNext()) {
                    return instances;
                }
                instances.add((CIMInstance)iterator.next());
            } while (!monitor.isCanceled());
            ArrayList<CIMInstance> arrayList = instances;
            return arrayList;
        }
        catch (WBEMException e) {
            throw CIMToolsException.createCIMClientAccessException(" Failed to enumerate CIM instances for " + classpath.toString() + "\n" + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected CIMClass getCIMClass(CIMHost host, CIMObjectPath classpath, boolean deep, boolean includeQualifiers, boolean includeClassOrigin, IProgressMonitor monitor) throws CIMToolsException {
        WBEMClient client;
        block5: {
            if (host == null || classpath == null) {
                throw CIMToolsException.createCIMClientAccessException(host == null ? ERROR_CIMHOST_UNAVAILABLE : ERROR_CIMCLASS_UNAVAILABLE, null);
            }
            if (monitor.isCanceled()) {
                return null;
            }
            client = this.getWBEMClient(host);
            try {
                if (!monitor.isCanceled()) break block5;
                return null;
            }
            catch (WBEMException e) {
                throw CIMToolsException.createCIMClientAccessException(" Failed to get CIM class for " + classpath.toString() + "\n" + e.getMessage(), (Exception)((Object)e));
            }
        }
        return client.getClass(classpath, deep, includeQualifiers, includeClassOrigin, null);
    }

    protected ArrayList<CIMInstance> getAssociators(CIMHost host, CIMObjectPath objectpath, String assocname, String resultname) throws CIMToolsException {
        ArrayList<CIMInstance> assocclasses = new ArrayList<CIMInstance>();
        WBEMClient client = this.getWBEMClient(host);
        try (CloseableIterator iterator = client.associators(objectpath, assocname, resultname, null, null, true, true, null);){
            while (iterator.hasNext()) {
                assocclasses.add((CIMInstance)iterator.next());
            }
        }
        catch (WBEMException e) {
            throw CIMToolsException.createCIMClientAccessException(" Failed to get CIM associators for " + objectpath.toString() + "\n" + e.getMessage(), (Exception)((Object)e));
        }
        return assocclasses;
    }

    protected ArrayList<CIMInstance> getReferences(CIMHost host, CIMObjectPath objectpath, String resultclass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, IProgressMonitor monitor) throws CIMToolsException {
        ArrayList<Object> references;
        block7: {
            references = new ArrayList<CIMInstance>();
            WBEMClient client = this.getWBEMClient(host);
            if (monitor.isCanceled()) {
                return references;
            }
            try (CloseableIterator iterator = client.references(objectpath, resultclass, null, false, false, null);){
                if (monitor.isCanceled()) break block7;
                while (iterator.hasNext()) {
                    references.add((CIMInstance)iterator.next());
                    if (!monitor.isCanceled()) continue;
                    references = new ArrayList();
                    break;
                }
            }
            catch (WBEMException e) {
                throw CIMToolsException.createCIMClientAccessException(" Failed to get CIM references for " + objectpath.toString() + "\n" + e.getMessage(), (Exception)((Object)e));
            }
        }
        return references;
    }
}

