/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.core.cimclient;

import com.vmware.vide.cimtools.core.cimclient.CIMClientAccess;
import com.vmware.vide.cimtools.core.cimcore.CIMClassData;
import com.vmware.vide.cimtools.core.cimcore.CIMHost;
import com.vmware.vide.cimtools.core.cimcore.CIMTreeData;
import com.vmware.vide.cimtools.utils.CIMToolsException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.cim.CIMClass;
import javax.cim.CIMObjectPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class EnumCIMClasses
extends CIMClientAccess {
    private static final String JOB_TITLE = "[WBEM] Enumerate CIM Classes ";
    private static final String TASK_WBEM_OPERATION = "WBEM operation";
    private CIMHost cimhost;
    private CIMObjectPath cimobjpath;
    private boolean deep;
    private boolean localOnly;
    private boolean includeQualifiers;
    private boolean includeClassOrigin;
    private boolean initializebase;
    private List<CIMClass> resultclasses;

    public EnumCIMClasses(CIMHost host, CIMObjectPath objpath, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, boolean initializebase) {
        super("[WBEM] Enumerate CIM Classes  for " + (objpath != null ? objpath.toString() : host.getText()));
        this.deep = deep;
        this.localOnly = localOnly;
        this.includeQualifiers = includeQualifiers;
        this.includeClassOrigin = includeClassOrigin;
        this.cimhost = host;
        this.cimobjpath = objpath;
        this.initializebase = objpath.getObjectName() == null && initializebase;
        this.resultclasses = new ArrayList<CIMClass>();
    }

    public EnumCIMClasses(CIMHost host, String name, boolean initializebase) {
        this(host, new CIMObjectPath(name, host.getNamespace()), true, false, true, false, initializebase);
    }

    public CIMHost getCIMHost() {
        return this.cimhost;
    }

    public List<CIMClass> getWBEMResult() {
        return this.resultclasses;
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(TASK_WBEM_OPERATION, 100);
            this.resultclasses = this.getEnumClasses(this.cimhost, this.cimobjpath, this.deep, this.localOnly, this.includeQualifiers, this.includeClassOrigin, monitor);
            monitor.worked(50);
            if (this.initializebase) {
                this.cimhost.initializeBase(this.convertToCIMClassData(this.cimhost, null, this.resultclasses));
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (CIMToolsException e) {
            this.exception = e;
        }
        finally {
            monitor.done();
        }
        return Status.CANCEL_STATUS;
    }

    private LinkedHashMap<String, CIMClassData> convertToCIMClassData(CIMHost host, CIMClassData rootclass, List<CIMClass> allclasses) {
        LinkedHashMap<String, CIMClassData> classes = new LinkedHashMap<String, CIMClassData>();
        while (allclasses.size() > 0) {
            int remove_cnt = 0;
            Iterator<CIMClass> it = allclasses.iterator();
            while (it.hasNext()) {
                CIMClass cimclass = it.next();
                String superclass = cimclass.getSuperClassName();
                if (superclass == null || rootclass != null && superclass.equals(rootclass.getClassName())) {
                    CIMTreeData parent = superclass == null ? host : rootclass;
                    CIMClassData data = CIMClassData.createCIMClassData(parent, cimclass);
                    if (!data.isValid()) continue;
                    classes.put(data.getClassName(), data);
                    it.remove();
                    ++remove_cnt;
                    continue;
                }
                for (CIMClassData data : classes.values()) {
                    if (!data.isSuperClassOf(cimclass, true)) continue;
                    it.remove();
                    ++remove_cnt;
                }
            }
            if (remove_cnt == 0) break;
        }
        if (allclasses.size() > 0) {
            Iterator<CIMClass> it = allclasses.iterator();
            while (it.hasNext()) {
                CIMClassData data = CIMClassData.createCIMClassData(host, it.next());
                if (!data.isValid()) continue;
                classes.put(data.getClassName(), data);
            }
        }
        return classes;
    }
}

