/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.core.cimcore;

import com.vmware.vide.cimtools.core.cimclient.EnumCIMInstances;
import com.vmware.vide.cimtools.core.cimcore.CIMClassData;
import com.vmware.vide.cimtools.core.cimcore.CIMInstanceData;
import com.vmware.vide.cimtools.core.cimcore.CIMTreeData;
import com.vmware.vide.cimtools.ui.cimbrowser.BrowserView;
import com.vmware.vide.cimtools.utils.CIMToolsException;
import com.vmware.vide.cimtools.utils.UtilDialog;
import java.util.ArrayList;
import javax.cim.CIMInstance;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class CIMInstanceGroup
extends CIMTreeData {
    private CIMClassData cimclass;
    private ArrayList<CIMInstanceData> instances;

    public CIMInstanceGroup(CIMClassData parent) {
        super(parent, CIMInstanceGroup.getGroupTitle(0));
        this.cimclass = parent;
        this.instances = null;
        this.image = CIMInstanceGroup.getImage(this.cimclass.isAssociation() ? "assoc-instance.png" : "class-instance.png");
    }

    @Override
    public boolean isValid() {
        return this.cimclass != null;
    }

    @Override
    public Object[] getChildren(String viewid, int viewtype) {
        if (this.instances == null) {
            this.instances = new ArrayList();
            final String currentviewid = viewid;
            final EnumCIMInstances job = new EnumCIMInstances(this.cimclass.getCIMHost(), this.cimclass.getObjectPath());
            job.schedule();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    try {
                        if (event.getResult().isOK()) {
                            ArrayList<CIMInstance> insts = job.getWBEMResult();
                            for (CIMInstance inst : insts) {
                                CIMInstanceData instdata = new CIMInstanceData(CIMInstanceGroup.this.parent, CIMInstanceGroup.this.cimclass, inst);
                                if (!instdata.isValid()) continue;
                                CIMInstanceGroup.this.instances.add(instdata);
                            }
                            BrowserView.refreshView(currentviewid, false, null);
                            return;
                        }
                        if (job.getException() != null) {
                            UtilDialog.openDialog(job.getException());
                        }
                    }
                    catch (CIMToolsException e) {
                        UtilDialog.openDialog(e);
                    }
                    catch (Exception e) {
                        UtilDialog.openDialog(CIMToolsException.createCommonException(e.getMessage(), e));
                    }
                    CIMInstanceGroup.this.instances = null;
                }
            });
            return new Object[0];
        }
        return this.instances.toArray();
    }
}

