/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.ui.cimbrowser;

import com.vmware.vide.cimtools.CIMToolsPlugin;
import com.vmware.vide.cimtools.core.cimbrowser.CIMBrowserEngine;
import com.vmware.vide.cimtools.core.cimcore.CIMClassData;
import com.vmware.vide.cimtools.core.cimcore.CIMHost;
import com.vmware.vide.cimtools.core.cimcore.CIMInstanceData;
import com.vmware.vide.cimtools.core.cimcore.CIMTreeData;
import com.vmware.vide.cimtools.ui.cimbrowser.CIMBrowserWizard;
import com.vmware.vide.cimtools.ui.cimbrowser.SearchClassWizard;
import com.vmware.vide.cimtools.utils.CIMToolsException;
import com.vmware.vide.cimtools.utils.UtilDialog;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class BrowserView
extends ViewPart {
    public static final String VIEWID_INHERITANCE = "com.vmware.vide.cimtools.inheritanceview";
    public static final String VIEWID_SCHEMA = "com.vmware.vide.cimtools.schemaview";
    public static final String VIEWID_INSTANCE = "com.vmware.vide.cimtools.instanceview";
    public static final int TREETYPE_MAINTREE = 1;
    public static final int TREETYPE_SUBTREE = 2;
    private static final String DLG_FINDCIMCLASS_NOHOST = "No CIM host found: unable to search CIM Class";
    private static final String DLG_FINDCIMCLASS_NOCLASS = "Fail to find the CIM Class";
    protected static final int MENUIDX_ADDHOST = 0;
    protected static final int MENUIDX_REMOVEHOST = 1;
    protected static final int MENUIDX_ADDCIMCLASS = 2;
    protected static final int MENUIDX_GETCIMINSTANCE = 3;
    protected static final int MENUIDX_SCHEMAVIEW = 4;
    protected static final int MENUIDX_INSTANCEVIEW = 5;
    protected static final int MENUIDX_FIND = 6;
    protected static final int MENUIDX_EXPAND = 7;
    protected static final int MENUIDX_COLLAPSE = 8;
    protected static final int MENUIDX_RESTORE = 9;
    protected static final int MENUIDX_CLEAR = 10;
    protected static final String[][] MENUS = new String[][]{{"Add new Host", "addhost.png"}, {"Remove Host", "removehost.png"}, {"Add CIM Class", "addcimclass.png"}, {"Get Instances", "getinstance.png"}, {"Add in Associations (Schema)", "schemaview.png"}, {"Add in Associations (Instance)", "instanceview.png"}, {"Search", "search.png"}, {"Expand All", "expandall.png"}, {"Collapse All", "collapseall.png"}, {"Restore", "refresh.png"}, {"Clear", "clear.png"}};
    protected String viewid;
    protected TreeViewer mainviewer;
    protected TreeViewer subviewer;
    protected Tree maintree;
    protected Tree subtable;
    protected ArrayList<TreeAction> mainviewmenus;
    protected ArrayList<TreeAction> subviewmenus;
    protected TreeColumn colname;
    protected TreeColumn coltype;
    protected TreeColumn colvalue;
    protected CIMTreeData doubleclickeditem;
    protected boolean haselement;

    public BrowserView(String viewid) {
        this.viewid = viewid;
    }

    public void createPartControl(Composite parent) {
        this.createUI(parent);
        this.initializeMenus();
        this.hookMenuAndAction(this.mainviewer, this.getMenus(1));
    }

    public void setFocus() {
        this.mainviewer.getControl().setFocus();
    }

    public void refresh() {
        this.mainviewer.refresh();
        this.subviewer.refresh();
    }

    private Object[] getViewElements(int type) {
        Object[] elements = new Object[]{};
        if (type == 1) {
            elements = CIMBrowserEngine.getAllHostsInView(this.viewid);
            this.haselement = elements.length > 0;
        } else if (this.doubleclickeditem != null) {
            elements = this.doubleclickeditem.getSubTreeChildren();
        }
        return elements;
    }

    private void setSelections(Object[] elements) {
        if (elements == null || elements.length == 0) {
            return;
        }
        ArrayList<Object> selections = new ArrayList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            CIMClassData data;
            ArrayList<CIMTreeData> treeobjs;
            Object element = objectArray[n2];
            if (this.mainviewer.getExpandedState(element)) {
                selections.add(element);
            }
            if (element instanceof CIMClassData && (treeobjs = (data = (CIMClassData)element).getAllTreeObjects()) != null && treeobjs.size() > 0) {
                this.mainviewer.setExpandedElements(treeobjs.toArray());
                this.mainviewer.refresh();
                selections.add(element);
            }
            ++n2;
        }
        this.mainviewer.setSelection((ISelection)new StructuredSelection(selections.toArray()), true);
    }

    protected Object[] getSelectedElements(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toArray();
        }
        return new Object[0];
    }

    private CIMTreeData[] getSelectedItems() {
        Object[] elements;
        ArrayList<CIMTreeData> items = new ArrayList<CIMTreeData>();
        Object[] objectArray = elements = this.getSelectedElements(this.mainviewer.getSelection());
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof CIMTreeData) {
                items.add((CIMTreeData)element);
            }
            ++n2;
        }
        return items.toArray(new CIMTreeData[items.size()]);
    }

    private CIMClassData[] getSelectedClassItems() {
        Object[] elements;
        ArrayList<CIMClassData> items = new ArrayList<CIMClassData>();
        Object[] objectArray = elements = this.getSelectedElements(this.mainviewer.getSelection());
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof CIMClassData) {
                items.add((CIMClassData)element);
            }
            ++n2;
        }
        return items.toArray(new CIMClassData[items.size()]);
    }

    private void createUI(Composite parent) {
        Composite container = new Composite(parent, 4);
        container.setLayout((Layout)new FormLayout());
        final Sash sash = new Sash(container, 256);
        FormData data = new FormData();
        data.top = new FormAttachment(70, 0);
        data.right = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        sash.setLayoutData((Object)data);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((FormData)sash.getLayoutData()).top = new FormAttachment(0, event.y);
                sash.getParent().layout();
            }
        });
        Composite treecomposite = this.createMainTree(container);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)sash, 0);
        treecomposite.setLayoutData((Object)data);
        Composite tablecomposite = this.createSubTable(container);
        data = new FormData();
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)sash, 0);
        data.right = new FormAttachment(100, 0);
        tablecomposite.setLayoutData((Object)data);
    }

    private Composite createMainTree(Composite parent) {
        Composite treecomposite = new Composite(parent, 0);
        treecomposite.setLayout((Layout)new GridLayout());
        treecomposite.setLayoutData((Object)new GridData(4));
        this.maintree = new Tree(treecomposite, 2818);
        this.maintree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainviewer = new TreeViewer(this.maintree);
        this.mainviewer.setContentProvider((IContentProvider)this.getContentProvider(1));
        this.mainviewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.mainviewer.setInput((Object)this);
        this.mainviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object[] selitems = BrowserView.this.getSelectedElements(event.getSelection());
                if (selitems.length > 0 && (selitems[0] instanceof CIMClassData || selitems[0] instanceof CIMInstanceData)) {
                    BrowserView.this.doubleclickeditem = (CIMTreeData)selitems[0];
                    BrowserView.this.enableSubTree(true);
                } else {
                    BrowserView.this.doubleclickeditem = null;
                    BrowserView.this.enableSubTree(false);
                }
            }
        });
        this.mainviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BrowserView.this.refreshMenus();
            }
        });
        return treecomposite;
    }

    private Composite createSubTable(Composite parent) {
        Composite tablecomposite = new Composite(parent, 0);
        tablecomposite.setLayout((Layout)new GridLayout());
        tablecomposite.setLayoutData((Object)new GridData(4));
        this.subtable = new Tree(tablecomposite, 2816);
        this.subtable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.colname = new TreeColumn(this.subtable, 16384);
        this.colname.setAlignment(16384);
        this.colname.setText("Information");
        this.colname.setWidth(200);
        this.coltype = new TreeColumn(this.subtable, 131072);
        this.coltype.setAlignment(16384);
        this.coltype.setText("Type");
        this.coltype.setWidth(60);
        this.colvalue = new TreeColumn(this.subtable, 131072);
        this.colvalue.setAlignment(16384);
        this.colvalue.setText("Value");
        this.colvalue.setWidth(200);
        this.subviewer = new TreeViewer(this.subtable);
        this.subviewer.setContentProvider((IContentProvider)this.getContentProvider(2));
        this.subviewer.setLabelProvider((IBaseLabelProvider)this.getTableLabelProvider());
        this.subviewer.setInput((Object)this);
        this.enableSubTree(false);
        return tablecomposite;
    }

    private void enableSubTree(boolean enable) {
        this.subtable.setHeaderVisible(enable);
        this.subtable.setLinesVisible(enable);
        this.subviewer.refresh();
    }

    protected ITreeContentProvider getContentProvider(int type) {
        return new TreeContentProvider(type);
    }

    protected ILabelProvider getLabelProvider() {
        return new TreeLabelProvider();
    }

    protected ITableLabelProvider getTableLabelProvider() {
        return new TableLabelProvider();
    }

    private void initializeMenus() {
        this.mainviewmenus = new ArrayList();
        this.subviewmenus = new ArrayList();
        int i = 0;
        while (i < MENUS.length) {
            String[] menu = MENUS[i];
            if (this.isMenuValid(this.viewid, i)) {
                this.mainviewmenus.add(new TreeAction(1, menu[0], CIMToolsPlugin.getDefault().getImageDescriptor(menu[1])));
                this.subviewmenus.add(new TreeAction(2, menu[0], CIMToolsPlugin.getDefault().getImageDescriptor(menu[1])));
            }
            ++i;
        }
    }

    private ArrayList<TreeAction> getMenus(int treetype) {
        if (treetype == 1) {
            return this.mainviewmenus;
        }
        return new ArrayList<TreeAction>();
    }

    private int getMenuType(String menutext) {
        int i = 0;
        while (i < MENUS.length) {
            if (MENUS[i][0].equals(menutext)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void hookMenuAndAction(TreeViewer viewer, final ArrayList<TreeAction> menus) {
        if (viewer == null || menus == null || menus.size() == 0) {
            return;
        }
        IActionBars bars = this.getViewSite().getActionBars();
        for (TreeAction menu : menus) {
            bars.getToolBarManager().add((IAction)menu);
            bars.getMenuManager().add((IAction)menu);
        }
        MenuManager classmenuMgr = new MenuManager("#PopupMenu");
        classmenuMgr.setRemoveAllWhenShown(true);
        classmenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (TreeAction menu : menus) {
                    manager.add((IAction)menu);
                }
                BrowserView.this.refreshMenus();
            }
        });
        Menu classviewermenu = classmenuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(classviewermenu);
        this.getSite().registerContextMenu(classmenuMgr, (ISelectionProvider)viewer);
        this.refreshMenus();
    }

    private TreeAction getMenuAction(int treetype, int menutype) {
        ArrayList<TreeAction> viewmenus = treetype == 1 ? this.mainviewmenus : this.subviewmenus;
        for (TreeAction viewmenu : viewmenus) {
            if (!viewmenu.getText().equals(MENUS[menutype][0])) continue;
            return viewmenu;
        }
        return null;
    }

    private void menuEnabled(int treetype, int menutype, boolean enabled) {
        TreeAction menu = this.getMenuAction(treetype, menutype);
        if (menu != null) {
            menu.setEnabled(enabled);
        }
    }

    private void menuEnabled(int menutype, boolean enabled) {
        this.menuEnabled(1, menutype, enabled);
        this.menuEnabled(2, menutype, enabled);
    }

    private void refreshMenus() {
        CIMTreeData[] selitems = this.getSelectedItems();
        boolean hosts = true;
        CIMTreeData[] cIMTreeDataArray = selitems;
        int n = selitems.length;
        int n2 = 0;
        while (n2 < n) {
            CIMTreeData sel = cIMTreeDataArray[n2];
            if (!(sel instanceof CIMHost)) {
                hosts = false;
            }
            ++n2;
        }
        this.menuEnabled(1, selitems.length > 0 && hosts);
        this.menuEnabled(2, selitems.length == 1 && hosts);
        this.menuEnabled(3, selitems.length == 1 && selitems[0] instanceof CIMClassData);
        this.menuEnabled(4, selitems.length > 0 && selitems[0] instanceof CIMClassData);
        this.menuEnabled(5, selitems.length > 0 && selitems[0] instanceof CIMClassData);
        this.menuEnabled(8, this.haselement);
        this.menuEnabled(7, this.haselement);
        this.menuEnabled(6, selitems.length == 1);
        this.menuEnabled(9, selitems.length > 0 && hosts);
        this.menuEnabled(10, selitems.length > 0 && hosts);
    }

    protected boolean isMenuValid(String viewid, int menuindex) {
        return true;
    }

    protected void execAddHostMenu() {
        boolean selclassonly = !CIMBrowserEngine.isInheritanceView(this.viewid);
        CIMBrowserWizard wizard = new CIMBrowserWizard(null, this.viewid, true, selclassonly);
        wizard.init(this.getSite().getWorkbenchWindow().getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    protected void execRemoveHostMenu() {
        CIMTreeData[] selitems = this.getSelectedItems();
        if (selitems.length > 0) {
            MessageBox msgbox = new MessageBox(this.getSite().getShell(), 292);
            msgbox.setMessage("Do you want to remove the CIM host(s) ?\n");
            msgbox.setText("CIM Browser");
            if (msgbox.open() == 32) {
                CIMTreeData[] cIMTreeDataArray = selitems;
                int n = selitems.length;
                int n2 = 0;
                while (n2 < n) {
                    CIMTreeData item = cIMTreeDataArray[n2];
                    if (item instanceof CIMHost) {
                        CIMBrowserEngine.removeHostInView(this.viewid, (CIMHost)item);
                    }
                    ++n2;
                }
                this.mainviewer.refresh();
            }
        }
    }

    protected void execAddCIMClassMenu() {
        CIMTreeData[] selitems = this.getSelectedItems();
        if (selitems.length == 1 && selitems[0] instanceof CIMHost) {
            CIMHost host = (CIMHost)selitems[0];
            boolean selclassonly = !CIMBrowserEngine.isInheritanceView(this.viewid);
            CIMBrowserWizard wizard = new CIMBrowserWizard(host, this.viewid, false, selclassonly);
            wizard.init(this.getSite().getWorkbenchWindow().getWorkbench(), null);
            WizardDialog dialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
    }

    protected void execGetInstanceMenu() {
        CIMTreeData[] selitems = this.getSelectedItems();
        if (selitems.length == 1 && selitems[0] instanceof CIMClassData) {
            this.doubleclickeditem = (CIMClassData)selitems[0];
            this.enableSubTree(true);
        } else {
            this.enableSubTree(false);
        }
    }

    protected void execFindMenu() {
        CIMTreeData[] selitems = this.getSelectedItems();
        CIMHost host = null;
        if (selitems.length > 0) {
            if (selitems[0] instanceof CIMHost) {
                host = (CIMHost)selitems[0];
            } else if (selitems[0] instanceof CIMClassData) {
                host = ((CIMClassData)selitems[0]).getCIMHost();
            }
        }
        if (host != null) {
            SearchClassWizard wizard = new SearchClassWizard(host, "");
            wizard.init(this.getSite().getWorkbenchWindow().getWorkbench(), null);
            WizardDialog dialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                CIMClassData classdata = wizard.getSelectedCIMClass();
                if (classdata != null) {
                    this.setSelections(new Object[]{classdata});
                } else {
                    UtilDialog.openDialog(CIMToolsException.createCIMBrowserException(DLG_FINDCIMCLASS_NOCLASS, null));
                }
            }
        } else {
            UtilDialog.openDialog(CIMToolsException.createCIMBrowserException(DLG_FINDCIMCLASS_NOHOST, null));
        }
    }

    protected void execInstanceViewMenu() {
        CIMClassData[] selitems = this.getSelectedClassItems();
        if (selitems.length > 0) {
            try {
                CIMBrowserEngine.addCIMClassesInInstanceView(selitems);
            }
            catch (CIMToolsException e) {
                UtilDialog.openDialog(e);
            }
            catch (Exception e) {
                UtilDialog.openDialog(CIMToolsException.createCIMBrowserException(e.getLocalizedMessage(), e));
            }
        }
    }

    protected void execSchemaViewMenu() {
        CIMClassData[] selitems = this.getSelectedClassItems();
        if (selitems.length > 0) {
            try {
                CIMBrowserEngine.addCIMClassesInSchemaView(selitems);
            }
            catch (CIMToolsException e) {
                UtilDialog.openDialog(e);
            }
            catch (Exception e) {
                UtilDialog.openDialog(CIMToolsException.createCIMBrowserException(e.getLocalizedMessage(), e));
            }
        }
    }

    protected void execClearMenu() {
        CIMTreeData[] selitems = this.getSelectedItems();
        if (selitems.length > 0) {
            CIMTreeData[] cIMTreeDataArray = selitems;
            int n = selitems.length;
            int n2 = 0;
            while (n2 < n) {
                CIMTreeData selitem = cIMTreeDataArray[n2];
                if (selitem instanceof CIMHost) {
                    ((CIMHost)selitem).removeAllClasses(this.viewid);
                }
                ++n2;
            }
        }
        this.mainviewer.refresh();
        this.subviewer.refresh();
    }

    protected void execRestoreMenu() {
        try {
            CIMTreeData[] selitems = this.getSelectedItems();
            if (selitems.length > 0) {
                CIMTreeData[] cIMTreeDataArray = selitems;
                int n = selitems.length;
                int n2 = 0;
                while (n2 < n) {
                    CIMTreeData selitem = cIMTreeDataArray[n2];
                    if (selitem instanceof CIMHost) {
                        ((CIMHost)selitem).restoreAll();
                    }
                    ++n2;
                }
            }
        }
        catch (CIMToolsException e) {
            UtilDialog.openDialog(e);
        }
        this.refresh();
    }

    protected void execCollapse() {
        TreeItem[] treeitems = this.maintree.getSelection();
        if (treeitems.length == 0) {
            this.mainviewer.collapseAll();
            return;
        }
        TreeItem[] treeItemArray = treeitems;
        int n = treeitems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.setExpanded(false);
            ++n2;
        }
    }

    protected void execExpand() {
        TreeItem[] treeitems = this.maintree.getSelection();
        if (treeitems.length == 0) {
            this.mainviewer.expandAll();
            return;
        }
        TreeItem[] treeItemArray = treeitems;
        int n = treeitems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.expandAllSubTrees(item);
            ++n2;
        }
    }

    private void expandAllSubTrees(TreeItem treeitem) {
        this.mainviewer.refresh(treeitem.getData());
        this.mainviewer.setExpandedState(treeitem.getData(), true);
        TreeItem[] treeItemArray = treeitem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.expandAllSubTrees(item);
            ++n2;
        }
    }

    public static void refreshView(final String viewid, final boolean openview, final Object[] elements) throws Exception {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IWorkbenchWindow wbWindow = wb.getActiveWorkbenchWindow();
                    IWorkbenchPage page = wbWindow.getActivePage();
                    if (page == null) {
                        return;
                    }
                    IViewPart view = page.getActivePart().getSite().getPage().findView(viewid);
                    if (view == null && openview) {
                        view = page.showView(viewid);
                    }
                    if (view != null) {
                        BrowserView browserview = (BrowserView)view;
                        browserview.refresh();
                        if (elements != null && elements.length > 0) {
                            browserview.setSelections(elements);
                        }
                        if (openview) {
                            page.activate((IWorkbenchPart)browserview);
                            browserview.setFocus();
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
    }

    private class TableLabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int colindex) {
            if (element instanceof CIMTreeData) {
                return ((CIMTreeData)element).getColumnImage(colindex);
            }
            return null;
        }

        public String getColumnText(Object element, int colindex) {
            if (element instanceof CIMTreeData) {
                return ((CIMTreeData)element).getColumnText(colindex);
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class TreeAction
    extends Action {
        public TreeAction(int type, String text, ImageDescriptor image) {
            this.setText(text);
            this.setToolTipText(text);
            if (image != null) {
                this.setImageDescriptor(image);
            }
        }

        public void run() {
            int menutype = BrowserView.this.getMenuType(this.getText());
            if (menutype != -1) {
                try {
                    switch (menutype) {
                        case 0: {
                            BrowserView.this.execAddHostMenu();
                            break;
                        }
                        case 1: {
                            BrowserView.this.execRemoveHostMenu();
                            break;
                        }
                        case 2: {
                            BrowserView.this.execAddCIMClassMenu();
                            break;
                        }
                        case 3: {
                            BrowserView.this.execGetInstanceMenu();
                            break;
                        }
                        case 4: {
                            BrowserView.this.execSchemaViewMenu();
                            break;
                        }
                        case 5: {
                            BrowserView.this.execInstanceViewMenu();
                            break;
                        }
                        case 6: {
                            BrowserView.this.execFindMenu();
                            break;
                        }
                        case 7: {
                            BrowserView.this.execExpand();
                            break;
                        }
                        case 8: {
                            BrowserView.this.execCollapse();
                            break;
                        }
                        case 10: {
                            BrowserView.this.execClearMenu();
                            break;
                        }
                        case 9: {
                            BrowserView.this.execRestoreMenu();
                        }
                    }
                }
                catch (Exception e) {
                    UtilDialog.openDialog(CIMToolsException.createCIMBrowserException(e.getMessage(), e));
                }
            }
        }
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        int treetype;

        public TreeContentProvider(int type) {
            this.treetype = type;
        }

        public Object[] getElements(Object obj) {
            return BrowserView.this.getViewElements(this.treetype);
        }

        public Object[] getChildren(Object element) {
            if (element instanceof CIMTreeData) {
                return ((CIMTreeData)element).getChildren(BrowserView.this.viewid, this.treetype);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof CIMTreeData) {
                return ((CIMTreeData)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof CIMTreeData) {
                return ((CIMTreeData)element).hasChildren(BrowserView.this.viewid, this.treetype);
            }
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TreeLabelProvider
    implements ILabelProvider {
        private TreeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof CIMTreeData) {
                return ((CIMTreeData)element).getImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof CIMTreeData) {
                return ((CIMTreeData)element).getText();
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

