/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.ui.menu;

import com.vmware.vide.cimtools.core.cimbrowser.CIMBrowserEngine;
import com.vmware.vide.cimtools.ui.cimbrowser.BrowserView;
import com.vmware.vide.cimtools.ui.cimbrowser.WBEMOperationView;
import com.vmware.vide.cimtools.utils.CIMToolsException;
import com.vmware.vide.cimtools.utils.UtilDialog;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;

public class MenuHandler
extends AbstractHandler {
    private static final String[][] CIMBROWSER_MENUS = new String[][]{{"CIM Inheritance", "com.vmware.vide.cimtools.inheritanceview"}, {"CIM Associations (Schema)", "com.vmware.vide.cimtools.schemaview"}, {"CIM Associations (Instance)", "com.vmware.vide.cimtools.instanceview"}, {"WBEM Operation", "com.vmware.vide.cimtools.wbemoperationview"}};

    public Object execute(ExecutionEvent event) throws ExecutionException {
        MenuItem menuitem = this.getCurrentMenuItem(event);
        String viewid = this.getViewId(menuitem.getText());
        if (viewid != null && !viewid.isEmpty()) {
            this.menuOpenCIMBrowser(viewid);
        }
        return true;
    }

    public MenuItem getCurrentMenuItem(ExecutionEvent event) {
        if (event.getTrigger() instanceof Event) {
            Event e = (Event)event.getTrigger();
            if (e.widget instanceof MenuItem) {
                return (MenuItem)e.widget;
            }
        }
        return null;
    }

    private void menuOpenCIMBrowser(String viewid) {
        try {
            if (CIMBrowserEngine.isWBEMOperationView(viewid)) {
                WBEMOperationView.refreshView(true);
            } else {
                BrowserView.refreshView(viewid, true, null);
            }
        }
        catch (Exception e) {
            UtilDialog.openDialog(CIMToolsException.createCommonException(e.getMessage(), e));
        }
    }

    private String getViewId(String menutext) {
        String[][] stringArray = CIMBROWSER_MENUS;
        int n = CIMBROWSER_MENUS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] menus = stringArray[n2];
            if (menus[0].equals(menutext)) {
                return menus[1];
            }
            ++n2;
        }
        return null;
    }
}

