/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui;

import com.vmware.vide.vlogbrowser.core.consts.LogBrowserConsts;
import com.vmware.vide.vlogbrowser.core.parser.XmlDocUtils;
import com.vmware.vide.vlogbrowser.ui.editors.LogBrowserEditor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LogBrowserResourceChange
implements IResourceChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(LogBrowserResourceChange.class);

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta rootDelta = event.getDelta();
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource;
                    if (delta.getKind() == 2 && (resource = delta.getResource()).getType() == 1 && resource.getFileExtension().equalsIgnoreCase("logx")) {
                        IFile iFile = (IFile)resource;
                        try {
                            IPath iPath = iFile.getFullPath();
                            LogBrowserResourceChange.this.closeLogBrowserEditor(iPath.toOSString());
                            InputStream logFileInputStream = LogBrowserResourceChange.this.getLocalHistory(iFile);
                            if (logFileInputStream != null) {
                                LogBrowserResourceChange.this.deleteLogCache(logFileInputStream);
                            }
                        }
                        catch (Exception e) {
                            logger.error("Unable to delete cache files for log: {}", (Object)iFile.getFullPath().toOSString(), (Object)e);
                        }
                    }
                    return true;
                }
            };
            try {
                rootDelta.accept(visitor);
            }
            catch (CoreException e) {
                logger.error("Unable to delete cache files", (Throwable)e);
            }
        }
    }

    private InputStream getLocalHistory(IFile iFile) throws CoreException {
        InputStream logFileinputStream = null;
        IFileState[] history = iFile.getHistory(null);
        if (history.length != 0) {
            logFileinputStream = history[0].getContents();
        }
        return logFileinputStream;
    }

    private void closeLogBrowserEditor(String filePath) {
        IWorkbenchWindow[] myWindows;
        IWorkbenchWindow[] iWorkbenchWindowArray = myWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = myWindows.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] myRefs;
            IWorkbenchWindow myWindow = iWorkbenchWindowArray[n2];
            final IWorkbenchPage myPage = myWindow.getActivePage();
            IEditorReference[] iEditorReferenceArray = myRefs = myPage.getEditorReferences();
            int n3 = myRefs.length;
            int n4 = 0;
            while (n4 < n3) {
                IFile iFile;
                IPath iPath;
                String editorFilePath;
                IEditorInput input;
                IEditorReference myRef = iEditorReferenceArray[n4];
                final IEditorPart myEditor = myRef.getEditor(false);
                if (myEditor instanceof LogBrowserEditor && (input = myEditor.getEditorInput()) instanceof IFileEditorInput && (editorFilePath = (iPath = (iFile = ((IFileEditorInput)input).getFile()).getFullPath()).toOSString()) != null && editorFilePath.equals(filePath)) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            myPage.closeEditor(myEditor, false);
                        }
                    });
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void deleteLogCache(InputStream logFileInputStream) throws SAXException, IOException, ParserConfigurationException {
        Document document = XmlDocUtils.readXmlFromInputStream((InputStream)logFileInputStream);
        NodeList nodeList = document.getElementsByTagName("logx_ID");
        if (nodeList.getLength() == 1) {
            Element tagLogxId = (Element)nodeList.item(0);
            String textLogxId = tagLogxId.getTextContent();
            FileUtils.deleteDirectory((File)new File(LogBrowserConsts.CACHE_DIR, textLogxId));
        }
    }
}

