/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.chart;

import com.vmware.vide.vlogbrowser.core.chart.IZoomActionListener;
import com.vmware.vide.vlogbrowser.core.chart.ZoomEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scale;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.data.Range;
import org.jfree.data.time.DateRange;

public class LogChartSlider
implements SelectionListener,
IZoomActionListener,
ChartMouseListener {
    private static final int SLIDER_INITIAL_VALUE = 50;
    private static final double DELTA = 10.0;
    private int lastValue = 50;
    private Scale slider;
    private CombinedDomainXYPlot combinedDomainPlot;

    public LogChartSlider(CombinedDomainXYPlot combinedDomainPlot) {
        this.combinedDomainPlot = combinedDomainPlot;
    }

    public void createSlider(Composite panel) {
        this.slider = new Scale(panel, 256);
        this.slider.setMaximum(100);
        this.slider.setMinimum(0);
        this.slider.setSelection(50);
        this.slider.addSelectionListener((SelectionListener)this);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 24;
        this.slider.setLayoutData((Object)gridData);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.combinedDomainPlot.getSubplots().size() > 0) {
            DateAxis domainAxis = (DateAxis)this.combinedDomainPlot.getDomainAxis();
            int value = this.slider.getSelection();
            if (value != this.lastValue && domainAxis != null) {
                Range range = domainAxis.getRange();
                double minimum = range.getLowerBound();
                double maximum = range.getUpperBound();
                double delta = range.getLength() / 10.0;
                if (value < this.lastValue) {
                    minimum -= delta;
                    maximum -= delta;
                } else {
                    minimum += delta;
                    maximum += delta;
                }
                DateRange newRange = new DateRange(minimum, maximum);
                domainAxis.setRange((Range)newRange);
                this.lastValue = value;
            }
        } else {
            this.slider.setSelection(50);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void zoomPerformed(ZoomEvent event) {
        this.slider.setSelection(50);
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        this.slider.setSelection(50);
    }

    public void chartMouseMoved(ChartMouseEvent event) {
    }
}

