/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.chart;

import com.vmware.vide.vlogbrowser.core.chart.ILogFile;
import com.vmware.vide.vlogbrowser.core.chart.IZoomActionListener;
import com.vmware.vide.vlogbrowser.core.chart.ZoomEvent;
import com.vmware.vide.vlogbrowser.ui.LogBrowserUiPlugin;
import com.vmware.vide.vlogbrowser.ui.chart.LogDatasetManager;
import com.vmware.vide.vlogbrowser.ui.chart.LogSubplot;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.data.Range;
import org.jfree.data.time.DateRange;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Week;

public class LogChartZoom
implements Listener,
SelectionListener {
    public static final String ZOOM_MINUTE = "<a>1 Min</a>";
    public static final String ZOOM_HOUR = "<a>1 Hour</a>";
    public static final String ZOOM_DAY = "<a>1 Day</a>";
    public static final String ZOOM_WEEK = "<a>1 Week</a>";
    public static final String ZOOM_MONTH = "<a>1 Month</a>";
    public static final String ZOOM_ALL = "<a>Zoom All</a>";
    public static final String ZOOM_IN = "Zoom In";
    public static final String ZOOM_OUT = "Zoom Out";
    public static final String IMG_ZOOM_IN = "/icons/zoomin.png";
    public static final String IMG_ZOOM_OUT = "/icons/zoomout.png";
    public transient List<IZoomActionListener> listZoomActionListener;
    private CombinedDomainXYPlot combinedDomainPlot;

    public LogChartZoom(CombinedDomainXYPlot combinedDomainPlot) {
        this.combinedDomainPlot = combinedDomainPlot;
        this.listZoomActionListener = new LinkedList<IZoomActionListener>();
    }

    public void createZoomButtons(Composite composite) {
        Link minute = new Link(composite, 0);
        minute.setText(ZOOM_MINUTE);
        minute.setData((Object)ZOOM_MINUTE);
        minute.addListener(13, (Listener)this);
        Link hour = new Link(composite, 0);
        hour.setText(ZOOM_HOUR);
        hour.setData((Object)ZOOM_HOUR);
        hour.addListener(13, (Listener)this);
        Link day = new Link(composite, 0);
        day.setText(ZOOM_DAY);
        day.setData((Object)ZOOM_DAY);
        day.addListener(13, (Listener)this);
        Link week = new Link(composite, 0);
        week.setText(ZOOM_WEEK);
        week.setData((Object)ZOOM_WEEK);
        week.addListener(13, (Listener)this);
        GridData layoutData = new GridData();
        layoutData.widthHint = 50;
        week.setLayoutData((Object)layoutData);
        Link month = new Link(composite, 0);
        month.setText(ZOOM_MONTH);
        month.setData((Object)ZOOM_MONTH);
        month.addListener(13, (Listener)this);
        Link all = new Link(composite, 0);
        all.setText(ZOOM_ALL);
        all.setData((Object)ZOOM_ALL);
        all.addListener(13, (Listener)this);
        ImageRegistry registry = new ImageRegistry();
        registry.put(ZOOM_IN, LogBrowserUiPlugin.getImageDescriptor(IMG_ZOOM_IN));
        registry.put(ZOOM_OUT, LogBrowserUiPlugin.getImageDescriptor(IMG_ZOOM_OUT));
        Button zoomInButton = new Button(composite, 8);
        zoomInButton.setImage(registry.get(ZOOM_IN));
        zoomInButton.addSelectionListener((SelectionListener)this);
        zoomInButton.setToolTipText(ZOOM_IN);
        zoomInButton.setData((Object)ZOOM_IN);
        Button zoomOutButton = new Button(composite, 8);
        zoomOutButton.setImage(registry.get(ZOOM_OUT));
        zoomOutButton.addSelectionListener((SelectionListener)this);
        zoomOutButton.setToolTipText(ZOOM_OUT);
        zoomOutButton.setData((Object)ZOOM_OUT);
    }

    public void handleEvent(Event event) {
        if (this.combinedDomainPlot.getSubplots().size() > 0) {
            DateAxis domainAxis = (DateAxis)this.combinedDomainPlot.getDomainAxis();
            Widget button = event.widget;
            String command = (String)button.getData();
            Range range = domainAxis.getRange();
            if (command != null && range.getLength() > 1.0) {
                double middle = range.getLowerBound() + range.getLength() / 2.0;
                double lower = 0.0;
                double upper = 0.0;
                if (command.equals(ZOOM_MINUTE)) {
                    Minute minute = new Minute();
                    long oneMinute = minute.getLastMillisecond() - minute.getFirstMillisecond();
                    lower = middle - (double)(oneMinute / 2L);
                    upper = middle + (double)(oneMinute / 2L);
                } else if (command.equals(ZOOM_HOUR)) {
                    Hour hour = new Hour();
                    long oneHour = hour.getLastMillisecond() - hour.getFirstMillisecond();
                    lower = middle - (double)(oneHour / 2L);
                    upper = middle + (double)(oneHour / 2L);
                } else if (command.equals(ZOOM_DAY)) {
                    Day day = new Day();
                    long oneDay = day.getLastMillisecond() - day.getFirstMillisecond();
                    lower = middle - (double)(oneDay / 2L);
                    upper = middle + (double)(oneDay / 2L);
                } else if (command.equals(ZOOM_WEEK)) {
                    Week week = new Week();
                    long oneWeek = week.getLastMillisecond() - week.getFirstMillisecond();
                    lower = middle - (double)(oneWeek / 2L);
                    upper = middle + (double)(oneWeek / 2L);
                } else if (command.equals(ZOOM_MONTH)) {
                    Month month = new Month();
                    long oneMonth = month.getLastMillisecond() - month.getFirstMillisecond();
                    lower = middle - (double)(oneMonth / 2L);
                    upper = middle + (double)(oneMonth / 2L);
                } else if (command.equals(ZOOM_ALL)) {
                    DateRange dateRange = this.getZoomAllDateRange();
                    lower = dateRange.getLowerBound();
                    upper = dateRange.getUpperBound();
                }
                domainAxis.setRange((Range)new DateRange(lower, upper));
                this.notifyListeners(new ZoomEvent(ZoomEvent.ZoomEventType.ZOOM_DATE));
            }
        }
    }

    private DateRange getZoomAllDateRange() {
        double upperBound = Double.MIN_VALUE;
        double lowerBound = Double.MAX_VALUE;
        List subplots = this.combinedDomainPlot.getSubplots();
        int i = 0;
        while (i < subplots.size()) {
            LogSubplot logSubplot = (LogSubplot)((Object)subplots.get(i));
            ILogFile logFile = logSubplot.getLogFile();
            DateRange logRange = LogDatasetManager.getDateRange(logFile);
            if (lowerBound > logRange.getLowerBound()) {
                lowerBound = logRange.getLowerBound();
            }
            if (upperBound < logRange.getUpperBound()) {
                upperBound = logRange.getUpperBound();
            }
            ++i;
        }
        double diff = upperBound - lowerBound;
        double factor = 0.01;
        return new DateRange(lowerBound -= diff * factor, upperBound += diff * factor);
    }

    public void widgetSelected(SelectionEvent e) {
        Button button = (Button)e.widget;
        String command = (String)button.getData();
        if (command.equals(ZOOM_IN)) {
            this.zoom(0.2);
            this.notifyListeners(new ZoomEvent(ZoomEvent.ZoomEventType.ZOOM_IN));
        } else if (command.equals(ZOOM_OUT)) {
            this.zoom(-0.4);
            this.notifyListeners(new ZoomEvent(ZoomEvent.ZoomEventType.ZOOM_OUT));
        }
    }

    private DateRange zoom(double percent) {
        DateAxis domainAxis;
        DateRange result = null;
        if (this.combinedDomainPlot.getSubplots().size() > 0 && (domainAxis = (DateAxis)this.combinedDomainPlot.getDomainAxis()) != null) {
            Range range = domainAxis.getRange();
            double lower = range.getLowerBound();
            double upper = range.getUpperBound();
            double length = range.getLength();
            result = new DateRange(lower + length * percent, upper - length * percent);
            domainAxis.setRange((Range)result);
        }
        return result;
    }

    public synchronized void addZoomActionListener(IZoomActionListener listener) {
        this.listZoomActionListener.add(listener);
    }

    public synchronized void removeZoomActionListener(IZoomActionListener listener) {
        this.listZoomActionListener.remove(listener);
    }

    protected void notifyListeners(ZoomEvent event) {
        for (IZoomActionListener listener : this.listZoomActionListener) {
            listener.zoomPerformed(event);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

