/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.chart;

import com.vmware.vide.vlogbrowser.core.chart.ILogFile;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.model.util.IFilteredList;
import com.vmware.vide.vlogbrowser.ui.chart.LogSeries;
import com.vmware.vide.vlogbrowser.ui.chart.LogSubplot;
import java.util.HashMap;
import java.util.List;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.data.Range;
import org.jfree.data.time.DateRange;

public class LogDatasetManager {
    private static final int BAR_SIZE = 10;
    private static final int BINARY_SEARCH_THRESHOLD = 3;
    private int numberOfBars = 1;

    public void updateNumberOfBars(int width) {
        this.numberOfBars = width / 10;
    }

    public void createSeries(CombinedDomainXYPlot plot) {
        List subplots = plot.getSubplots();
        DateAxis domainAxis = (DateAxis)plot.getDomainAxis();
        DateRange dateRange = (DateRange)domainAxis.getRange();
        for (LogSubplot subplot : subplots) {
            ILogFile logFile = subplot.getLogFile();
            LogSeries series = this.createSeries(logFile, dateRange);
            subplot.addReplaceSeries(series);
        }
    }

    public LogSeries createSeries(ILogFile logFile) {
        DateRange dateRange = LogDatasetManager.getDateRange(logFile);
        return this.createSeries(logFile, dateRange, 0);
    }

    public static DateRange getDateRange(ILogFile logFile) {
        long upperDateMs = 0L;
        long lowerDateMs = 0L;
        List allItems = logFile.getFilterList().getUnfiltered();
        for (LogItem logItem : allItems) {
            long time = logItem.getLogDate().getTime();
            if (time == 0L) continue;
            if (time < lowerDateMs || lowerDateMs == 0L) {
                lowerDateMs = time;
            }
            if (time <= upperDateMs) continue;
            upperDateMs = time;
        }
        DateRange dateRange = new DateRange((double)lowerDateMs, (double)upperDateMs);
        return dateRange;
    }

    private LogSeries createSeries(ILogFile logFile, DateRange dateRange) {
        List logItemList = logFile.getFilterList().getUnfiltered();
        long lowerDate = dateRange.getLowerMillis();
        int beginIndex = LogDatasetManager.binarySearchWorstCase(logItemList, logItemList.size(), lowerDate);
        LogSeries series = this.createSeries(logFile, dateRange, beginIndex);
        return series;
    }

    private LogSeries createSeries(ILogFile logFile, DateRange dateRange, int beginIndex) {
        int bar;
        long logItemTime;
        LogItem logItem;
        int startIndex;
        IFilteredList filteredItems = logFile.getFilterList();
        List logItems = filteredItems.getUnfiltered();
        boolean isFiltered = logItems.size() != filteredItems.size();
        HashMap<Integer, Boolean> mapFilter = new HashMap<Integer, Boolean>();
        long yUpperBound = 1L;
        double[] xValues = new double[this.numberOfBars];
        double[] yValues = new double[this.numberOfBars];
        long lowerDate = dateRange.getLowerMillis();
        long upperDate = dateRange.getUpperMillis();
        long deltaTotal = upperDate - lowerDate;
        long oneBarDelta = deltaTotal / (long)this.numberOfBars;
        long factor = deltaTotal / 100L;
        dateRange = new DateRange((double)(lowerDate - factor), (double)(upperDate + factor));
        int i = 0;
        while (i < this.numberOfBars) {
            xValues[i] = lowerDate + (long)i * oneBarDelta;
            ++i;
        }
        boolean isDateSorted = false;
        int i2 = startIndex = isDateSorted ? beginIndex : 0;
        while (i2 < logItems.size()) {
            logItem = (LogItem)logItems.get(i2);
            logItemTime = logItem.getLogDate().getTime();
            if (isDateSorted && logItemTime > upperDate) break;
            if (logItemTime >= lowerDate && logItemTime <= upperDate && (bar = (int)((logItemTime - lowerDate) / oneBarDelta)) >= 0 && bar < this.numberOfBars) {
                int n = bar;
                yValues[n] = yValues[n] + 1.0;
                if ((double)yUpperBound < yValues[bar]) {
                    yUpperBound = (long)yValues[bar];
                }
            }
            ++i2;
        }
        if (isFiltered) {
            i2 = startIndex = 0;
            while (i2 < filteredItems.size()) {
                logItem = (LogItem)filteredItems.get(i2);
                logItemTime = logItem.getLogDate().getTime();
                if (isDateSorted && logItemTime > upperDate) break;
                if (logItemTime >= lowerDate && logItemTime <= upperDate) {
                    bar = (int)((logItemTime - lowerDate) / oneBarDelta);
                    mapFilter.put(new Integer(bar), Boolean.TRUE);
                }
                ++i2;
            }
        }
        return new LogSeries(xValues, yValues, dateRange, new Range(0.0, (double)yUpperBound), mapFilter);
    }

    private static int binarySearchWorstCase(List<LogItem> logItems, int size, long findMe) {
        int low = 0;
        int high = size - 1;
        while (high - low >= 3) {
            int mid = (low + high) / 2;
            long middleDate = logItems.get(mid).getLogDate().getTime();
            if (middleDate < findMe) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low;
    }
}

