/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs.highlight;

import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightElement;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightElementList;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightElementsPersistence;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightTableViewer;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AdvancedHighlightDialog
extends Dialog {
    private static final String HIGHLIGHT_LABEL = "Highlight";
    private static final int HIGHLIGHT_BTN_ID = 1025;
    private HighlightTableViewer highlightTableViewer;
    private LogTableViewer logTableViewer;
    private HighlightElementList elementList;
    private HighlightElementsPersistence persistence;

    public AdvancedHighlightDialog(Shell parentShell, LogTableViewer logTableViewer) {
        super(parentShell);
        this.logTableViewer = logTableViewer;
        this.persistence = new HighlightElementsPersistence(logTableViewer);
        this.elementList = this.persistence.loadKeywordsFromLogXFile();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.highlightTableViewer = new HighlightTableViewer(container, this.elementList);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, HIGHLIGHT_LABEL, true);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        List<HighlightElement> elements = this.highlightTableViewer.getElementList().getElements();
        if (buttonId == 12) {
            this.persistence.saveKeywordsToLogXFile(elements);
            this.highlightTableViewer.dispose();
            super.close();
        } else if (buttonId == 1025) {
            HashMap<String, RGB> keywordsToHighlight = new HashMap<String, RGB>();
            for (HighlightElement element : elements) {
                if (!element.isEnable()) continue;
                keywordsToHighlight.put(element.getKeyword(), element.getColor());
            }
            this.logTableViewer.highlight(keywordsToHighlight);
            this.logTableViewer.setVisibleLinkAdvancedUnhighlight(true);
        }
    }

    protected Point getInitialSize() {
        return new Point(424, 350);
    }
}

