/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.editors;

import com.vmware.vide.utils.net.HttpLogger;
import com.vmware.vide.utils.resource.ResourceUtils;
import com.vmware.vide.vlogbrowser.core.model.LogFilter;
import com.vmware.vide.vlogbrowser.core.model.LogSystemType;
import com.vmware.vide.vlogbrowser.core.parser.ConfigParser;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import com.vmware.vide.vlogbrowser.core.parser.LogFormatException;
import com.vmware.vide.vlogbrowser.ui.LogBrowserUiPlugin;
import com.vmware.vide.vlogbrowser.ui.fileops.UiLogFileManager;
import com.vmware.vide.vlogbrowser.ui.runners.LogLoadRunner;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import com.vmware.vide.vxmleditor.editors.XMLEditor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class LogBrowserEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private static final int TABLE_PAGE = 0;
    private static final int TEXT_PAGE = 1;
    private static final String LOG_BROWSER_STATUS_ID = "LogBrowserEditorStatusID";
    private static final String MUST_SAVE_EDITOR_MSG = "You must save the editor before switching to the log view";
    private TextEditor editor;
    private UiLogFileManager logFileMgr;
    private LogFormat myLogFormat;
    private LogTableViewer myLogTableViewer;
    private ConfigParser cfgParser;
    private Map<String, LogFilter> namedLogFilters;
    private boolean hasXmlError = false;
    private boolean hasConfigFileChangedSinceTableSync = false;
    private String prjName = null;

    public LogBrowserEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void removeProblemMarkers(IFile file) {
        try {
            file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException coreException) {}
    }

    private void removeProblemMarkers() {
        IEditorInput input = this.getEditorInput();
        if (input != null && input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            this.removeProblemMarkers(file);
        }
    }

    private void createProblemMarker(int line, String msg) {
        IEditorInput input = this.getEditorInput();
        if (input != null && input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            try {
                IFile file = fileInput.getFile();
                IMarker m = file.createMarker("org.eclipse.core.resources.problemmarker");
                m.setAttribute("lineNumber", line);
                m.setAttribute("message", (Object)msg);
                m.setAttribute("priority", 2);
                m.setAttribute("severity", 2);
                this.showProblemsView();
            }
            catch (CoreException coreException) {}
        }
    }

    private void createProblemMarker(LogFormatException lfe) {
        this.createProblemMarker(lfe.getLine(), lfe.getMessage());
    }

    private void showProblemsView() {
        String problemsViewID = "org.eclipse.ui.views.ProblemView";
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(problemsViewID);
        }
        catch (Exception e) {
            LogBrowserUiPlugin.log("Error showing problems view", e);
        }
    }

    void createLogTableViewerPage(int pageIndex) throws PartInitException {
        this.addPage(0, null);
        this.setPageText(0, "Log Viewer");
        this.syncTableViewerPage();
    }

    void checkConfigFile() {
        this.hasXmlError = false;
        this.removeProblemMarkers();
        String editorText = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
        byte[] editorByteArr = editorText.getBytes();
        ByteArrayInputStream configInputStream = new ByteArrayInputStream(editorByteArr);
        IFile configIFile = ((FileEditorInput)this.editor.getEditorInput()).getFile();
        String filepath = configIFile.getLocation().toOSString();
        if (!configIFile.exists()) {
            this.hasXmlError = true;
            return;
        }
        try {
            File cfgFile = new File(filepath);
            ConfigParser localParser = new ConfigParser(cfgFile, (InputStream)configInputStream);
            localParser.getLogFormat();
        }
        catch (Exception e) {
            this.hasXmlError = true;
            if (e instanceof LogFormatException) {
                LogFormatException lfe = (LogFormatException)e;
                this.createProblemMarker(lfe);
            }
            if (e.getCause() != null && e.getCause() instanceof LogFormatException) {
                LogFormatException lfe = (LogFormatException)e.getCause();
                this.createProblemMarker(lfe);
            }
            this.createProblemMarker(-1, e.getMessage());
        }
    }

    void syncTableViewerPage() {
        this.hasXmlError = false;
        this.removeProblemMarkers();
        String editorText = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
        byte[] editorByteArr = editorText.getBytes();
        ByteArrayInputStream configInputStream = new ByteArrayInputStream(editorByteArr);
        Composite composite = new Composite(this.getContainer(), 0);
        this.cfgParser = null;
        this.myLogFormat = null;
        this.myLogTableViewer = null;
        String title = this.getEditorInput().getName();
        this.setPartName(title);
        IFile configIFile = ((FileEditorInput)this.editor.getEditorInput()).getFile();
        String filepath = configIFile.getLocation().toOSString();
        if (!configIFile.exists()) {
            return;
        }
        try {
            File cfgFile = new File(filepath);
            this.cfgParser = new ConfigParser(cfgFile, (InputStream)configInputStream);
            this.logFileMgr = new UiLogFileManager(this.cfgParser);
            this.myLogFormat = this.cfgParser.getLogFormat();
            this.namedLogFilters = this.cfgParser.getLogFilters();
            this.myLogTableViewer = new LogTableViewer(this, composite, this.myLogFormat, this.logFileMgr, this.getSite(), this.namedLogFilters);
            this.getSite().setSelectionProvider((ISelectionProvider)this.myLogTableViewer.getJfaceTableViewer());
            LogSystemType systemType = this.cfgParser.getSystemType();
            String logFileName = this.myLogFormat.getName();
            String system = systemType.getSystem();
            String version = systemType.getVersion();
            StringBuffer beaconSB = new StringBuffer();
            beaconSB.append(logFileName);
            beaconSB.append(",");
            beaconSB.append(system);
            beaconSB.append(",");
            beaconSB.append(version);
            HttpLogger.logActivity((String)"vlogbrowser", (String)"OpenLogFile", (String)beaconSB.toString());
        }
        catch (Exception e) {
            this.hasXmlError = true;
            if (e instanceof LogFormatException) {
                LogFormatException lfe = (LogFormatException)e;
                this.createProblemMarker(lfe);
            }
            if (e.getCause() != null && e.getCause() instanceof LogFormatException) {
                LogFormatException lfe = (LogFormatException)e.getCause();
                this.createProblemMarker(lfe);
            }
            this.createProblemMarker(-1, e.getMessage());
        }
        this.setControl(0, (Control)composite);
        if (!this.hasXmlError) {
            LogLoadRunner llRunner = new LogLoadRunner(this.myLogTableViewer, false, "Loading Log Files...");
            llRunner.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IStatus result = event.getResult();
                    if (result.getCode() == 4) {
                        LogBrowserUiPlugin.log(result.getException());
                    }
                }
            });
            llRunner.schedule();
        }
        this.hasConfigFileChangedSinceTableSync = false;
    }

    int createXMLEditorPage() throws PartInitException {
        int pageIndex = this.addPage((IEditorPart)this.editor, this.getEditorInput());
        this.setPageText(pageIndex, this.editor.getTitle());
        return pageIndex;
    }

    protected void createPages() {
        try {
            IEditorInput input = this.getEditorInput();
            if (input != null && input instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                try {
                    IFile file = fileInput.getFile();
                    if (!file.isSynchronized(1)) {
                        file.refreshLocal(1, null);
                    }
                }
                catch (CoreException coreException) {}
            }
            this.editor = new XMLEditor();
            this.createXMLEditorPage();
            this.createLogTableViewerPage(0);
            IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
            contextService.activateContext("com.vmware.vide.vlogbrowser.contexts.kb");
        }
        catch (PartInitException e) {
            e.printStackTrace();
            LogBrowserUiPlugin.log(e);
        }
    }

    protected void pageChange(int newPageIndex) {
        if (newPageIndex == 0) {
            if (this.isEditorDirty()) {
                super.setActivePage(1);
                super.pageChange(1);
                StatusLineContributionItem statusLineItem = new StatusLineContributionItem(LOG_BROWSER_STATUS_ID);
                statusLineItem.setText(MUST_SAVE_EDITOR_MSG);
                IActionBars actionBars = this.getEditorSite().getActionBars();
                IStatusLineManager manager = actionBars.getStatusLineManager();
                manager.add((IContributionItem)statusLineItem);
                actionBars.updateActionBars();
                return;
            }
            if (this.hasConfigFileChangedSinceTableSync) {
                this.syncTableViewerPage();
            }
            if (this.hasXmlError) {
                super.setActivePage(1);
                super.pageChange(1);
                return;
            }
        }
        super.pageChange(newPageIndex);
    }

    public void dispose() {
        try {
            if (this.myLogFormat != null) {
                this.myLogFormat.closeAllRandAccFiles();
            }
            this.myLogTableViewer = null;
            this.myLogFormat = null;
            this.editor = null;
            System.gc();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(1).doSave(monitor);
        this.checkConfigFile();
        IActionBars actionBars = this.getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager.remove(LOG_BROWSER_STATUS_ID) != null) {
            actionBars.updateActionBars();
        }
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(1);
        editor.doSaveAs();
        this.setPageText(1, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    private boolean isEditorDirty() {
        IEditorInput input = this.getEditorInput();
        if (input != null && input instanceof IFileEditorInput) {
            IWorkbenchWindow[] wbWindows;
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            IWorkbenchWindow[] iWorkbenchWindowArray = wbWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = wbWindows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n2];
                IWorkbenchPage activePage = wbWindow.getActivePage();
                if (activePage != null) {
                    IEditorReference[] editorRefs;
                    IEditorReference[] iEditorReferenceArray = editorRefs = activePage.getEditorReferences();
                    int n3 = editorRefs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IEditorReference editorRef = iEditorReferenceArray[n4];
                        if (editorRef.isDirty()) {
                            IEditorInput editorInput = null;
                            try {
                                editorInput = editorRef.getEditorInput();
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                            if (editorInput != null && editorInput instanceof FileEditorInput && ((IFileEditorInput)editorInput).getFile().equals((Object)file)) {
                                return true;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        int kind;
        FileEditorInput editorInput;
        IFile file;
        IResourceDelta fileDelta;
        IResourceDelta delta;
        if (this.editor == null) {
            return;
        }
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = LogBrowserEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        FileEditorInput editorInput = (FileEditorInput)LogBrowserEditor.this.editor.getEditorInput();
                        IFile file = editorInput.getFile();
                        IResource resource = event.getResource();
                        if (file.getProject().equals((Object)resource)) {
                            LogBrowserEditor.this.removeProblemMarkers(file);
                            IWorkbenchPage page = pages[i];
                            IEditorPart editorPart = page.findEditor((IEditorInput)editorInput);
                            page.closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        } else if (event.getType() == 1 && (delta = event.getDelta()) != null && (fileDelta = delta.findMember((file = (editorInput = (FileEditorInput)this.editor.getEditorInput()).getFile()).getFullPath())) != null && (kind = fileDelta.getKind()) == 4) {
            this.hasConfigFileChangedSinceTableSync = true;
        }
    }

    public LogTableViewer getLogTableViewer() {
        return this.myLogTableViewer;
    }

    public void findByDateInOtherEditors(Date findDate) {
        if (findDate == null) {
            return;
        }
        for (LogBrowserEditor vlbEditor : this.getOtherOpenVLBEditors()) {
            if (!vlbEditor.getLogTableViewer().isKeepSynched()) continue;
            vlbEditor.getLogTableViewer().findClosestDate(findDate);
        }
    }

    public void overwriteTextInEditor(String newEditorText) {
        this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set(newEditorText);
        this.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public void saveDateDelta(long dateDelta) throws Exception {
        this.cfgParser.updateDateDelta(dateDelta);
        this.overwriteTextInEditor(this.cfgParser.getXmlFromDocument());
    }

    public void saveLogFilter(LogFilter logFilter) throws Exception {
        this.cfgParser.addLogFilterNode(logFilter);
        this.overwriteTextInEditor(this.cfgParser.getXmlFromDocument());
    }

    public void deleteLogFilter(String logFilterName) throws Exception {
        this.cfgParser.deleteLogFilter(logFilterName);
        this.overwriteTextInEditor(this.cfgParser.getXmlFromDocument());
    }

    public List<String> getLogFilterNames() {
        ArrayList<String> lfNames = new ArrayList<String>();
        for (String name : this.namedLogFilters.keySet()) {
            lfNames.add(name);
        }
        Collections.sort(lfNames);
        return lfNames;
    }

    public LogBrowserEditor getOtherOpenVLBEditor(String longTitle) {
        for (LogBrowserEditor vlbEditor : this.getOtherOpenVLBEditors()) {
            if (!vlbEditor.getLongTitle().equals(longTitle)) continue;
            return vlbEditor;
        }
        return null;
    }

    public LogFilter getLogFilter(String name) {
        return this.namedLogFilters.get(name);
    }

    public String getLongTitle() {
        return String.valueOf(this.myLogFormat.getName()) + ": " + this.editor.getTitleToolTip();
    }

    private List<LogBrowserEditor> getOtherOpenVLBEditors() {
        ArrayList<LogBrowserEditor> openVLBEditorList = new ArrayList<LogBrowserEditor>();
        IWorkbenchWindow[] myWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < myWindows.length) {
            IWorkbenchPage myPage = myWindows[i].getActivePage();
            IEditorReference[] myRefs = myPage.getEditorReferences();
            int j = 0;
            while (j < myRefs.length) {
                IEditorPart myPart = myRefs[j].getEditor(false);
                if (myPart instanceof LogBrowserEditor && !myPart.equals((Object)this)) {
                    openVLBEditorList.add((LogBrowserEditor)myPart);
                }
                ++j;
            }
            ++i;
        }
        return openVLBEditorList;
    }

    public String[] getOtherOpenVLBEditorNames() {
        ArrayList<String> openVLBEditorNameList = new ArrayList<String>();
        for (LogBrowserEditor vlbEditor : this.getOtherOpenVLBEditors()) {
            String editorName = vlbEditor.getLongTitle();
            openVLBEditorNameList.add(editorName);
        }
        Collections.sort(openVLBEditorNameList);
        return openVLBEditorNameList.toArray(new String[openVLBEditorNameList.size()]);
    }

    public String getConfigFilePath() {
        return this.cfgParser.getConfigFilePath();
    }

    public String getConfigFileName() {
        return this.cfgParser.getConfigFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProjectName() {
        LogBrowserEditor logBrowserEditor = this;
        synchronized (logBrowserEditor) {
            if (this.prjName == null) {
                IProject parentProject = ResourceUtils.findFileParentProject((String)this.getConfigFilePath());
                this.prjName = parentProject != null ? parentProject.getName() : "UNKNOWN";
            }
            return this.prjName;
        }
    }
}

