/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.preferences;

import com.vmware.vide.vlogbrowser.core.ILogBrowserManager;
import com.vmware.vide.vlogbrowser.core.LogBrowserPlugin;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LogBrowserPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table fTable;
    private Button fAdd;
    private Button fEdit;
    private Button fRemove;
    private static String lastBrowseDir;

    public LogBrowserPreferencePage() {
        this.setMessage("Log Browser");
        this.setTitle("Log Browser");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout g1 = new GridLayout(2, false);
        g1.marginWidth = 0;
        g1.marginHeight = 0;
        composite.setLayout((Layout)g1);
        Label description = new Label(composite, 64);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.widthHint = 400;
        data.horizontalSpan = 2;
        description.setLayoutData((Object)data);
        description.setText("Specify folders to scan for custom log template files (*.logx):");
        this.fTable = new Table(composite, 67584);
        this.fTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn tblclmnPath = new TableColumn(this.fTable, 0);
        tblclmnPath.setWidth(400);
        tblclmnPath.setText("Path");
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        composite2.setBounds(0, 0, 64, 64);
        GridLayout g2 = new GridLayout(1, false);
        g2.marginWidth = 0;
        g2.marginHeight = 0;
        composite2.setLayout((Layout)g2);
        this.fAdd = new Button(composite2, 0);
        GridData g3 = new GridData(4, 0x1000000, false, false, 1, 1);
        g3.widthHint = 100;
        this.fAdd.setLayoutData((Object)g3);
        this.fAdd.setText("&Add...");
        this.fAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogBrowserPreferencePage.this.addFolder();
            }
        });
        this.fEdit = new Button(composite2, 0);
        this.fEdit.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fEdit.setText("&Edit...");
        this.fEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogBrowserPreferencePage.this.editFolder();
            }
        });
        this.fRemove = new Button(composite2, 0);
        this.fRemove.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fRemove.setText("&Remove");
        this.fRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogBrowserPreferencePage.this.removeFolder();
            }
        });
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.initContents();
        this.validatePage();
        return composite;
    }

    private void initContents() {
        ILogBrowserManager manager = LogBrowserPlugin.getDefault().getLogBrowserManager();
        String[] dirs = manager.getCustomTemplateDirs();
        if (dirs == null) {
            return;
        }
        int i = 0;
        while (i < dirs.length) {
            String dir = dirs[i];
            TableItem item = new TableItem(this.fTable, 0);
            item.setText(dir);
            ++i;
        }
        if (this.fTable.getItemCount() > 0) {
            this.fTable.setSelection(0);
        }
    }

    private void validatePage() {
        int selection = this.fTable.getSelectionIndex();
        boolean hasSelectedItem = selection >= 0;
        this.fAdd.setEnabled(true);
        this.fEdit.setEnabled(hasSelectedItem);
        this.fRemove.setEnabled(hasSelectedItem);
    }

    protected void performDefaults() {
        this.fTable.removeAll();
        this.initContents();
    }

    public boolean performOk() {
        int nItems = this.fTable.getItemCount();
        String[] dirs = new String[nItems];
        int i = 0;
        while (i < dirs.length) {
            TableItem item = this.fTable.getItem(i);
            dirs[i] = item.getText();
            ++i;
        }
        LogBrowserPlugin.getDefault().getLogBrowserManager().setCustomTemplateDirs(dirs);
        return super.performOk();
    }

    private void addFolder() {
        if (lastBrowseDir == null) {
            IPath workspaceLoc = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            lastBrowseDir = workspaceLoc.removeLastSegments(1).toOSString();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setText("Add Folder");
        dialog.setFilterPath(lastBrowseDir);
        String result = dialog.open();
        if (result == null) {
            return;
        }
        TableItem item = new TableItem(this.fTable, 0);
        item.setText(result);
        this.fTable.setSelection(item);
        lastBrowseDir = result;
        this.validatePage();
    }

    private void editFolder() {
        TableItem[] selection = this.fTable.getSelection();
        if (selection.length == 0) {
            return;
        }
        TableItem item = selection[0];
        String dir = item.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setFilterPath(dir);
        dialog.setText("Edit Folder");
        String result = dialog.open();
        if (result != null) {
            item.setText(result);
        }
        this.validatePage();
    }

    private void removeFolder() {
        int selection = this.fTable.getSelectionIndex();
        if (selection < 0) {
            return;
        }
        this.fTable.remove(selection);
        if (selection <= this.fTable.getItemCount()) {
            selection = this.fTable.getItemCount() - 1;
        }
        if (selection >= 0 && selection < this.fTable.getItemCount()) {
            this.fTable.setSelection(selection);
        }
        this.validatePage();
    }
}

