/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.syslog;

import com.vmware.vide.vlogbrowser.ui.syslog.ISyslogListener;
import com.vmware.vide.vlogbrowser.ui.syslog.SyslogMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SyslogCollector
extends Thread {
    private boolean isJobFinished = false;
    ArrayList<ISyslogListener> fListeners = new ArrayList();
    private DatagramSocket fSocket;

    @Override
    public synchronized void start() {
    }

    public synchronized void start2() throws SocketException {
        this.fSocket = new DatagramSocket(514);
        this.fSocket.setSoTimeout(100);
        super.start();
    }

    public void addListener(ISyslogListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(ISyslogListener listener) {
        this.fListeners.remove(listener);
    }

    @Override
    public void run() {
        this.setName("SyslogCollector");
        try {
            byte[] data = new byte[1024];
            while (!this.isJobFinished()) {
                DatagramPacket packet = new DatagramPacket(data, data.length);
                try {
                    this.fSocket.receive(packet);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    continue;
                }
                byte[] strippedData = new byte[packet.getLength()];
                System.arraycopy(data, 0, strippedData, 0, strippedData.length);
                String message = new String(strippedData);
                SyslogMessage msg = this.parseMessage(message, packet.getAddress(), packet.getPort());
                this.fireEvent(msg, message);
            }
            this.fSocket.close();
            this.fSocket = null;
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void fireEvent(SyslogMessage msg, String text) {
        int i = 0;
        while (i < this.fListeners.size()) {
            ISyslogListener l = this.fListeners.get(i);
            l.messageReceived(msg, text);
            ++i;
        }
    }

    public SyslogMessage parseMessage(String message, InetAddress address, int port) {
        int severity;
        int facility;
        int i;
        SyslogMessage sysMsg = null;
        String hostName = address.getHostName();
        Pattern p = Pattern.compile("<(\\d\\d\\d)>.*(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\\d\\d|\\d) (\\d\\d):(\\d\\d):(\\d\\d) (\\d+) ([^:]*): (.*)");
        Matcher m = p.matcher(message);
        if (m.find() && (i = m.groupCount()) == 9) {
            facility = Integer.valueOf(m.group(1)) / 8;
            severity = Integer.valueOf(m.group(1)) % 8;
            String month = m.group(2);
            String day = m.group(3);
            String time = String.valueOf(m.group(4)) + ":" + m.group(5) + ":" + m.group(6);
            String year = m.group(7);
            String source = m.group(8);
            String content = m.group(9);
            sysMsg = new SyslogMessage(facility, severity, String.valueOf(year) + " " + month + " " + day + " " + time, hostName, source, content, address, port, message);
        }
        if (sysMsg == null && (m = (p = Pattern.compile("<(\\d\\d\\d*)>([^:]*): (.*)")).matcher(message)).find() && (i = m.groupCount()) == 3) {
            facility = Integer.valueOf(m.group(1)) / 8;
            severity = Integer.valueOf(m.group(1)) % 8;
            String source = m.group(2);
            String content = m.group(3);
            sysMsg = new SyslogMessage(facility, severity, "", hostName, source, content, address, port, message);
        }
        return sysMsg;
    }

    public synchronized boolean isJobFinished() {
        return this.isJobFinished;
    }

    public synchronized void setJobFinished(boolean finish) {
        this.isJobFinished = finish;
    }
}

