/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.tableviewer;

import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import java.io.IOException;
import java.util.Comparator;

public class LogItemSortComparator
implements Comparator<LogItem> {
    private int columnIndex;
    private int sortDirection;
    private LogFormat logFormat;
    private int logIndexColumnNumber;

    public LogItemSortComparator(int columnIndex, int sortDirection, LogFormat logFormat) {
        this.columnIndex = columnIndex;
        this.sortDirection = sortDirection;
        this.logFormat = logFormat;
        this.logIndexColumnNumber = logFormat.getLogIndexColumnIndex();
    }

    @Override
    public int compare(LogItem firstItem, LogItem secondItem) {
        int sortResult = 0;
        try {
            Comparable comp1 = firstItem.getLogFieldComparable(this.columnIndex, this.logFormat);
            Comparable comp2 = secondItem.getLogFieldComparable(this.columnIndex, this.logFormat);
            sortResult = comp1.compareTo(comp2);
            if (sortResult == 0) {
                comp1 = firstItem.getLogFieldComparable(this.logIndexColumnNumber, this.logFormat);
                comp2 = secondItem.getLogFieldComparable(this.logIndexColumnNumber, this.logFormat);
                sortResult = comp1.compareTo(comp2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        if (this.sortDirection == 128) {
            return sortResult;
        }
        return -sortResult;
    }
}

