/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.views;

import com.vmware.vide.utils.net.HttpLogger;
import com.vmware.vide.vlogbrowser.core.chart.ILogFile;
import com.vmware.vide.vlogbrowser.core.chart.ILogItemListener;
import com.vmware.vide.vlogbrowser.core.model.util.IFilteredList;
import com.vmware.vide.vlogbrowser.ui.chart.LogChartController;
import com.vmware.vide.vlogbrowser.ui.chart.LogDatasetManager;
import com.vmware.vide.vlogbrowser.ui.chart.LogSubplot;
import com.vmware.vide.vlogbrowser.ui.dialogs.SelectLogsForChartDialog;
import com.vmware.vide.vlogbrowser.ui.editors.LogBrowserEditor;
import com.vmware.vide.vlogbrowser.ui.tableviewer.IParserJobListener;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import com.vmware.vide.vlogbrowser.ui.tableviewer.ParserJobListener;
import com.vmware.vide.vlogbrowser.ui.views.LogBrowserFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jfree.data.time.DateRange;

public class LogActivityGraph
extends ViewPart
implements ILogItemListener,
IParserJobListener,
IPartListener {
    private LogChartController logChartController;
    private AddChartAction addChartAction;

    public void createPartControl(Composite parent) {
        this.logChartController = new LogChartController(parent);
        this.logChartController.addLogItemListener(this);
        this.addChartAction = new AddChartAction(this);
        this.enableCommands();
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.addChartAction);
        this.addListeners();
    }

    private void addListeners() {
        IWorkbenchPage myWorkbenchPage = this.getSite().getPage();
        myWorkbenchPage.addPartListener((IPartListener)this);
        List<LogBrowserEditor> listEditors = this.getOpenEditors();
        for (LogBrowserEditor editor : listEditors) {
            LogTableViewer tableViewer = editor.getLogTableViewer();
            if (tableViewer == null) continue;
            ParserJobListener parserJob = tableViewer.getParserJobListener();
            parserJob.addListener(this);
            tableViewer.addFilterListener(this.logChartController);
        }
    }

    private void enableCommands() {
        boolean enabled = this.isCommandsReadyToBeEnabled();
        this.addChartAction.setEnabled(enabled);
    }

    public void setFocus() {
    }

    private List<LogBrowserEditor> getOpenEditors() {
        IEditorReference[] myEditorReferences;
        LinkedList<LogBrowserEditor> listLogBrowserEditors = new LinkedList<LogBrowserEditor>();
        IWorkbenchPage myWorkbenchPage = this.getSite().getPage();
        IEditorReference[] iEditorReferenceArray = myEditorReferences = myWorkbenchPage.getEditorReferences();
        int n = myEditorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(false);
            if (editor instanceof LogBrowserEditor) {
                LogBrowserEditor logBrowserEditor = (LogBrowserEditor)editor;
                listLogBrowserEditors.add(logBrowserEditor);
            }
            ++n2;
        }
        return listLogBrowserEditors;
    }

    public LogChartController getLogChartContainer() {
        return this.logChartController;
    }

    public void mouseClicked(ILogFile logFile, Date logDate) {
        if (logFile instanceof LogBrowserFile) {
            LogBrowserFile logBrowserFile = (LogBrowserFile)logFile;
            LogBrowserEditor editor = logBrowserFile.getEditor();
            IEditorSite site = editor.getEditorSite();
            site.getPage().bringToTop((IWorkbenchPart)editor);
            LogTableViewer viewer = editor.getLogTableViewer();
            viewer.findClosestDate(logDate);
        }
    }

    private boolean isCommandsReadyToBeEnabled() {
        List<LogBrowserEditor> listEditors = this.getOpenEditors();
        if (listEditors.size() == 0) {
            return false;
        }
        for (LogBrowserEditor editor : listEditors) {
            ParserJobListener parserJob;
            ParserJobListener.ParserJobState jobState;
            LogTableViewer viewer = editor.getLogTableViewer();
            if (viewer == null || (jobState = (parserJob = viewer.getParserJobListener()).getJobState()) != ParserJobListener.ParserJobState.INITIAL && jobState != ParserJobListener.ParserJobState.SCHEDULED && jobState != ParserJobListener.ParserJobState.RUNNING) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        this.removeListeners();
        this.logChartController = null;
        this.addChartAction = null;
        super.dispose();
    }

    private void removeListeners() {
        IWorkbenchPage myWorkbenchPage = this.getSite().getPage();
        myWorkbenchPage.removePartListener((IPartListener)this);
        List<LogBrowserEditor> listEditors = this.getOpenEditors();
        for (LogBrowserEditor editor : listEditors) {
            LogTableViewer tableViewer = editor.getLogTableViewer();
            if (tableViewer == null) continue;
            ParserJobListener parserJob = tableViewer.getParserJobListener();
            parserJob.removeListener(this);
            tableViewer.removeFilterListener(this.logChartController);
        }
        this.logChartController.removeLogItemListener(this);
    }

    public void partOpened(IWorkbenchPart part) {
        LogBrowserEditor editor;
        LogTableViewer tableViewer;
        if (part instanceof LogBrowserEditor && (tableViewer = (editor = (LogBrowserEditor)part).getLogTableViewer()) != null) {
            ParserJobListener parserJob = tableViewer.getParserJobListener();
            parserJob.addListener(this);
            tableViewer.addFilterListener(this.logChartController);
            this.enableCommands();
        }
    }

    public void partClosed(IWorkbenchPart part) {
        LogBrowserEditor editor;
        LogTableViewer tableViewer;
        if (part instanceof LogBrowserEditor && (tableViewer = (editor = (LogBrowserEditor)part).getLogTableViewer()) != null) {
            ParserJobListener parserJob = tableViewer.getParserJobListener();
            parserJob.removeListener(this);
            tableViewer.removeFilterListener(this.logChartController);
            List<LogSubplot> listSubplots = this.logChartController.getListSubplot();
            int i = listSubplots.size() - 1;
            while (i >= 0) {
                LogSubplot subplot = listSubplots.get(i);
                LogBrowserFile logFile = (LogBrowserFile)subplot.getLogFile();
                LogBrowserEditor logFileEditor = logFile.getEditor();
                if (((Object)((Object)editor)).equals((Object)logFileEditor)) {
                    this.logChartController.removePlot(subplot);
                }
                --i;
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    @Override
    public void parserScheduled() {
        this.enableCommands();
    }

    @Override
    public void parserRunning() {
        this.enableCommands();
    }

    @Override
    public void parserDone(List<Object> listObjects) {
        List<LogSubplot> listSubplot = this.logChartController.getListSubplot();
        block0: for (Object obj : listObjects) {
            if (!(obj instanceof IEditorPart)) continue;
            IEditorPart editor = (IEditorPart)obj;
            for (final LogSubplot subplot : listSubplot) {
                LogBrowserFile logFile = (LogBrowserFile)subplot.getLogFile();
                if (!editor.equals((Object)logFile.getEditor())) continue;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LogActivityGraph.this.logChartController.updatePlot(subplot);
                    }
                });
                continue block0;
            }
        }
        this.enableCommands();
    }

    private class AddChartAction
    extends Action {
        LogActivityGraph logActivityGraph;

        public AddChartAction(LogActivityGraph logActivityGraph2) {
            String text = "Add Chart...";
            this.logActivityGraph = logActivityGraph2;
            this.setToolTipText(text);
            this.setText(text);
            this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/obj16/add_obj.gif"));
        }

        public void run() {
            ArrayList<ILogFile> listLogFile = new ArrayList<ILogFile>();
            List listOpenEditors = this.logActivityGraph.getOpenEditors();
            for (LogBrowserEditor editor : listOpenEditors) {
                LogBrowserFile logFile = new LogBrowserFile(editor);
                IFilteredList filterList = logFile.getFilterList();
                if (filterList == null) continue;
                int nItems = filterList.getUnfiltered().size();
                DateRange dateRange = LogDatasetManager.getDateRange(logFile);
                if (nItems <= 0 || dateRange == null) continue;
                listLogFile.add(logFile);
            }
            SelectLogsForChartDialog selector = new SelectLogsForChartDialog(LogActivityGraph.this.getSite().getShell(), LogActivityGraph.this.logChartController, listLogFile);
            selector.open();
            HttpLogger.logActivity((String)"vlogbrowser", (String)"OpenGraph");
        }
    }
}

