/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.wizards;

import com.vmware.vide.utils.net.HttpLogger;
import com.vmware.vide.vlogbrowser.core.fileops.LogxFileSetCreator;
import com.vmware.vide.vlogbrowser.core.model.LogxFile;
import com.vmware.vide.vlogbrowser.ui.wizards.LBNewWizardFinishPage;
import com.vmware.vide.vlogbrowser.ui.wizards.LBNewWizardPathPage;
import com.vmware.vide.vlogbrowser.ui.wizards.LBNewWizardStartPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public class LogBrowserNewWizard
extends Wizard
implements INewWizard {
    private ISelection selection;
    public static final String STANDARD_LOG_SET = "Standard Log Set";
    public static final String VMSUPPORT_LOG_SET = "vm-support Log Set";
    private LBNewWizardStartPage fStartPage;
    private LBNewWizardPathPage fPathPath;
    private LBNewWizardFinishPage fFinishPage;

    public LogBrowserNewWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Log Analysis");
    }

    public void addPages() {
        this.fStartPage = new LBNewWizardStartPage(this.selection);
        this.addPage((IWizardPage)this.fStartPage);
        this.fPathPath = new LBNewWizardPathPage(this.selection);
        this.addPage((IWizardPage)this.fPathPath);
        this.fFinishPage = new LBNewWizardFinishPage(this.selection, (IWizardPage)this.fStartPage, (IWizardPage)this.fPathPath);
        this.addPage((IWizardPage)this.fFinishPage);
        this.fStartPage.setNextTwoPages((IWizardPage)this.fPathPath, (IWizardPage)this.fFinishPage);
    }

    public boolean performFinish() {
        final ArrayList<IFile> newLogxFilesInProject = new ArrayList<IFile>();
        final List<LogxFile> lxFiles = this.fFinishPage.getLogxFileList();
        final String containerName = this.fStartPage.getProjectContainer();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                monitor.beginTask("Opening log files", lxFiles.size());
                for (LogxFile lxFile : lxFiles) {
                    if (!lxFile.isCreateThisFile()) {
                        monitor.worked(1);
                        continue;
                    }
                    try {
                        IFile createdFile = LogBrowserNewWizard.this.openFile(containerName, lxFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (createdFile == null) continue;
                        newLogxFilesInProject.add(createdFile);
                    }
                    catch (CoreException e) {
                        monitor.done();
                        throw new InvocationTargetException(e);
                    }
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        if (!newLogxFilesInProject.isEmpty() && ((IFile)newLogxFilesInProject.get(0)).exists()) {
            this.expandProjectSelectFiles(newLogxFilesInProject);
        }
        String hostSystemType = this.fStartPage.getHostTypeAndVersion();
        HttpLogger.logActivity((String)"vlogbrowser", (String)"AccessHostType", (String)hostSystemType);
        return true;
    }

    private IFile openFile(String containerName, LogxFile lxFile, IProgressMonitor monitor) throws CoreException {
        String tmpFileName;
        boolean openEditor = lxFile.isOpenEditor();
        try {
            if (!LogxFileSetCreator.createLogxFile((String)containerName, (LogxFile)lxFile, null, (IProgressMonitor)monitor)) {
                return null;
            }
        }
        catch (Exception e1) {
            this.throwCoreException(e1.getMessage());
        }
        if (!(tmpFileName = lxFile.getLogxFileName()).endsWith(".logx")) {
            tmpFileName = String.valueOf(tmpFileName) + ".logx";
        }
        String fileName = tmpFileName;
        IContainer container = (IContainer)LogxFileSetCreator.getLogxResource((String)containerName);
        final IFile file = container.getFile((IPath)new Path(fileName));
        if (openEditor) {
            monitor.setTaskName("Opening " + fileName + "...");
            this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        monitor.worked(1);
        monitor.done();
        return file;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.vmware.vide.vlogbrowser.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    protected String getChosenSrcHost() {
        return this.fStartPage.getSrcHostChoice();
    }

    protected LogxFile getSelectedLogFormat() {
        return this.fStartPage.getLogFormatChoice();
    }

    protected String getSelectedLogFormatName() {
        return this.fStartPage.getSelectedLogFormatName();
    }

    protected String getChosenProjectContainer() {
        return this.fStartPage.getProjectContainer();
    }

    protected String getRseLocalConnName() {
        return this.fStartPage.getRseLocalConnName();
    }

    protected String getSrcHostType() {
        return this.fStartPage.getSrcHostType();
    }

    protected boolean getSrcSupportSsh() {
        return this.fStartPage.getSrcSupportSsh();
    }

    protected String getParentDir() {
        return this.fPathPath.getParentDir();
    }

    protected String getFilePatterns() {
        return this.fPathPath.getFilePatterns();
    }

    protected String getTGZFilepath() {
        return this.fPathPath.getTGZFilepath();
    }

    private void expandProjectSelectFiles(final List<IFile> myCreatedLogxFiles) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewPart myProjectTree = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
                    if (!(myProjectTree != null && page.isPartVisible((IWorkbenchPart)myProjectTree) || (myProjectTree = page.findView("org.eclipse.ui.views.ResourceNavigator")) != null && page.isPartVisible((IWorkbenchPart)myProjectTree))) {
                        return;
                    }
                    ISetSelectionTarget mySelectionTarget = (ISetSelectionTarget)myProjectTree;
                    StructuredSelection lxFilesSelection = new StructuredSelection(myCreatedLogxFiles);
                    mySelectionTarget.selectReveal((ISelection)lxFilesSelection);
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)LogBrowserNewWizard.this.getShell(), (String)"Error showing .logx file in project", (String)e.getMessage());
                    e.printStackTrace();
                }
            }
        });
    }
}

