/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DetailedMessageDialog
extends MessageDialog {
    private String message;

    public DetailedMessageDialog(Shell shell, String title, Image image, String message, int type, String[] buttonLabels, int index) {
        super(shell, title, image, message, type, buttonLabels, index);
    }

    protected Control createCustomArea(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 200;
        Text text = new Text(parent, 2826);
        text.setLayoutData((Object)data);
        if (this.message.length() > 0) {
            text.setText(this.message);
        }
        return text;
    }

    public void setMessage(String newMessage) {
        this.message = newMessage;
    }

    public static void displayDialog(String title, String msg, int type, Exception e, boolean async) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        DetailedMessageDialog.displayDialog(title, msg, type, writer.toString(), async);
    }

    public static void displayDialog(final String title, final String msg, final int type, final String copyMsg, boolean async) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                DetailedMessageDialog dialog = new DetailedMessageDialog(shell, title, null, msg, type, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.setMessage(copyMsg);
                dialog.open();
            }
        };
        if (async) {
            Display.getDefault().asyncExec(runnable);
        } else {
            Display.getDefault().syncExec(runnable);
        }
    }
}

