/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import com.vmware.vide.utils.ui.WBOption;
import java.io.File;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FileOption
extends WBOption {
    String value;
    Text text;
    Button browse;

    public FileOption(final Composite composite, String labelValue, String id, final boolean save) {
        super(id);
        Label label = new Label(composite, 0);
        label.setText(labelValue);
        this.text = new Text(composite, 2048);
        GridData gd = new GridData(4, 0, true, false);
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileOption.this.notifyModifyListeners(e);
            }
        });
        this.browse = new Button(composite, 8);
        this.browse.setText(" ... ");
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(composite.getShell(), save ? 8192 : 4096);
                dlg.setFilterPath(FileOption.this.text.getText());
                String f = dlg.open();
                if (f == null) {
                    return;
                }
                String filePath = String.valueOf(dlg.getFilterPath()) + File.separator + dlg.getFileName();
                FileOption.this.text.setText(filePath);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public Widget getWidget() {
        return this.text;
    }

    @Override
    public void setValue(String value) {
        this.text.setText(value);
    }

    @Override
    public String getValue() {
        final String[] result = new String[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = FileOption.this.text.getText();
            }
        });
        return result[0];
    }
}

