/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import com.vmware.vide.utils.ui.WBOption;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StringOption
extends WBOption {
    Text text;

    public StringOption(Composite composite, String labelValue, String id, String initialValue) {
        super(id);
        Label label = new Label(composite, 0);
        label.setText(labelValue);
        this.text = new Text(composite, 2048);
        GridData gd = new GridData(4, 0, true, false);
        GridLayout parentLayout = (GridLayout)composite.getLayout();
        gd.horizontalSpan = parentLayout.numColumns - 1;
        this.text.setLayoutData((Object)gd);
        if (initialValue != null) {
            this.text.setText(initialValue);
        }
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StringOption.this.notifyModifyListeners(e);
            }
        });
    }

    public Widget getWidget() {
        return this.text;
    }

    @Override
    public void setValue(String value) {
        this.text.setText(value);
    }

    @Override
    public String getValue() {
        final String[] result = new String[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = StringOption.this.text.getText();
            }
        });
        return result[0];
    }
}

