/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui.supportbundle;

import com.vmware.vide.logging.supportbundle.StringBundleContribution;
import com.vmware.vide.logging.supportbundle.SupportBundleRegistry;
import com.vmware.vide.utils.ui.supportbundle.SupportBundleCreationJob;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportBundleCreatorDialog
extends TitleAreaDialog {
    private static final Logger logger = LoggerFactory.getLogger(SupportBundleCreatorDialog.class);
    private Text txtDirectory;
    private Text txtIssuedetailstext;
    private String directory;
    private String details;
    private static final String DEFAULT_DETAILS_TEXT = "TODO";
    private static final String MESSAGE = "Provide detail on the issue you are facing and click OK to save to a file.  The support bundle contains information helpful for VMware support.";

    public SupportBundleCreatorDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gd_composite = new GridData(16384, 0x1000000, false, false);
        gd_composite.heightHint = 67;
        gd_composite.widthHint = 581;
        composite.setLayoutData((Object)gd_composite);
        Label lblDirectoryInWhich = new Label(composite, 0);
        lblDirectoryInWhich.setText("Directory in which to generate support bundle");
        new Label(composite, 0);
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode("com.vmware.vide.utils.ui");
        this.directory = prefs.get("SUPPORT_BUNDLE_DIR", System.getProperty("user.home"));
        this.txtDirectory = new Text(composite, 2048);
        this.txtDirectory.setText(this.directory);
        GridData gd_txtDirectory = new GridData(4, 0x1000000, true, false);
        gd_txtDirectory.widthHint = 433;
        this.txtDirectory.setLayoutData((Object)gd_txtDirectory);
        Button btnBrowse = new Button(composite, 0);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SupportBundleCreatorDialog.this.browseForDirectory();
            }
        });
        btnBrowse.setText("Browse");
        Composite detailsComposite = new Composite(container, 0);
        detailsComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gd_composite_1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_composite_1.widthHint = 584;
        gd_composite_1.heightHint = 231;
        detailsComposite.setLayoutData((Object)gd_composite_1);
        Label lblDetailsOfIssue = new Label(detailsComposite, 0);
        lblDetailsOfIssue.setText("Details of issue encountered (how to reproduce)");
        this.txtIssuedetailstext = new Text(detailsComposite, 2626);
        this.txtIssuedetailstext.setText(DEFAULT_DETAILS_TEXT);
        GridData gd_txtIssuedetailstext = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtIssuedetailstext.heightHint = 195;
        this.txtIssuedetailstext.setLayoutData((Object)gd_txtIssuedetailstext);
        this.setTitle("VMware Workbench Support Bundle Creator");
        this.resetMessage();
        return area;
    }

    private void resetMessage() {
        this.setMessage(MESSAGE, 1);
    }

    protected void okPressed() {
        File dir;
        this.details = this.txtIssuedetailstext.getText().replace("\r\n", "\n").trim();
        this.directory = this.txtDirectory.getText().trim();
        if (this.directory.contains("~")) {
            this.directory = this.directory.replace("~", System.getProperty("user.home"));
        }
        if (!(dir = new File(this.directory)).isDirectory()) {
            boolean sucessfullyCreated = false;
            String exceptionMessage = "";
            try {
                sucessfullyCreated = dir.mkdirs();
            }
            catch (Exception e) {
                exceptionMessage = e.getMessage();
            }
            if (!sucessfullyCreated) {
                this.setMessage("Unable to create directory '" + this.directory + "' " + exceptionMessage, 3);
                return;
            }
        }
        this.onGenerate();
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(590, 494);
    }

    protected void onGenerate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String outputFileName = "VMware-Workbench-Support-Bundle-" + dateFormat.format(new Date()) + ".zip";
        File outputFile = new File(this.directory, outputFileName);
        logger.info("----------- CREATED SUPPORT BUNDLE -----------------\nbundle={}", (Object)outputFile.getAbsolutePath());
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode("com.vmware.vide.utils.ui");
        prefs.put("SUPPORT_BUNDLE_DIR", this.directory);
        List contributions = SupportBundleRegistry.getInstance().getAllBundleContributions();
        if (!DEFAULT_DETAILS_TEXT.equals(this.details)) {
            contributions.add(new StringBundleContribution("details.txt", "users reported issue details", this.details));
        }
        SupportBundleCreationJob.DoneListener doneListener = new SupportBundleCreationJob.DoneListener(){

            @Override
            public void bundleCreationComplete(String fullPathToBundle, String errorMessage, Throwable e) {
                try {
                    int severity;
                    String msg;
                    if (errorMessage == null) {
                        msg = "Created support bundle " + fullPathToBundle;
                        severity = 0;
                    } else {
                        msg = errorMessage;
                        severity = 2;
                    }
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IMarker m = workspace.getRoot().createMarker("org.eclipse.core.resources.problemmarker");
                    m.setAttribute("message", (Object)msg);
                    m.setAttribute("priority", 0);
                    m.setAttribute("severity", severity);
                    this.showProblemsView();
                }
                catch (CoreException coreException) {}
            }

            private void showProblemsView() {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProblemView");
                        }
                        catch (Exception exception) {}
                    }
                });
            }
        };
        SupportBundleCreationJob job = new SupportBundleCreationJob("Create support bundle " + outputFile.getName(), outputFile, contributions, doneListener);
        job.schedule();
    }

    protected void browseForDirectory() {
        DirectoryDialog dlg = new DirectoryDialog(this.getShell());
        dlg.setText("Directory for support bundles");
        dlg.setFilterPath(this.txtDirectory.getText());
        String selectedDirectory = dlg.open();
        if (selectedDirectory != null) {
            this.directory = selectedDirectory;
            this.txtDirectory.setText(this.directory);
            this.resetMessage();
        }
    }
}

