/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui.supportbundle.contributor;

import com.vmware.vide.logging.supportbundle.ISupportBundleContribution;
import com.vmware.vide.utils.local.HostCommandRunner;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandOutputContribution
implements ISupportBundleContribution {
    private static final Logger logger = LoggerFactory.getLogger(CommandOutputContribution.class);
    private final String commandLine;
    private final String name;
    private final String description;

    public CommandOutputContribution(String name, String commandLine) {
        this.commandLine = commandLine;
        this.name = name;
        this.description = "Command '" + commandLine + "' output.";
    }

    public CommandOutputContribution(String name, String description, String commandLine) {
        this.commandLine = commandLine;
        this.name = name;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() {
        try {
            StringBuilder sb = new StringBuilder(2048);
            HostCommandRunner cmd = new HostCommandRunner();
            int retValue = cmd.runCommand(this.commandLine);
            sb.append("###############################################################################\n");
            sb.append("#### COMMAND: '").append(this.commandLine).append("'\n");
            sb.append("#### RETURN VALUE: ").append(Integer.toString(retValue)).append("\n");
            sb.append("################################ STDOUT #######################################\n");
            for (String line : cmd.getStdOutLines()) {
                sb.append(line).append("\n");
            }
            sb.append("################################ STDERR #######################################\n");
            for (String line : cmd.getStdErrLines()) {
                sb.append(line).append("\n");
            }
            sb.append("################################ EOF ##########################################\n");
            return new ByteArrayInputStream(sb.toString().getBytes());
        }
        catch (Exception e) {
            logger.error("Unexpected exception while running command '" + this.commandLine + "'", (Throwable)e);
            return null;
        }
    }
}

