/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui.supportbundle.contributor;

import com.vmware.vide.logging.supportbundle.ISupportBundleContribution;
import com.vmware.vide.utils.local.CommandStreamReader;
import com.vmware.vide.utils.local.HostCommandRunner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryListingBundleContribution
implements ISupportBundleContribution {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryListingBundleContribution.class);
    private final String name;
    private final String description;
    private final File directory;
    private final boolean recursive;
    private final boolean directoriesOnly;

    public DirectoryListingBundleContribution(String name, String description, File directory, boolean recursive, boolean directoriesOnly) {
        this.name = name;
        this.description = description;
        this.directory = directory;
        this.recursive = recursive;
        this.directoriesOnly = directoriesOnly;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() {
        if (this.directory == null || !this.directory.isDirectory()) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder(2048);
            for (String line : this.listDirectoryToStringList(this.directory, this.recursive, this.directoriesOnly)) {
                sb.append(line).append("\n");
            }
            return new ByteArrayInputStream(sb.toString().getBytes());
        }
        catch (Exception e) {
            logger.error("Unexpected exception while reading directory listings", (Throwable)e);
            return null;
        }
    }

    protected boolean isWindowsHost() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    private List<String> listDirectoryToStringList(File directory, boolean recursive, boolean directoriesOnly) throws Exception {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(directory.getAbsolutePath()) + " is not a directory.");
        }
        String command = this.isWindowsHost() ? "dir " + (recursive ? "/S " : " ") + directory.getAbsolutePath() : "ls -al" + (directoriesOnly ? "d" : "") + (recursive ? "R " : " ") + directory.getAbsolutePath();
        HostCommandRunner cmd = new HostCommandRunner();
        CommandStreamReader stdoutReader = new CommandStreamReader();
        CommandStreamReader stderrReader = new CommandStreamReader();
        int result = cmd.runCommand(command.toString(), null, stdoutReader, stderrReader, null, null);
        if (result == 0) {
            return cmd.getStdOutLines();
        }
        throw new Exception("Directory listing for '" + directory.getAbsolutePath() + " failed with " + result + ". stdout='" + cmd.getStdOutResult() + " stderr='" + cmd.getStdErrResult());
    }
}

